/* filename: SCREDIT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <scrnedit.h>

InfoType Info  = {
  NULL,
  NULL,
  FALSE,
  NULL,
  NULL
};

char CallingRoutine[16] = { 0 };
string10 GlobalScreenName = { 0 };
int ScreenHasGets = 0;

GetListPtr CurrentGet  = NULL;
InfoPtr InfoListTail  = NULL;
int InsideScreenEdit  = FALSE;
ScreenListPtr ScreenListHead  = NULL;

void ClearScreenGets(string10 ScreenName);
void DoScreenGets(string10 ScreenName, ScreenGetMode ScreenMode, void (* UserCallBack)(void));
void LoadScreenGets(string10 ScreenName, void * MemoryLoc,unsigned char LibraryNo);


void ScreenEdit(string10 ScreenName, void * MemoryLoc, unsigned char LibraryNo,
ScreenGetMode ScreenMode, void (* UserCallBack)(void))

/*  This procedure performs the "complete" Screen editing process.

1.  If the screen gets are already loaded, they are used and saved.
If they do not exist, then they are loaded and cleared after use.
2.  The screen is "popped".
3.  The fields are displayed (using SayGets)
4.  The appropriate ReadGets or ClearGets is called.
5.  The screen gets are cleared if appropriate.

NOTE:  Steps 1 and 2 occur in the LoadScreenGets procedure.
Steps 3 and 4 occur in the DoScreenGets procedure.     */
{
  InsideScreenEdit = TRUE;
  LoadScreenGets(ScreenName,MemoryLoc,LibraryNo);
  if (ScreenHasGets) {
    DoScreenGets(ScreenName, ScreenMode, UserCallBack);
    if (!Info.ScreenWasPresent)
      ClearScreenGets(ScreenName);
  }
  InsideScreenEdit = FALSE;
}
