/* filename: PSHPOPSC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;

void AllocateMemory(void ** LocPtr, unsigned Size);
void DeallocateMemory(void ** LocPtr, unsigned Size);

extern InfoPtr InfoListTail;

#ifndef _MSC_VER
#pragma warn -def
#endif

void PushScreenEdit(void)
{
  InfoPtr NewInfo;

  //  Make sure there is enough memory
  if (coreleft() < sizeof(InfoType))
    SetError(InsufficientMemory, 1, "[PushScreenEdit]");
  else {
    AllocateMemory((void **) &NewInfo, sizeof(InfoType));
    memmove(NewInfo, &Info, sizeof(InfoType));
    if (InfoListTail)
      NewInfo->LastInfoRecord = InfoListTail;
    InfoListTail = NewInfo;
  }
  Info.LastInfoRecord = NULL;
  Info.ScreenWasPresent = FALSE;
  Info.UserHelpProc = NULL;
  Info.UserValidateProc = NULL;
}

void PopScreenEdit(void)
{
  InfoPtr OldInfo;

  if (InfoListTail == NULL)
    SetError(InvalidOperation, 2, screen_edit_stack_empty, "[PopScreenEdit]");
  else {
    OldInfo = InfoListTail;
    InfoListTail = OldInfo->LastInfoRecord;
    OldInfo->LastInfoRecord = NULL;
    memcpy(&Info, OldInfo, sizeof(InfoType));
    Info = *OldInfo;
    DeallocateMemory((void **) &OldInfo, sizeof(InfoType));
  }
}
