/* filename: LOADSCRG.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#ifdef _MSC_VER
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;
extern char CallingRoutine[16];
extern string10 GlobalScreenName;
extern int ScreenHasGets;


extern GetListPtr CurrentGet;
extern int InsideScreenEdit;

ScreenListPtr SearchFor(string10 ScreenName);
void AllocateMemory(void ** LocPtr, unsigned Size);
void DeallocateMemory(void ** LocPtr, unsigned Size);
void AddGetRecord(GetRecord * SqzGet);

extern ScreenListPtr ScreenListHead;

void LoadScreenGets(string10 ScreenName, void * MemoryLoc,
unsigned char LibraryNo)
{
  ScreenListPtr LastHandle;
  GetListPtr SaveGet;
  ScreenListPtr SaveScreen;
  ScreenListPtr ScreenHandle;

  strcpy(CallingRoutine, InsideScreenEdit ? "ScreenEdit" : "LoadScreenGets");
  ScreenName = Upper(Trim(ScreenName));
  strcpy(GlobalScreenName, ScreenName); // used in AddGetRecord error messages
  // Make sure there is a database in the current area.
  if (!DBF()[0]) {
    SetError(NotInUse, 4, "[", CallingRoutine, "(", ScreenName, ")]");
    return;
  }
  ScreenHandle = SearchFor(ScreenName);
  Info.ScreenWasPresent = (ScreenHandle != NULL);
  if (Info.ScreenWasPresent && !InsideScreenEdit) {
    SetError(InvalidParameter, 6, screen_name_already_defined, "[",
    CallingRoutine, "(", ScreenName, ")]");
    return;
  }
  // If this is a new screen, then we need to setup the ScreenHandle entry
  // in the Screens linked list to receive the information about the Screen.
  if (!Info.ScreenWasPresent) {
    //  Make sure there is enough memory
    if (coreleft() < sizeof(ScreenList)) {
      SetError(InsufficientMemory, 5, "[", CallingRoutine, "(",
      GlobalScreenName, ")]");
      return;
    }
    AllocateMemory((void **) &ScreenHandle, sizeof(ScreenList));
    ScreenHandle->NextScreen = NULL;
    strcpy(ScreenHandle->ScreenName, ScreenName);
    ScreenHandle->ScreenGets = NULL;
    LastHandle = ScreenListHead; // and link it into the ScreenList
    if (!LastHandle)
      ScreenListHead = ScreenHandle;
    else {
      while (LastHandle->NextScreen)
        LastHandle = LastHandle->NextScreen;
      LastHandle->NextScreen = ScreenHandle;
    }
  }
  SaveScreen = Info.CurrentScreen;
  SaveGet = CurrentGet;
  Info.CurrentScreen = ScreenHandle;
  CurrentGet = NULL;
  // Finally, call the appropriate VIDPOP routine to load up the Get Records
  // Vidpop displays the Screen ONLY if
  if (!InsideScreenEdit) // we are begin called from "inside"
    SuppressDisplay = TRUE; // the ScreenEdit procedure.

  // If the screen GET records were not
  if (!Info.ScreenWasPresent) // already loaded, then we need to do
    SetUserGetProcTo(AddGetRecord); //  that as VIDPOP displays the screen

  if (!MemoryLoc)
    if (LibraryNo)
      PopLib(LibraryNo,ScreenName);
    else
      PopSqz(ScreenName);
    else
      if (LibraryNo)
        PopLibMem(MemoryLoc,ScreenName);
      else
        PopScreen(MemoryLoc);

  if (!InsideScreenEdit)
    SuppressDisplay = FALSE;
  if (!Info.ScreenWasPresent)
    SetUserGetProcTo(NULL);
  ScreenHasGets = (ScreenHandle->ScreenGets != NULL);
  if (!ScreenHasGets) {
    if (!InsideScreenEdit) {
      SetError(InvalidParameter, 6, found_no_data_fields_in_screen,
      "\"", ScreenName, "\" [", CallingRoutine, "]");
    }
    if (LastHandle == NULL)
      ScreenListHead = NULL;
    else
      LastHandle->NextScreen = NULL;
    DeallocateMemory((void **) &ScreenHandle, sizeof(ScreenList));
  }
  Info.CurrentScreen = SaveScreen;
  CurrentGet = SaveGet;
}
