/* filename: DOSCRGET.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <scrnedit.h>

extern InfoType Info;
extern GetListPtr CurrentGet;

static int SavedBASEOrder;

ScreenListPtr SearchFor(string10 ScreenName);

static void DoOneGet(ScreenGetMode ScreenMode, void (* UserCallBack)(void))
{
  DataDefinitionType DD;
  void * FieldLocation;
  int BlankFieldField, NoEditField, RequiredField;
  unsigned char SaveArea;
  int SayOrGetField;

  BlankFieldField = (CurrentGet->intMask & BlankFieldMask) != 0;
  NoEditField = (CurrentGet->intMask & NoEditMask) != 0;
  RequiredField = (CurrentGet->intMask & RequiredMask) != 0;
  SayOrGetField = (CurrentGet->intMask & SayOrGetMask) != 0;

  SaveArea = CurrentArea();
  if (CurrentGet->DBFAlias[0])
    SelectAlias(CurrentGet->DBFAlias);

  //  TRUE = a GET field
  //  if DISPLAYing, use At()'s
  if (SayOrGetField && (ScreenMode != DisplayMode)) {
    //  We don't change the colors for a GET - we use whatever the
    // user has set for the current colors.
    FieldLocation = FieldAddress(CurrentGet->FieldNum);
    // no Prompt
    SayGet(CurrentGet->Column, CurrentGet->Row, "", FieldLocation,
    CurrentGet->SayGetType, CurrentGet->FieldLength,
    CurrentGet->FieldDecimals);

    if (BlankFieldField)
      BlankField();
    if (RequiredField)
      Required();
    if (NoEditField)
      NoEdit();

    if (CurrentGet->PictureClause)
      Picture(CurrentGet->PictureClause);

    if (CurrentGet->RangeLower && CurrentGet->RangeUpper)
      Range(CurrentGet->RangeLower, CurrentGet->RangeUpper);
    else
      if (CurrentGet->RangeUpper)
        Range("", CurrentGet->RangeUpper);
      else
        if (CurrentGet->RangeLower)
          Range(CurrentGet->RangeLower, "");

    if (ScreenMode != DisplayMode)
      if (UserCallBack) {
        memset(&DD, 0, sizeof(DataDefinitionType));
        strcpy(DD.DBFAlias, CurrentGet->DBFAlias);
        strcpy(DD.FieldName, CurrentGet->FieldName);
        DD.Row = CurrentGet->Row;
        DD.Column = CurrentGet->Column;
        DataDefinition = &DD;
        dBASEOrder = SavedBASEOrder;

        UserCallBack();
        DataDefinition = NULL;
        dBASEOrder = FALSE;
        SetAutoHelpTo(DD.AutoHelpPtr);
        SetValidateTo(DD.ValidatePtr);
        if (DD.NoEdit)
          NoEdit();
        if (DD.BlankField)
          BlankField();
        if (DD.Required)
          Required();
        if (DD.Picture[0])
          Picture(DD.Picture);
        if (DD.LoRange[0] || DD.HiRange[0])
          Range(DD.LoRange,DD.HiRange);
      }
      else {
        SetValidateTo(Info.UserValidateProc);
        SetAutoHelpTo(Info.UserHelpProc);
      }
  }
  else { // It's either a SAY field, or we are in DisplayMode.
    // Since we are displaying a field, we use the colors that
    // were specified in the SQZ file.
    PushColors();
    SetColorTo(CurrentGet->Foreground, CurrentGet->BackGround,
    CurrentGet->Foreground,CurrentGet->BackGround);
    At(CurrentGet->Column, CurrentGet->Row,SField(CurrentGet->FieldNum));
    PopColors();
  }
  Select(SaveArea);
}

void DoScreenGets(string10 ScreenName, ScreenGetMode ScreenMode,
void (* UserCallBack)(void))
{
  unsigned char SaveArea;
  GetListPtr SaveGet;
  ScreenListPtr SaveScreen;
  ScreenListPtr ScreenHandle;
  int err;
  char *ptr;

  ScreenName = Upper(Trim(ScreenName));
  if (!*DBF()) {
    err = NotInUse;
    ptr = "";
    goto bailout;
  }
  ScreenHandle = SearchFor(ScreenName);
  if (!ScreenHandle) {
    err = InvalidParameter;
    ptr = screen_gets_not_defined_for;
    goto bailout;
  }
  if (!ScreenHandle->ScreenGets) {
    err = InternalError;
    ptr = missing_get_records;
    goto bailout;
  }
  // Save the current "setup" so we can restore it later
  SavedBASEOrder = dBASEOrder;
  dBASEOrder = FALSE;
  SaveArea = CurrentArea();
  SaveGet = CurrentGet;
  SaveScreen = Info.CurrentScreen;
  // Now step through all the GetList records for this ScreenHandle
  Info.CurrentScreen = ScreenHandle;
  CurrentGet = Info.CurrentScreen->ScreenGets;
  while (CurrentGet) {
    DoOneGet(ScreenMode, UserCallBack);
    CurrentGet = CurrentGet->NextGet;
  }
  Select(SaveArea);
  dBASEOrder = SavedBASEOrder;
  if (ScreenMode != DisplayMode)
    ReadGets();
  CurrentGet = SaveGet;
  Info.CurrentScreen = SaveScreen;
  return;

bailout:
  SetError(err, 4, ptr, "[DoScreenGets(", ScreenName, ")]");
}
