/* filename: SAYGET.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

#include <sayget.h>

extern void (*EditMemoProc)( long *, char* );

char LeftDelimiter  = 0;
char RightDelimiter  = 0;

void SayGet(int x, int y, const char * say, void * get,
            VarTypes gettype, unsigned char Len, signed char pDecimals)
{
  SGFieldRecord *with;

  if (!CheckRegisteredUnits("SayGet", REGTZCOMMON+REGTZSAYGET))
    return;
  if (SGwhich > MaxNestingLevel) {// shouldn't happen..see IncrementWhich
    At(x,y,SayGet_nesting_limit_exceeded);
    return;
  }

  if (TableSize[SGwhich] + 1 > MaxGets) {
    At(x,y,Too_many_GETs);
    return;
  }

  if ((gettype == _M) && (EditMemoProc == NULL)) {
    SetError(InvalidParameter, 2, Memo_unit_not_linked_into_program, " [SayGet]");
    return;
  }

  if ((gettype == _UNDEFINEDTYPE)) {
    SetError(InvalidParameter, 2, UNDEFINED_field_type_specified, " [SayGet]");
    return;
  }

  if (dBASEOrder)
    Convert(&x,&y);

  ++TableSize[SGwhich]; // increment field number

  with = (SGFieldRecord *)malloc( sizeof(SGFieldRecord) ); // allocate memory
  GetTable[SGwhich][TableSize[SGwhich]-1] = with;

  if( with == NULL) {
    gotoxy(x,y);
    SetError(InsufficientMemory, 1, "[SayGet]");
    --TableSize[SGwhich];
    return;
  }
  //  initialize all fields in a sayget record
  memset(with,0,sizeof(SGFieldRecord)); // say could be NULL...
  with->prompt = (char *)malloc((say ? strlen(say) : 0) + 1); // allocate memory
  if( with->prompt == NULL) {
    gotoxy(x,y);
    SetError(InsufficientMemory, 1, "[SayGet]");
    free(with); // de-allocate memory
    --TableSize[SGwhich];
    return;
  }
  with->picsize = 0;

  if( (gettype == _F) || (gettype == _DF) || (gettype == _LD)
  || (gettype == _D) || (gettype == _T) ) {
    // establish default pictures for floats, dates, and times
    if( gettype == _D )
    {
      if( CenturyOn )
        Len = 10;
      else
        Len = 8;
    }
    if( (gettype == _T) && (Len != 5) )
      Len = 8;

    with->picsize = Len + 1;
    with->PictureString = (char *)malloc((size_t)(Len + 1));
    if( with->PictureString == NULL)
    {
      gotoxy(x,y);
      // 217
      SetError(InsufficientMemory,1,"[SayGet]");
      free(with->prompt); // de-allocate memory
      free(with); // de-allocate memory
      --TableSize[SGwhich];
      return;
    }
  }
  else // no default picture
    with->PictureString = NULL;

  with->row = y-1;     // already converted to C coordinates
  with->column = x-1;  // already converted to C coordinates
  if (say)
    strcpy(with->prompt,say);
  else
    *(with->prompt) = 0;
  with->vartype = gettype;
  with->varofs = FP_OFF(get);
  with->varseg = FP_SEG(get);
  with->LeftSymbol = LeftDelimiter;
  with->RightSymbol = RightDelimiter;
  with->say_color = SayColor;
  with->get_color = GetColor;
  with->LeftColumn = with->column + strlen((char *)with->prompt); // already converted to normal coordinates
  with->decimals = pDecimals;   // parameter
  with->Width = 1;
  with->ValidationProc = NULL;
  with->AutoHelpProc = NULL;
  with->FieldCode = TableSize[SGwhich]-1;
  with->PictureFunction = '\xFF';

  switch (with->vartype) {

    case _UC:     if (Len < 1) with->Width = 3;
      else with->Width = Len;
      strcpy(with->LowerLimit, "0"); // default range for Byte vars
      switch (with->Width) {

        case 1: // self limiting
          break;

        case 2:
          with->RangeChecking = TRUE;
          strcpy(with->UpperLimit,"99");
          break;

        default:
          with->RangeChecking = TRUE;
          strcpy(with->UpperLimit,"255");
      } // case
      break;

    case _SC:
      if (Len < 1) with->Width = 3;
      else with->Width = Len;
      if (with->Width > 2) {
        with->RangeChecking = TRUE;
        if (with->Width == 3)
          strcpy(with->LowerLimit, "-99");
        else
          strcpy(with->LowerLimit, "-128");
        strcpy(with->UpperLimit, "127");
      }
      break;

    case _US:
    case _UI:
      if (Len < 1) with->Width = 5;
      else with->Width = Len;
      if (with->Width > 1) {
        with->RangeChecking = TRUE;
        strcpy(with->LowerLimit, "0"); // default range for words
        strcpy(with->UpperLimit,Replicate('9',with->Width));
        if (with->Width > 4)
          strcpy(with->UpperLimit, "65535");
      }
      break;

    case _SH:
    case _I:
      if (Len < 1) with->Width = 6;
      else with->Width = Len;
      if (with->Width > 4) {
        with->RangeChecking = TRUE;
        with->LowerLimit[0]='-';
        strcpy(&with->LowerLimit[1],Replicate('9',with->Width - 1));
        if (with->Width > 5)
          strcpy(with->LowerLimit,"-32768"); // default range for Integers
        strcpy(with->UpperLimit,"32767");
      }
      break;

    case _LI:
      if ((Len < 1)) with->Width = 11;
      else with->Width = Len;
      if (with->Width > 9) {
        with->RangeChecking = TRUE;
        with->LowerLimit[0] = '-';
        strcpy(&with->LowerLimit[1],Replicate('9',with->Width - 1));
        if (with->Width > 10)
          strcpy(with->LowerLimit,"-2147483648"); // default range for LongInts
        strcpy(with->UpperLimit,"2147483647");
      }
      break;

    case _UL:
      if ((Len < 1)) with->Width = 10;
      else with->Width = Len;
      strcpy(with->LowerLimit,"0"); // default range for ULongInts
      strcpy(with->UpperLimit,Replicate('9',with->Width));
      if (with->Width > 9) {
        with->RangeChecking = TRUE;
        strcpy(with->UpperLimit,"4294967295");
      }
      break;
  
    case _F:  // max of  7 significant digits excluding the decimal point
    case _DF: // max of 15 significant digits excluding the decimal point
    case _LD: // max of 19 significant digits excluding the decimal point
      //  just supposing nobody is going overflow floats ?
      with->Width = Len;
      strcpy(with->PictureString,Replicate('#',Len));
      if (pDecimals > 0)
        with->PictureString[strlen((char *)with->PictureString) - pDecimals-1] = DecimalSymbol;
      break;
  
    case _S:
    case _STATIC:
    case _PASSWORD: // PASSWORD
      if( Len == 0 )
        with->Width = strlen( (char *)MK_FP(with->varseg,with->varofs));
      else
        with->Width = Len;
      /*  set string length to specified "len" unless "len" = 0  when
      it should be set to the length of current get variable.  Dangerous
      since it is possible to overwrite another variable IF you
      make a string longer than it's TYPE declaration  */
      break;
  
    case _D: // date variable
      if( CenturyOn ) {
        with->Width = 10;
        switch (DateFormat) {
  
          case American:
          case FrenchCanadian:
          case British:   strcpy(with->PictureString,"99/99/9999");
            break;
  
          case Ansi:    strcpy(with->PictureString,"9999.99.99");
            break;
  
          case Italian:   strcpy(with->PictureString,"99-99-9999");
            break;
  
          case French:
          case German:
          case Spanish:   strcpy(with->PictureString,"99.99.9999");
            break;
        }
      }
      else {
        with->Width = 8;
        switch (DateFormat) {
  
          case American:
          case FrenchCanadian:
          case British:   strcpy(with->PictureString,"99/99/99");
            break;
  
          case Ansi:    strcpy(with->PictureString,"99.99.99");
            break;
  
          case Italian:   strcpy(with->PictureString,"99-99-99");
            break;
  
          case French:
          case German:
          case Spanish:   strcpy(with->PictureString,"99.99.99");
            break;
        }
      }
      break;
  
    case _T: // time variable
      with->decimals = 0;
      if (Len == 5) {
        with->Width = 5;
        strcpy(with->PictureString,"99:99");
      }
      else {
        with->Width = 8;
        strcpy(with->PictureString,"99:99:99");
      }
      break;
  
    case _M:
      with->Width = 4; // to fit the word MEMO
      break;
  }
  if (LeftDelimiter != '\0')
    ++(with->LeftColumn);
  with->RightColumn = with->LeftColumn + with->Width - 1;
  PaintField(TableSize[SGwhich]-1,FALSE,FALSE); // False == SAY
  if (with->RightColumn < 80)
    gotoxy(with->RightColumn + 2,with->row+1);
}
#endif
