/* filename: READGETS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <ctype.h>
#include <conio.h>
#include <sayget.h>
#ifdef _MSC_VER
 #include <graph.h>
#endif

#define TicksAtMidnight 1573040L // roughly
#define nop 0

extern void (*EditMemoProc)(long * Arg1, char * Arg2);

int SpreadSheetMode = FALSE; // if true then prevents use of arrow keys to exit fields
#ifdef RUSSIAN
char *AlphaSet  =
"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
"\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x8B\x8C\x8D\x8E\x8F\x90\x91"
"\x92\x93\x94\x95\x96\x97\x98\x99\x9A\x9B\x9C\x9D\x9E\x9F\xF0\xA0\xA1\xA2"
"\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xAA\xAB\xAC\xAD\xAE\xAF\xE0\xE1\xE2\xE3\xE4"
"\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF\xF1";
#else
char *AlphaSet  =
"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
"\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x8B\x8C\x8D\x8E\x8F\x90\x91"
"\x92\x93\x94\x95\x96\x97\x98\x99\x9A\xA0\xA1\xA2\xA3\xA4\xA5\xA6\xA7";
#endif

char *NumberSet  = "0123456789";
int ExitRead=0; //AutoHelp, FKEY, and Validation routines can instruct ReadGets to exit entire read
int ExitField=0;  // AutoHelp and FKEY procedures can set this
char UserChar  = '|';  // char to access user set (can be any char)
char _tzfar WatchKeys[STRSIZ] = "";
char EditResult  = 0; //  contains status of edit upon exit
char *SGBuffer=NULL; // points to current field buffer
unsigned char SGFieldCode=0;// contains code from current field
unsigned char SGNextField=0;//  allows user to specify which field is next
int SGFieldOK=0; // used to indicate field contents are valid
int SGRepaint=0; // if true after validation, autohelp, or Fkey calls
                 // then all the gets on the screen will be repainted
BOOL FirstGoToLeft = FALSE;

unsigned _tzfar LineOne[80]={0}; //  scoreboard line
static  unsigned  va, vs, lc, rc, R;//  left column, right column, row
static  VarTypes _tzfar vt;
static  char _tzfar p[STRSIZ] = "";
static  char  picture;
static  char  pf; // PictureFunction
static  unsigned char s_color, g_color;

static  int    Field;
static  double dblfloat;
static  char _tzfar say[STRSIZ] = "";
static  char _tzfar buffer[STRSIZ] = "";
static  unsigned SGNextFieldPos;

// Get Data vars
static  unsigned CrsrPointer; // pointer to cursor position in buffer
static  int  character;
static  int  CharChanged, FirstKeyStroke;
static  unsigned char MenuChoice;
static  BOOL ReplaceWithLiteralCharacter = FALSE;

static  EventRec _tzfar E = {0}; // for mouse

#define SAVE    1
#define RESTORE 0

typedef struct {
  unsigned int  va, vs, lc, rc, R, ContextNo, CrsrPointer;
  char          ContextID[25];
  unsigned char FieldIndex;
  int           EditResult, Field;
  VarTypes      vt;
  char          picture, pf, buffer[STRSIZ];
} SaveVars, *PSaveVars;
static PSaveVars _tzfar srv[MaxNestingLevelPlus] = {{0}};

static void SRV(int save_or_restore, int edit_result)
{
  SGFieldRecord *with;
  static int w = 0;
  PSaveVars pv;

  if (save_or_restore == SAVE) {
    srv[w] = (PSaveVars)malloc(sizeof(SaveVars));
    if (!srv[w]) {
      SetError(InsufficientMemory, 1, " [ReadGets/SaveRestoreVars]");
      return;
    }
    pv = srv[w];
    pv->Field = Field;
    if (edit_result)
      pv->EditResult = EditResult;
    else
      strcpy(pv->buffer, buffer);
    pv->FieldIndex = SGFieldIndex;
    strcpy(pv->ContextID,ContextID);
    pv->ContextNo = ContextNo;
    pv->va = va;
    pv->vs = vs;
    pv->lc = lc;
    pv->rc = rc;
    pv->R  = R;
    pv->vt = vt;
    pv->pf = pf;
    pv->picture = picture;
    pv->CrsrPointer = CrsrPointer;
    w++;
  }
  else {
    w--;
    pv = srv[w];
    va = pv->va;
    vs = pv->vs;
    lc = pv->lc;
    rc = pv->rc;
    R  = pv->R;
    vt = pv->vt;
    pf = pv->pf;
    picture = pv->picture;
    CrsrPointer = pv->CrsrPointer;
    strcpy(ContextID,pv->ContextID);
    if (edit_result)
      EditResult = pv->EditResult;
    else
      strcpy(buffer, pv->buffer);
    ContextNo = pv->ContextNo;
    SGFieldIndex = pv->FieldIndex;
    Field = pv->Field;
    with = GetTable[w][Field];
    CurrentFieldType = with->vartype;
    SGFieldCode = with->FieldCode + 1;
    if (with->PictureString)
      memcpy(p, with->PictureString, sizeof(p));
    else
      *p = 0;
    FreePtrClear((void *) &srv[w]);
  }
}

static void SaveRestoreVars(int save_or_restore)
{
  if (save_or_restore == SAVE) {

    SGBuffer = buffer; // hand the FKey proc a pointer to the buffer
    // save the value of SGBuffer so that a nested ReadGets
    //  can restore them before it exits.
    SGBufSave[SGwhich] = SGBuffer;
    SRV(save_or_restore, 1);
    IncrementWhich();
    Activity = _None;
    PushMouse();
  }
  else {
    PopMouse();
    Activity = _DataEntry;
    ClearGets(); // make sure no other gets are active
    DecrementWhich();
    SRV(save_or_restore, 1);
  }
}

static void FillBufferFromVar(void)
{
  unsigned char j, color;
  int len, width, swidth;
  SGFieldRecord *with;
  void *pv;

  with = GetTable[SGwhich][Field];  // set up this field on screen
  width = with->Width;
  swidth = rc - lc + 1;
  pv = (void*) MK_FP(vs,va);
  memset(buffer,0,sizeof(buffer)); // wipe the slate clean
  switch (vt) {
    case _L: // logic, one byte
      buffer[0] = BooleanSaySet[* (unsigned char *) pv ? 1 : 0];
      buffer[1] = 0;
      break;
    case _SC: // signed or unsigned char, Byte
      sprintf(buffer,"%*d", swidth, *(signed char*) pv);
      break;
    case _UC:
      sprintf(buffer, "%*u", swidth, *(unsigned char *) pv);
      break;
    case _A:// Char, ASCIIZ, one byte
      buffer[0] = *(unsigned char *) pv;
      buffer[1] = '\0';
      break;
    case _M:
      strcpy(buffer, *(long*) pv ? "MEMO" : "memo");
      break;
    case _US:// unsigned short int, two bytes
    case _UI:// unsigned int, two bytes
      sprintf(buffer, "%*u", swidth, * (unsigned*) pv);
      break;
    case _SH:
    case _I:
      sprintf(buffer, "%*d", swidth, *(int*) pv);
      break;
    case _F: // Floats
      strcpy(buffer, SReal((long double) * (float*) pv,
      (unsigned char) swidth, (unsigned char)with->decimals)); // handles the decimal symbol
      break;
    case _DF:
      strcpy(buffer, SReal((long double) * (double*) pv,
      (unsigned char) swidth, (unsigned char) with->decimals)); // handles the decimal symbol
      break;
    case _LD:
      strcpy(buffer, SReal(* (long double*) pv, (unsigned char) swidth,
      (unsigned char)with->decimals)); // handles the decimal symbol
      break;
    case _LI:// long int
      sprintf(buffer, "%*ld", width, * (long*) pv);
      break;
    case _UL:
      sprintf( buffer, "%*lu", width, * (unsigned long*) pv);
      break;
    case _S:// string, date, or time
    case _D:
    case _T:
    case _STATIC:
    case _PASSWORD:
      memset(buffer, 0x20, sizeof(buffer));
      strcpy(buffer, (char *) pv);
      buffer[width] = 0;// pad w/spaces
      len = strlen(buffer);
      j = width - len;
      for (; j > 0; j--)
        buffer[len+j-1] = ' ';
      j = width;
      if (p[0] && (pf != 'M')) // drop literals into data
        for (j = 0; j < strlen(with->PictureString); j++)
          if ((strchr(PictureSet,with->PictureString[j])==NULL) &&
            (UserSymbol != with->PictureString[j]) )
            buffer[j] = with->PictureString[j];
      buffer[((unsigned char) width < j) ? width : j] = '\0';// Max said picture must limit the field...
      break;
  }

  if ((vt == _F) || (vt == _I) || (vt == _UI) || (vt == _US) ||
    (vt == _DF) || (vt == _LD) || (vt == _UC) || (vt == _SC) ||
    (vt == _LI) || (vt == _UL) || (vt == _SH))
    if (strlen(buffer) > (size_t) width)
      strcpy(buffer, Replicate('*',width));

  if (((vt == _F) || (vt == _DF) || (vt == _LD)) && (with->decimals > 0))
    buffer[width - with->decimals-1] = DecimalSymbol;
  buffer[width] = 0;

  color = (SelectedColor > 0) ? SelectedColor : with->get_color;

  if (((vt == _F) || (vt == _I) || (vt == _DF) || (vt == _LD) ||
    (vt == _US) || (vt == _UI) || (vt == _UC) || (vt == _SC) ||
    (vt == _LI) || (vt == _UL) || (vt == _SH))
    && (pf == 'Z') && (RealVal(buffer) == 0.0F))
    strcpy(buffer, Space(width));
  if (vt == _PASSWORD)
    sprintf(say, "%s%s", Replicate('*',strlen(Trim(buffer))),
    Space(width-strlen(Trim(buffer))));
  else
    strcpy(say, buffer );
  FastWrite((char _far *) say, Wrow(with->row), Wcol(lc), color);
  TellDesqViewAboutChange();
}

static void MoveDataToVar(unsigned char f)
{
  int   tempint;
  SGFieldRecord *with;
  void *pv;

  with = GetTable[SGwhich][f];
  pv = (void*) MK_FP(vs,va);
  switch (vt) {
    case _L:// logical (Boolean)
      if (strchr(FalseSet, UpCase(buffer[0])))
        * (unsigned char*) pv = 0;
      else
        if (strchr(TrueSet, UpCase(buffer[0])))
          * (unsigned char*) pv = 1;
      break;
    case _UC:// vartype = unsigned char
      tempint = IntegerVal(buffer);
      if (tempint > 255) tempint = 255;
      if (tempint < 0) tempint = 0;
      *(unsigned char *) pv = (unsigned char) tempint;
      break;
    case _SC:// VarType = signed char
      tempint = (int)LongVal(buffer);
      if (tempint > 127) tempint = 127;
      if (tempint < -128) tempint = -128;
      *(signed char *) pv = (signed char)tempint;
      break;
    case _A:// VAR type = char
      *(unsigned char *) pv = buffer[0];
      break;
    case _I:// Integer
    case _SH:// Integer
      *(int*) pv = IntegerVal(buffer);
      break;
    case _UI:// word
    case _US:// word
      *(unsigned *) pv = (unsigned)LongVal(buffer);
      break;
    case _LI:// LongInt
    case _UL:// LongInt
      *(long*) pv = LongVal(buffer);
      break;
    case _F://  float
      *(float*) pv = (float)RealVal(buffer);
      break;
    case _DF:// double float
      *(double*) pv = RealVal(buffer);
      break;
    case _LD:// long double
      *(long double*) pv = RealVal(buffer);
      break;
    case _S:
    case _D:
    case _T:// VAR type = string, date, or time, OR PASSWORD
    case _PASSWORD:
      buffer[with->Width] = '\0';
      if ((vt == _S) && (with->decimals != 0))// trim the string
        strcpy(buffer,Ltrim(Trim(buffer)));
      memcpy(pv, buffer, strlen(buffer) + 1);
      break;
    case _M:// memo fields are already updated
      break;
  }
}

static void DoFarCall(void (* Destination)(void), int Setup)
{
  ExitRead = FALSE;
  ExitField = FALSE;
  SGRepaint = FALSE;
  SGFieldCode = (GetTable[SGwhich][Field])->FieldCode + 1;
  if (Setup)
    FillBufferFromVar();
  SaveRestoreVars(SAVE);
  Destination();
  SaveRestoreVars(RESTORE);
  // check for empty string returned
  if (!*buffer) // fill it with the right number of spaces
    strcpy(buffer,Space((GetTable[SGwhich][Field])->Width));
}

static void ToggleOverwriteMode(void)
{
  InsertMode = !InsertMode;
  SetCursorOn();
}

int Literal(void)  // determines IF cursor is on a picture literal
{
  return ((strchr(PictureSet,p[CrsrPointer-lc])==NULL) &&
  (UserSymbol != p[CrsrPointer-lc]));
}

static void ReplaceFuzzyChars(char * s)
{
  unsigned char i;

  for (i=1; (s[i] != '\0') && (i<10); i++)
    if (s[i] == '?')
      s[i] = '1';
  if ((s[0] == '0') && (s[1] == '0'))
    s[0] = s[1] = '1';
}

static int ValiDateEntry(char * mdate)  // checks for bad dates
{
  char year[7] = "  ", month[3], day[3];
  int  iyear, imonth, iday, leapyear;
  int  IsFuzzyDate;
  unsigned char i,sw;

  Convert2American(mdate);
  if ((!CenturyOn && (strcmp(mdate, "  /  /  ") == 0))
  || (CenturyOn && (strcmp(mdate, "  /  /    ") == 0))) {
    ConvertFromAmerican(mdate);
    return TRUE;
  }
  for (i=0; mdate[i] != '\0'; i++) { // CleanUp
    if (mdate[i] == '/') sw = 1;
    if ((mdate[i] != '/') && (mdate[i] != ' ')) sw = 0;
    if ((mdate[i] == ' ') && sw) mdate[i] = '0';
  }
  IsFuzzyDate = ((strchr(mdate, '?') != NULL)
  || (((GetTable[SGwhich][Field])->decimals == FuzzyDate)
  && (strstr(mdate,"00") != NULL)));
  // if 4 digit year but user only entered 2 digits then
  if ((atoi(&mdate[6]) < 100) && CenturyOn) { // add the system date century
    sprintf(year,"%s%d", DefaultCentury(&mdate[6]), atoi(&mdate[6]));
  }
  else
    if (CenturyOn)
      strcpy(year, &mdate[6]);
    else {
      year[0] = mdate[6];
      year[1] = mdate[7];
      year[2] = 0;
    }
  mdate[6] = 0;
  strcat(mdate, year);
  for (i=0; i<2; i++) {
    month[i] = mdate[i];
    day[i] = mdate[i+3];
  }
  month[i] = day[i] = 0;

  ConvertFromAmerican(mdate);
  iyear = atoi(year);

  leapyear = (iyear % 400 == 0) || ((iyear % 4 == 0) && (iyear % 100 != 0));
  if (IsFuzzyDate) {
    ReplaceFuzzyChars(year);
    ReplaceFuzzyChars(month);
    if ((day[0] == '3') && (day[1] == '?'))
      strcpy(day,"30");
    else
      ReplaceFuzzyChars(day);
  }
  iyear = atoi(year);
  imonth = atoi(month);
  iday = atoi(day);
  if (!iyear || !imonth || !iday) {
    RingBell();
    return FALSE;
  }
  if ((imonth < 1) || (imonth > 12)) {
    RingBell();
    return FALSE;
  }
  if ((iday < 1) || (iday > 31) || ((imonth == 2) && (iday > 29)) ||
    ((!leapyear) && (iday > 28) && (imonth == 2)) ||
  ((iday > 30) && (strstr(".04.06.09.11.", month) != NULL))) {
    RingBell();
    return FALSE;
  }
  if (CenturyOn)
    if (strlen(year) < 4) {
      RingBell();
      return FALSE;
    }
  return TRUE;
}

static int GoodTime(char * mtime, char decimals)  // checks for bad times
{
  int i;
  size_t len;

  len = strlen(mtime);
  for (i=0; mtime[i] != '\0'; i++)
    if (mtime[i] == ' ') mtime[i] = '0';
  if (len < 5) return FALSE;
  if (len == 5) {
    if (atoi(&mtime[3]) > 59) return FALSE; // '34:66' = bad
    if (decimals == 0) // first too digits are minutes
      if (atoi(&mtime[0]) > 59) return FALSE; // '66:34' = bad
  }
  else {
    if (atoi(&mtime[len-5]) > 59) return FALSE;
    if (atoi(&mtime[len-2]) > 59) return FALSE;
  }
  return TRUE;
}

static void ReplaceChar(void)
{
  int temp_rc, color, corrected_row, corrected_col, i, j, error;
  char left_half[STRSIZ], middle_section[STRSIZ], right_half[STRSIZ], tmp;
#ifndef RUSSIAN
  char *UmlautSet = "\x8E\x84\x99\x94\x9A\x81\xE1\x15";
#endif

  if (vt == _STATIC) return;
  error = FALSE;
  switch (vt) {
    case _L:
      if (strchr(BooleanSet, character) == NULL)
        error = TRUE;
      break;
    case _UC:
    case _US:
    case _UL:
    case _UI:
      if ((strchr(NumberSet, character) == NULL) && (character != ' '))
        error = TRUE;
      break;
    case _I:
    case _SH:
    case _SC:
    case _LI:
      if ((strchr(NumberSet, character) == NULL) && (character != '-') && (character != ' '))
        error = TRUE;
      break;
    case _F:
    case _DF:
    case _LD:
      if ((strchr(NumberSet, character) == NULL) &&
        (character != ' ') && (character != '-') &&
        (character != DecimalSymbol))
        error = TRUE;
      break;
  }
  if (p[0]) {// IF there is a picture statement for current field
    tmp = p[CrsrPointer - lc];
    if ((tmp == '9') && (character != ' ')
    && (strchr(NumberSet, character) == NULL)) {
      error = TRUE;
      if ((vt == _D) && (character == '?') && ((GetTable[SGwhich][Field])->decimals == FuzzyDate))
        error = FALSE;
    }
    if ((tmp == 'L') && (strchr(BooleanSet, character) == NULL) )
      error = TRUE;
    if ((tmp == 'Y') && (strchr(BooleanSaySet, UpCase(character)) == NULL))
      error = TRUE;
    if ((tmp == '#') && (strchr(NumberSet, character) == NULL) &&
      (character != ' ') && (character != '-') && (character != DecimalSymbol))
      error = TRUE;
    if ((toupper(tmp) == 'A') && (strchr(AlphaSet, character) == NULL))
      error = TRUE;
    if (UserSet[0])
      if ((UserSymbol == tmp) && (strchr(UserSet, character) == NULL))
        error = TRUE;
  }
  /* AsciiOnly has a slightly different meaning
  in German..umlauts are permitted, in Russian version the
  second half of the ASCIIZ table is used. */
#ifndef RUSSIAN
  if (AsciiOnly) {
    if (!(((character >= ' ') && (character <= '~')) ||
      (strchr(UmlautSet, character) != NULL)))
      error = TRUE;
  }
#else
  if (AsciiOnly) {
    if ((strchr(AlphaSet, character) == NULL) && (character != ' '))
      error = TRUE;
  }
#endif
  if (error) {
    RingBell();
    --CrsrPointer;
  }
  else {
    CharChanged = TRUE;
    FieldChanged = TRUE;
    if (p[0])
      if (strchr("A!Y", p[CrsrPointer - lc] ) != NULL)
        character = UpCase(character);
    if (pf == '!')
      character = UpCase(character);
    color = (SelectedColor > 0) ? SelectedColor : g_color;
    if (!InsertMode) { //OverWrite
      buffer[CrsrPointer - lc] = (char)character;
      sprintf(say, "%c", (vt == _PASSWORD) ? '*' : character);
      FastWrite( (char _far *)(say), Wrow(R), Wcol(CrsrPointer), color);
    }
    else {// insert mode
      temp_rc = rc;
      if (p[0]) {
        for (i = CrsrPointer + 1; i <= (int)rc; i++)
          if ((strchr(PictureSet,p[i - lc]) == NULL) && (UserSymbol != p[i - lc])) {
            temp_rc = i;
            break;
          }
      }
      if (temp_rc == (int)rc) {
        for (i = strlen( buffer )-1; i>(int)(CrsrPointer - lc); i--)
          buffer[i] = buffer[i-1];
        buffer[i] = (char)character;
      }
      else {
        strcpy(left_half,buffer);
        left_half[CrsrPointer - lc] = '\0';
        if (temp_rc - CrsrPointer == 1)
          sprintf(middle_section,"%c",character);
        else {
          tmp = buffer[temp_rc - lc - 1];
          buffer[temp_rc - lc - 1] = '\0';
          sprintf( middle_section, "%c%s", character, &buffer[CrsrPointer-lc] );
          buffer[temp_rc - lc - 1] = tmp;
        }
        buffer[rc - lc + 1] = '\0';
        strcpy(right_half, &buffer[temp_rc - lc]);
        sprintf(buffer,"%s%s%s",left_half,middle_section,right_half);
      }
      for (i = CrsrPointer; i <= (int) rc; i++) {
        corrected_row = R;
        corrected_col = i;
        if ((i > 80) && (i < 401)) {
          j = (i-1)/80;
          corrected_row += j;
          corrected_col = i - 80*j;
        }
        sprintf(say, "%c", (vt == _PASSWORD) ? '*' : buffer[i - lc]);
        FastWrite((char _far *)(say),Wrow(corrected_row),Wcol(corrected_col),color);
      }
    }
  }
  if ((CrsrPointer == rc) && Confirm)
    RingBell();
  TellDesqViewAboutChange();
}

static void PaintBuffer(void)
{
  unsigned char color;

  color = (SelectedColor > 0) ? SelectedColor : g_color;
  if (vt == _PASSWORD) {
    sprintf(say, "%s%s", Replicate('*',strlen(Trim(buffer))),
    Space(GetTable[SGwhich][Field]->Width-strlen(Trim(buffer))));
  }
  else
    strcpy(say, buffer);
  FastWrite((char _far *)(say),Wrow(R),Wcol(lc),color);
  TellDesqViewAboutChange();
}

static void DeleteChar(void)  /*  deletes char and moves all chars to left of the
cursor to the right one column  */
{
  int i, temp_rc;
  char left_half[STRSIZ], middle_section[STRSIZ], right_half[STRSIZ], tmp;

  if (vt == _STATIC)
    return;
  FieldChanged = TRUE;
  temp_rc = rc;
  if (p[0])
    for (i = CrsrPointer + 1; i <= (int)rc; i++)
      if ((strchr(PictureSet,p[i - lc]) == NULL) &&
      (UserSymbol != p[i - lc]) ) {
        temp_rc = i;
        break;
      }
  if (temp_rc == (int)rc) {
    for (i = CrsrPointer - lc; i < (int)(rc - lc); i++) {
      if (buffer[i+1] == '\0') {
        buffer[i] = ' ';
        break;
      }
      buffer[i] = buffer[i+1];
    }
    buffer[rc - lc] = ' ';
  }
  else {
    strcpy(left_half, buffer);
    left_half[CrsrPointer - lc] = '\0';
    if (temp_rc - CrsrPointer == 1) {
      middle_section[0] = ' ';
      middle_section[1] = '\0';
    }
    else {
      tmp = buffer[temp_rc - lc];
      buffer[temp_rc - lc] = '\0';
      sprintf( middle_section, "%s ", &buffer[CrsrPointer-lc+1] );
      buffer[temp_rc - lc] = tmp;
    }
    buffer[rc - lc + 1] = '\0';
    sprintf(right_half, "%s", &buffer[temp_rc - lc]);
    sprintf(buffer,"%s%s%s",left_half,middle_section,right_half);
  }
  PaintBuffer();
}

static void NextWord(void)  //  ^F
{
  int i, MaxI;

  if ((vt == _STATIC) || (CrsrPointer == rc))
    return;
  MaxI = rc - lc;
  for (i = CrsrPointer-lc; (buffer[i] != ' ') && (i < MaxI); i++);
  for(; (buffer[i] == ' ') && (i < MaxI); i++);
  for (; (buffer[i-1] != ' ') && (i >= 0); i--); // To stop at lineend erase these lines
  CrsrPointer = (i <= MaxI) ? (i + lc) : rc;
  if (buffer[CrsrPointer - lc] == ' ') {
    for (; (buffer[i] == ' ') && (i >= 0); i--);
    for (; (buffer[i-1] != ' ') && (i >= 0); i--); // To stop at lineend erase these lines
    CrsrPointer = (i < 1) ? lc : (i + lc);
  }
  if (p[0])
    while(Literal() && (CrsrPointer > lc))
      --CrsrPointer;
}

static void PriorWord(void)  /*  ^A  */
{
  int i;

  if ((vt == _STATIC) || (CrsrPointer == rc))
    return;
  i = CrsrPointer - lc;

  while ((buffer[i] != ' ') && (i > 0)) --i;
  while ((buffer[i] == ' ') && (i > 0)) --i;
  while ((buffer[i] != ' ') && (i > 0)) --i;

  if ((i != 0)&&(buffer[i] == ' ')) ++i;
  for (; (buffer[i-1] != ' ') && (i <= 0); i--); // redundant
  CrsrPointer = (i >= 0) ? (i + lc) : lc;
  if (p[0])
    while (Literal() && (CrsrPointer < rc))
      ++CrsrPointer;
}

static void DeleteNextWord(void)  /*  ^T  */
{
  char temp_buffer[STRSIZ];

  if (vt == _STATIC) return;

  if (buffer[CrsrPointer - lc] == ' ')
    do {
      strcpy(temp_buffer,buffer);
      DeleteChar();
    }  while (!(((buffer[CrsrPointer - lc] != ' ') || (strcmp(temp_buffer,buffer) == 0))));
  else
    do {
      strcpy(temp_buffer,buffer);
      DeleteChar();
    }  while( ((strchr(AlphaSet, buffer[CrsrPointer - lc]) != NULL) ||
  (strchr(NumberSet, buffer[CrsrPointer - lc]) != NULL)) &&
  (strcmp(temp_buffer,buffer) != 0) );
}

static void DeleteRestOfLine(void)  /*  ^Y  */
{
  unsigned char i;

  if( vt == _STATIC )
    return;
  FieldChanged = TRUE;
  for(i = CrsrPointer - lc; i <= rc - lc; i++)
    buffer[i] = ' ';
  if (p[0]) // insert literals into data
    for (i = 0; i <= rc - lc; i++)
      if ((strchr(PictureSet, p[i]) == NULL) && (UserSymbol != p[i]))
        buffer[i] = p[i];
  PaintBuffer();
}

static void RepaintBuffer(void)
{
  unsigned char i;

  if ((pf != 'M') && (vt != _M))
    if (p[0]) // insert literals into data
      for (i = 0; i <= rc - lc; i++)
        if ((strchr(PictureSet, p[i]) == NULL) && (UserSymbol != p[i]))
          buffer[i] = p[i];
  PaintBuffer();
}

static void CycleMenu(void)
{
  char buf[STRSIZ], tmp;
  unsigned char i, j;

  /*  if first cycle since cursor entered field then
  make sure we cycle to the "next" choice  */
  if (MenuChoice == 0)
    if (Trim(buffer)[0]) {
      sprintf(buf, "%s%s", buffer, ";");
      i = PosOf(1,buf,p)+1;
      if (i) {
        if (i == 1)
          MenuChoice = 1;
        else {
          for (j = 1; PosOf(j,";",p)+1 < (int)i; ++i)
            ++MenuChoice;
          ++MenuChoice;
        }
      }
    }
  // put next menu choice in buffer and repaint
  ++MenuChoice;
  if ((int)MenuChoice > CountOf(";",p))
    MenuChoice = 1;
  if (MenuChoice == 1)
    i = 0;
  else
    i = PosOf(MenuChoice - 1,";",p)+1;
  j = PosOf(MenuChoice,";",p);
  tmp = p[j];
  p[j] = 0;
  sprintf(buffer, "%s%s", &p[i], Space(rc-lc));
  buffer[rc-lc+1] = 0;
  p[j] = tmp;
  PaintBuffer();
}

static double RealDate(char * x) // converts a date to a real for comparison purposes
{
  double tmp = 0.0F;

  Convert2American( x );
  tmp = 10000.0F*atof(x+6) + 100.0F*atof(x) + atof(x+3);
  ConvertFromAmerican( x );
  return tmp;
}

static void PaintAllFields(void)
{
  int i;

  for (i = 0; i < (int)TableSize[SGwhich]; i++)
    PaintField(i, TRUE, FALSE);   /*  True = GET  */
}

static void CheckX(unsigned char Field, unsigned int * x)
{
  if ((*x < (GetTable[SGwhich][Field])->LeftColumn) ||
    (*x > (GetTable[SGwhich][Field])->RightColumn))
    *x = (GetTable[SGwhich][Field])->LeftColumn;
  FirstKeyStroke = FALSE;
}

#ifdef _MSC_VER
#pragma optimize( "", off )// function too large for global optimizations
#endif

static void GetData(void) // get_data - one field at a time
{
  SGFieldRecord *with;
  char         *charptr, *tmp;
  unsigned int actualcol, actualrow;
  unsigned char OriginalField, char_count, CurrentField, x;
  char         sign, priorkey, dummy;
  long         StartTime, EndTime, LongInt;
  int          j, SpecialKey, SpecialExit, satisfied,bump, TimedOut;
  double       lo_limit, up_limit;
  ActivityType SaveActivity;
  int          OK, whX;
  char         verytmp[2] = " ";

  SpecialExit = FALSE;
  MenuChoice = 0;
  with = GetTable[SGwhich][Field];
  //  set up this field on screen
  FieldChanged = FALSE;
  CurrentField = Field;
  OriginalField = Field;
  FillBufferFromVar();
  SGBuffer = buffer;
  CrsrPointer = lc;
  if ((SGNextFieldPos > 0) && Trim(buffer)[0])
    CrsrPointer = SGNextFieldPos;
  SGNextFieldPos = 0;
  gotoxy(CrsrPointer,with->row);
  OK = FALSE;
  ExitField = FALSE;
  SGFieldCode = with->FieldCode + 1;
  // initial call to automatic help procedure IF specified
  if (with->AutoHelpProc) {
    DoFarCall(with->AutoHelpProc, FALSE);
    if (ExitRead == TRUE) {
      Field = TableSize[SGwhich];
      EditResult = -1;
      goto done;
    }
    if (ExitField) {
      CrsrPointer = rc + 1;
      if (SGNextField == 0) {
        SGNextField = Field + (LastKey == UpArrow) ? 0 : 2;
        if ((int)SGNextField > TableSize[SGwhich]+1)
          SGNextField = 0;
      }
      goto done;
    }
    FillBufferFromVar();
    if (SGRepaint)
      PaintAllFields();
  }
  CharChanged = FALSE; //  used to see if any changes were made to the field data
  actualrow = with->row;
  actualcol = CrsrPointer;
  FirstKeyStroke = TRUE;
  // same as pressing the End key
  if ((with->PictureFunction == 'E')) {
    CrsrPointer = lc + strlen(buffer);
    if (CrsrPointer > rc)
      CrsrPointer = rc;
    while (buffer[CrsrPointer - lc-1] == ' ')
      --CrsrPointer;
    if (p[0])
      while (Literal() && (CrsrPointer >= lc))
        --CrsrPointer;
  }
  bump = FALSE;
  priorkey = nop;
  //  setup complete, now accept input UNTIL user exits the field
  do { // keep accepting keystrokes UNTIL OK = TRUE
    SaveActivity = Activity;
    loop:
    if (p[0] && (pf != 'M'))
      while (Literal() && (CrsrPointer < rc))
        ++CrsrPointer;
    actualrow = with->row;
    actualcol = CrsrPointer;
    if ((CrsrPointer>=80) && (CrsrPointer<400)) {
      j = CrsrPointer/80;
      actualrow += j;
      actualcol = CrsrPointer - j*80;
    }
    gotoxy(actualcol+1,actualrow+1);   /*  move cursor  */
    SGFieldCode = (GetTable[SGwhich][Field])->FieldCode + 1;
    if ((TimeOut > 0) && (!KeyPressed())) {
      StartTime = *BiosTimerTicks;
      EndTime = *BiosTimerTicks + (TimeOut * 18);
      TimedOut = (int)FALSE;
      do {
        if (*BiosTimerTicks < StartTime)
          TimedOut = (int)((*BiosTimerTicks + TicksAtMidnight) > EndTime);
        else
          TimedOut = (int)(*BiosTimerTicks > EndTime);
        if (TimedOut) {
          Field = TableSize[SGwhich];  /*  exit readgets  */
          EditResult = 3;   /*  timeout  */
          goto done;
        }
      } while (!(KeyPressed()));
    }
    Activity = _DataEntry;
    GetEvent(&E); // new way..sees keypresses and mouse clicks
    Activity = SaveActivity;
    switch (E.WhichEvent) {
      case Mouse: // mouse pressed on a GET field..use mail box to know SGwhich field
        if(E.v.sMouse.TargetID > 0)
          goto loop;
        if ((E.v.sMouse.DoubleClick) && (E.v.sMouse.TargetID == -(Field+1))) {

          if (MouseUDFPtr != NULL) {
            DoFarCall( MouseUDFPtr, TRUE );
            SGFieldCode = (GetTable[SGwhich][Field])->FieldCode + 1;
            if(SGRepaint)
              PaintAllFields();
            RepaintBuffer();
            SetCursorOn();
            if (ExitRead == TRUE) {
              Field = TableSize[SGwhich];
              EditResult = -1;
              goto done;
            }
            if (ExitField == TRUE) {
              if ((CrsrPointer >= lc) && (CrsrPointer <= rc))
                CrsrPointer = rc + 1;
              goto done;
            }
          }
          goto loop;
        } // DoubleClick and TargetID == Field-1
        else
          if ((E.v.sMouse.ButtonMask == LeftButtonReleased)
            && (E.v.sMouse.TargetID != -(Field+1)
            && E.v.sMouse.TargetID < 0
          && E.v.sMouse.TargetID >= -128)) {
            SGNextField = -E.v.sMouse.TargetID;
            if (FirstGoToLeft)
              SGNextFieldPos = GetTable[SGwhich][SGNextField-1]->LeftColumn;
            else
              SGNextFieldPos = E.v.sMouse.X-E.v.sMouse.WindX;
            CheckX((unsigned char)(SGNextField?(SGNextField-1):0),
            (unsigned int *)&SGNextFieldPos);
            ExitField = OK = TRUE;
            goto StartRangeChecking;
          }
          else
            if ((E.v.sMouse.ButtonMask == RightButtonReleased) && (E.v.sMouse.TargetID == ReservedID)) {
              //if right button released, emulate ESC key
              character = EscapeCh;
              E.v.sKeyboard.ScanCode = 0;
            }
            else {
              if(E.v.sMouse.TargetID == ForceRepaint)
                RepaintBuffer();
              else {
                CrsrPointer = E.v.sMouse.X-E.v.sMouse.WindX;
                CheckX((unsigned char)Field,&CrsrPointer);
              }
              goto loop;
            }
        break;
      case Keyboard:
        character = E.v.sKeyboard.Key;
        break;
    }
    LastKey = character;
    if (strchr(WatchKeys, character) != NULL)
      if (WatchKeys[0] && character) {
        ExitRead = TRUE; // exit the read now
        SGBuffer = buffer;
        goto validatedata;
      }
    if (character == Control_I) // tab key
      character = DownArrow;
    // prevent extra decimal point after the one in picture statement
    if ( ((vt == _F) || (vt == _DF) || (vt == _LD)) &&
         (character == DecimalSymbol) &&
         ((strchr(p, DecimalSymbol) != NULL) &&
         (((long)strchr(p, DecimalSymbol)-(long)p) < (long)(CrsrPointer - lc)) ||
         (with->decimals == 0)) )
      character = nop;
    // prevent extra or illegal sign characters
    if (((vt == _F)||(vt == _DF)||(vt == _LD)) && (character == '-')) {
      if ((strchr(p, DecimalSymbol) != NULL) && (((long)strchr(p, DecimalSymbol)-(long)p) < (long)(CrsrPointer - lc)+1L) )
        character = nop;
      if (((long)strchr(buffer, '-')-(long)buffer) < (long)(CrsrPointer - lc))
        character = nop;
    }
    SpecialKey = FALSE;
    if (!character) {
      SpecialKey = TRUE;
      dummy = (char)(E.v.sKeyboard.ScanCode);
      /*  for watch keys to work with "special" keys you have to
      add 128 to the character to watch for,  example:
      to trap F1 set watchkeys := [chr(ord(';')+128)];
      or             watchkeys := [chr(59+128)];
      or             watchkeys := [#187];  */

      if (strchr(WatchKeys, (unsigned char)(dummy) + 128) != NULL ) {// exit the read now
        ExitRead = TRUE;
        LastKey = (char)(dummy + 128);// save modified keystroke
        SGBuffer = buffer;
        goto validatedata;
      }
      switch (dummy) {
        case '\x0F':
        case 'H': character = UpArrow;    break; // Shift-Tab or Up-Arrow
        case 'M': character = RightArrow; break;
        case 'P': character = DownArrow;  break;
        case 'K': character = LeftArrow;  break;
        case 'R': character = Control_V;  break; // Insert key
        case 'S': character = Control_G;  break; // DEL key
        case 'G': character = HomeKey;    break;
        case 'O': character = EndKey;     break;
        case 'I': character = PgUp;       break;
        case 'Q': character = PgDn;       break;
        case 'u': character = Control_End;break; // same as Control_w
        case 's': character = Control_Larrow; break; // same as ^Z
        case 't': character = Control_Rarrow; break; // same as ^B
        case 'w': character = Control_Home;   break; // for editing memos

        case F1:  case SF1:  case CF1:  case AF1: case F2:  case SF2:
        case CF2: case AF2:  case F3:   case SF3: case CF3: case AF3:
        case F4:  case SF4:  case CF4:  case AF4: case F5:  case SF5:
        case CF5: case AF5:  case F6:   case SF6: case CF6: case AF6:
        case F7:  case SF7:  case CF7:  case AF7: case F8:  case SF8:
        case CF8: case AF8:  case F9:   case SF9: case CF9: case AF9:
        case F10: case SF10: case CF10: case AF10:
          character = dummy;
          break;
        default:
          character = nop; // all other special keys are ignored
          SpecialKey = FALSE;
      }
      /* The following CASE statement is to maintain compatibility with
      the returned version of LastKey in versions of Topaz prior to 3.5  */
      switch (character) {
        case EndKey:  LastKey = '\xF0'; break;
        case PgUp:    LastKey = '\xF2'; break;
        case PgDn:    LastKey = '\xF1'; break;
        default:      LastKey = character; // save modified keystroke
      }
    }
    if (character)
      if (strchr(WatchKeys, character)) { // exit the entire read now
        ExitRead = TRUE;
        SGBuffer = buffer;
        goto validatedata;
      }
    if (pf == 'M') {
      if (character == ' ')
        CycleMenu();
      if (!SpecialKey)
        if ((character != UpArrow) && (character != DownArrow) &&
          (character != CarriageReturn) &&
          (character != PgUp) && (character != PgDn) &&
          (character != Control_End) && (character != EscapeCh) )
          character = nop;
    }
    if (ReplaceWithLiteralCharacter) {
      ReplaceChar();
      character = nop;
      ReplaceWithLiteralCharacter = FALSE;
    }
    picture = strlen( p );
    switch (character) {
      case BackSpace:
        if (CrsrPointer > lc) {
          --CrsrPointer;
          if (picture)
            while (Literal() && (CrsrPointer > lc))
              --CrsrPointer;
          if( !picture || !Literal() )
            DeleteChar();
        }
        break;
      case LeftArrow:
        --CrsrPointer;
        if (picture)
          while (Literal() && (CrsrPointer >= lc))
            --CrsrPointer;
        if (SpreadSheetMode && (CrsrPointer < lc)) {
          CrsrPointer = lc;
          if (picture)
            while (Literal() && (CrsrPointer < rc))
              ++CrsrPointer;
        }
        else
          if ((Field == 0) && (CrsrPointer < lc)) {
            EditResult = -2;   /*  exit out top field  */
            OK = TRUE;
          }
        break;
      case RightArrow:
        if (vt == _M) // memo field
          CrsrPointer = rc + 1;
        else {
          ++CrsrPointer;
          if (picture)
            while (Literal() && (CrsrPointer <= rc))
              ++CrsrPointer;
        }
        if (SpreadSheetMode && (CrsrPointer > rc))
          CrsrPointer = rc;
        break;
      case UpArrow:
        if (!SpreadSheetMode) {
          CrsrPointer = lc - 1;
          if (!Field) {
            EditResult = -2;
            OK = TRUE;
          }
        }
        break;
      case DownArrow:
        if (!SpreadSheetMode)
          CrsrPointer = rc + 1;
        break;
      case CarriageReturn:
      case LineFeed:
        CrsrPointer = rc + 1;
        break;
      case HomeKey:
        CrsrPointer = lc;
        break;
      case EndKey:
        if (vt != _M) {
          CrsrPointer = lc + strlen(buffer);
          if(CrsrPointer > rc)
            CrsrPointer = rc;
          while (buffer[CrsrPointer - lc-1] == ' ')
            --CrsrPointer;
          if (picture)
            while (Literal() && (CrsrPointer >= lc))
              --CrsrPointer;
        }
        break;
      case Control_P:
        ReplaceWithLiteralCharacter = TRUE;
        character = nop;
        break;
      case Control_R: // go to beginning of first field on screen
        Field = 1;
        CrsrPointer = lc - 1;
        OK = TRUE;
        break;
      case Control_C: // go to beginning of last field on screen
        Field = TableSize[SGwhich] - 2;
        CrsrPointer = rc + 1;
        OK = TRUE;
        break;
      case Control_W:
        SpecialExit = TRUE;
        OK = TRUE;
        EditResult = 0;
        break;
      case PgDn:
        SpecialExit = TRUE;
        OK = TRUE;
        EditResult = -1;
        break;
      case PgUp:
        OK = TRUE;
        SpecialExit = TRUE;
        EditResult = -2;
        break;
      case Control_Q:
        Field = TableSize[SGwhich];
        EditResult = 1;
        goto done;
      case Control_G:
        if (vt != _M)
          DeleteChar();
        break;
      case Control_Y:
        if (vt != _M)
          DeleteRestOfLine();
        break;
      case Control_T:
        if (vt != _M)
          DeleteNextWord();
        break;
      case Control_V:
        ToggleOverwriteMode();
        break;
      case Control_U:
        FillBufferFromVar();  // undo changes
        CrsrPointer = lc; // restore cursor to left column
        break;
      case Control_F:
        if (vt != _M)
          NextWord();
        break;
      case Control_A:
        if (vt != _M)
          PriorWord();
        break;
      case Control_Home:
        if (vt == _M) { // edit a memo field
          LongInt = *(long*) MK_FP(vs,va);
          IncrementWhich();   /*  avoid re-reading current gets by editor  */
          PushMouse();
          if (EditMemoProc) {
            if (picture)
              tmp = p;
            else
              tmp = "";
            EditMemoProc(&LongInt, tmp);
          }
          PopMouse();
          DecrementWhich();
          *(long*) MK_FP(vs,va) = LongInt;
          strcpy(buffer, LongInt ? "MEMO" : "memo");
          PaintBuffer();
        }
        break;
      case nop: // no-operation, ignore it
        break;
      case EscapeCh:
        if (EscapeEnabled) {
          EditResult = 2; // indicates that escape key was pressed to exit
          Field = TableSize[SGwhich]; // forces exit from sayget
          goto done;
        }
        break;
      case Control_Rarrow:
      case Control_Larrow: // ignore for now
        break;
      default: // case otherwise
        if (SpecialKey && ((character>=F1)&&(character<=AF10)) ) { // not if created with alt/number-pad
          if (JumpTable[character-F1]) {
            DoFarCall(JumpTable[character-F1],FALSE);
            SGFieldCode = (GetTable[SGwhich][Field])->FieldCode + 1;
            if (SGRepaint)
              PaintAllFields();
            RepaintBuffer();
            SetCursorOn();
            if (ExitRead == TRUE) {
              Field = TableSize[SGwhich];
              EditResult = -1;
              goto done;
            }
            if (ExitField == TRUE) {
              if ((CrsrPointer >= lc) && (CrsrPointer <= rc))
                CrsrPointer = rc + 1;
              goto done;
            }
          }
        } // special key
        else
          if (vt != _M) { // not a memo field
            // normal keystroke
            if (FirstKeyStroke && (((GetTable[SGwhich][Field])->PictureFunction == 'K')
            || ((GetTable[SGwhich][Field])->selfdestruct))) {// empty field first
              memset(buffer,' ',sizeof(buffer));
              buffer[rc - lc + 1] = 0;
              // put any picture template literals back
              if( p[0] && (pf != 'M')) // drop literals into field
                for (j = 0; j <= (int)(rc - lc); j++)
                  if((strchr(PictureSet,with->PictureString[j]) == NULL)
                    && (UserSymbol != with->PictureString[j]) )
                    buffer[j] = with->PictureString[j];
              PaintBuffer();
            }
            ReplaceChar(); // finally we may be able to put char on screen
            if (vt != _STATIC)
              ++CrsrPointer; // move the invisible cursor
            bump = FALSE;
            if (Confirm && (CrsrPointer > rc)) {
              CrsrPointer = rc;
              bump = TRUE;
            }
            if( p[0] ) // check for literals in picture
              while (Literal() && (CrsrPointer <= rc))
                ++CrsrPointer;
          }
    } // end case character of
    FirstKeyStroke = FALSE;
    satisfied = TRUE; // innocent UNTIL proven guilty
    if (((vt == _F)||(vt == _DF)||(vt == _LD)) &&
    (character == DecimalSymbol)) {
      charptr = strchr(buffer, DecimalSymbol);
      *charptr = '\0';
      strcpy(buffer,Trim(Ltrim(buffer)));
      sign = buffer[0];
      dblfloat = RealVal(buffer);
      strcpy(buffer,SReal((long double)dblfloat,
      (unsigned char)(rc - lc + 1),(unsigned char)with->decimals));
      if ((sign == '-') && (dblfloat == 0.0F) && (with->decimals > 0)) {// put back any minus sign
        verytmp[0] = DecimalSymbol;
        buffer[PosOf(1,verytmp,buffer)] = sign;
      }
      PaintBuffer();
      CrsrPointer = rc - with->decimals;
    }
    // deal with C/R during input of numeric vars
    if( ((vt == _F)||(vt == _I)||(vt == _UC)||(vt == _SH)||(vt == _UL)
      ||(vt == _DF)||(vt == _LD)||(vt == _US)
      ||(vt == _LI)||(vt == _SC)||(vt == _UI))
      && (CharChanged) && (character == CarriageReturn)
    && *buffer) {
      if ((priorkey != LeftArrow)&&(priorkey != RightArrow)
        &&(priorkey != BackSpace)&&(priorkey != HomeKey)
      &&(priorkey != EndKey)) {
        if (!(((whX=wherex()) == (int)rc + 1) && Confirm && bump))
          if (whX-lc-1) //chop off old chars to the right of cursor
            buffer[whX-lc-1] = '\0';
      }
      strcpy(buffer, Trim(Ltrim(buffer)));
      dblfloat = RealVal(buffer);
      strcpy(buffer,SReal((long double)dblfloat,
      (unsigned char)(rc-lc+1), (unsigned char)with->decimals));
      PaintBuffer();
    } // character was a carriage return

    priorkey = LastKey; // up to here prior key holds the keystroke before the last one
    // determine IF it is time to exit this get and go to the next one
    if (((CrsrPointer > rc) || (CrsrPointer < lc)
      || (Field > TableSize[SGwhich]-1))) // exit this sayget
      OK = TRUE;
    StartRangeChecking:
    if ((character != Control_Q) && (character != EscapeCh) && OK) {
      if (with->RequiredInput) {
        switch (vt) {
          case _A:
          case _L:
            satisfied = buffer[0] != ' ';
            break;
          case _S:   case _I:   case _SH:  case _US:
          case _F:   case _DF:  case _LD:  case _UC:
          case _UI:  case _SC:  case _LI:  case _UL:
          case _PASSWORD:
            // look for a character in field
            char_count = 0;
            for (j = 0; j < (int)(rc - lc + 1); j++)
              if (buffer[j] != ' ')
                ++char_count;
            if (char_count > 0)
              for (j = 0; j < (int)(strlen(p)); j++)
                if ((strchr(PictureSet,p[j]) == NULL) && (p[j] != UserSymbol) )
                  --char_count;
            satisfied = char_count > 0;
            break;
          case _D:
            satisfied = ValiDateEntry(buffer);
            if (satisfied)
              for (j = 0; j < (int)with->Width; j++)
                if (buffer[j] == ' ')
                  satisfied = FALSE;
            break;
          case _T:
            satisfied = GoodTime(buffer,with->decimals);
            if (satisfied)
              for (j = 0; j < (int)with->Width; j++)
                if (buffer[j] == ' ')
                  satisfied = FALSE;
            break;
        } // case
      } // required input
      else { // not required input
        switch (vt) {
          case _D:
            satisfied = ValiDateEntry(buffer);
            break;
          case _T:
            satisfied = GoodTime(buffer,with->decimals);
            break;
        }
      }
      if ((with->RangeChecking && OK)) { // check it
        switch (vt) {
          case _D:
            lo_limit = RealDate(with->LowerLimit);
            up_limit = RealDate(with->UpperLimit);
            dblfloat = RealDate(buffer);
            break;
          case _T:
            /*  convert upper and lower ranges to 6 digit numbers */
            lo_limit = 10000.0F*atof(&with->LowerLimit[0]) + 100.0F*atof(&with->LowerLimit[3])+atof(&with->LowerLimit[6]);
            up_limit = 10000.0F*atof(&with->UpperLimit[0]) + 100.0F*atof(&with->UpperLimit[3])+atof(&with->UpperLimit[6]);
            /*  convert buffer time to number   */
            dblfloat = 10000.0F*atof(buffer) + 100.0F*atof(&buffer[3])+atof(&buffer[6]);
            break;
          case _F:  case _DF:  case _LD:
          case _I:  case _SH:  case _UC:
          case _US: case _UI:  case _SC:
          case _LI: case _UL:
            dblfloat = RealVal(buffer);
            lo_limit = RealVal(with->LowerLimit);
            up_limit = RealVal(with->UpperLimit);
            break;
        }
        // compare against range limits
        if( (vt == _F)||(vt == _UC)||(vt == _I)||(vt == _SH)
          ||(vt == _DF)||(vt == _LD)||(vt == _US)
          ||(vt == _D)||(vt == _UI)||(vt == _SC)
          ||(vt == _LI)||(vt == _UL)||(vt == _T))
          OK = ((dblfloat >= (float)lo_limit) && (dblfloat <= (float)up_limit));
        else
          OK = ( strchr(with->LowerLimit,buffer[0]) != NULL );
        if (!OK) {
          RingBell();
          CrsrPointer = lc;
          Field = CurrentField;
          if (Scoreboard) { // display valid range on top line
            if (dBASEOrder) // dbase row to turbo row
              x = ScoreRow + 1;
            else
              x = ScoreRow;
            if (x < 1) x = 1;
            if (x > 25) x = 25;
            // save existing screen contents for this row
            MoveScreenData(MK_FP(BaseOfScreen,(x - 1) * 160), (void far *)LineOne, 80);
            strcpy(say,Space(80));
            FastWrite((char _far *)(say),x,1,SayColor);
            if( vt == _A)
              sprintf(say,"%s%s%s",Range_equals,with->LowerLimit,press_any_key);
            else
              sprintf(say,"%s%s%s%s%s",Range_equals,with->LowerLimit,space_to_space,with->UpperLimit,press_any_key);
            FastWrite((char _far *)(say),x,19,SayColor);
            TellDesqViewAboutChange();
            gotoxy(19 + strlen(say),x);
            dummy = getch();
            // empty keyboard buffer
            while( kbhit() )
              dummy = getch();
            MoveScreenData( (void far *)LineOne, MK_FP(BaseOfScreen,(x - 1) * 160), 80);
            TellDesqViewAboutChange();
          } // IF scoreboard = True
        } // not in range
      } // IF range check and ok
      if (OK && ((with->RequiredInput && (!satisfied)) ||
        (((vt == _D) || (vt == _T)) &&
        (!satisfied)) && ((CrsrPointer > rc) ||
      (CrsrPointer < lc) || (Field != (int)CurrentField)))) {
        OK = FALSE;
        RingBell();
        CrsrPointer = lc; // this is because at this point we don't know where cursor was
        Field = CurrentField; // don't exit field
      } // required input
      validatedata:
      if (OK && with->ValidationProc && (EditResult != 2)) {
        SGFieldOK = TRUE;
        DoFarCall(with->ValidationProc,FALSE);
        RepaintBuffer();
        if (SGRepaint)
          PaintAllFields();
        OK = SGFieldOK;
        if (!OK) { // edit the field again
          SGNextFieldPos = 0;
          CrsrPointer = lc;
          Field = CurrentField;
        }
        else
          (GetTable[SGwhich][CurrentField])->Validated = TRUE;
      }
      if (ExitRead == TRUE) {
        Field = TableSize[SGwhich];
        EditResult = -1;
        goto done;
      }
      if (ExitField == TRUE) {
        if ((CrsrPointer >= lc) && (CrsrPointer <= rc))
          CrsrPointer = rc + 1;
        goto done;
      }
    } // IF no ^Q pressed
  }  while (!(OK)); // user exited field properly

  done:

  // data entry complete, now replace the data in memory
  // should this be done IF user asks to exit the field ?
  // the reason field data is placed back into the actual field
  // variable now rather than at the end of the ReadGets session is
  // that this allows any validation routines to reference the values
  // of other variables that are also SayGet fields rather than
  // whatever the values were before calling ReadGets.
  MoveDataToVar(CurrentField);
  if (SpecialExit)
    Field = TableSize[SGwhich] + 2; // force an exit read
  // the value of Field may have changed so use Original_Field
  // to be sure to paint the right field on the screen
  PaintField(OriginalField, TRUE, FALSE); // true = GET mode, False = selected
  // determine SGwhich get to go to next:
  if ((Field >= 0) && (Field < (int)TableSize[SGwhich]))
    if (CrsrPointer > rc)
      ++Field;
    else
      --Field;
  if ((Field < 0) || (Field > TableSize[SGwhich]-1))
    Field = -1;
  // deal with SGNextField:
  if ((int)SGNextField > TableSize[SGwhich]+1) {
    SetError(212,6,"SGNextField = ",SInteger(SGNextField-1,0),"\r\n",/* +1 07/31/92 */
    Valid_Range_equals_one,SInteger(TableSize[SGwhich],0), " [ReadGets]");
    Field = -1;
  }
  else
    if (SGNextField > 0)
      Field = SGNextField-1;/* +1 07/31/92 */
  SGNextField = 0;
} // get_data

#ifdef _MSC_VER
#pragma optimize( "", on ) // function too large for global optimizations
#endif

static void InitializeField(void)
{
  SGFieldRecord *with;

  SGFieldIndex = Field+1;
  CurrentFieldType = (GetTable[SGwhich][Field])->vartype;
  with = GetTable[SGwhich][Field];

  /*  the reason these vars are transfered to locals is that they need
  to be available to the local procedures  */
  lc = with->LeftColumn;
  rc = with->RightColumn;
  R  = with->row;
  vt = with->vartype;
  va = with->varofs;
  vs = with->varseg;
  if (with->PictureString)
    strcpy(p,with->PictureString);
  else
    *p = 0;
  pf = with->PictureFunction;
  s_color = with->say_color;
  g_color = with->get_color;
#ifdef _MSC_VER
  _settextcolor(s_color & 0x0F);
  _setbkcolor((s_color & 0xF0) >> 4);
#else
  textattr(s_color);
#endif
}

void ReadGets(void)
{
  int PriorField;
  SGFieldRecord *with;
  unsigned char SaveMx, SaveMy;
  int savedBASEOrder;
  int m_row, m_col, m_col1;

  if (!CheckRegisteredUnits("ReadGets", REGTZCOMMON+REGTZSAYGET))
    return;
  if (TableSize[SGwhich] == 0)
    return; // don't try to read non-existant gets
  if (SGwhich > 0)
    SRV(SAVE, 0);
  SGNextFieldPos = 0;
  LastKey = 0;
  ExitRead = 0;
  ExitField = 0;
  EditResult = 0;
  if (Activity != _HelpSystem)
    Activity = _DataEntry;
  if (*UserSet) // convert to type = set of char
    UserSymbol = UserChar;
  else
    UserSymbol = 0;
  savedBASEOrder = dBASEOrder;
  dBASEOrder = FALSE;
  for (Field = 0; Field < (int)TableSize[SGwhich]; Field++) {
    PaintField(Field, TRUE, FALSE); // True = GET
    m_row   = GetWinfo(ROW) + (GetTable[SGwhich][Field])->row;
    m_col1  = GetWinfo(COL);
    m_col   = m_col1 + (GetTable[SGwhich][Field])->LeftColumn;
    m_col1 += (GetTable[SGwhich][Field])->RightColumn;
    AddTarget(m_col,m_row,m_col1,m_row,-(Field+1),LeftButtonDown | LeftButtonReleased);
  }
  AddTarget(1,1,80,MaxAvailRows(),ReservedID,RightButtonDown | RightButtonReleased);
  dBASEOrder = savedBASEOrder;
  if ((SGNextField > 0) && ((int)SGNextField < TableSize[SGwhich]+1))
    Field = SGNextField-1;
  else
    Field = 0;
  SGNextField = 0;
  PriorField = Field-1;
  SaveCursor(&savedcursor);
  SetCursorOn();
  GetMouseXY(&SaveMx,&SaveMy); // in this case, DON'T position the mouse cursor
  EnableMouse();
  SetMouseXY(SaveMx,SaveMy);
  do {
    InitializeField();
    if (!(GetTable[SGwhich][Field])->DisplayOnly) {
      PriorField = Field;
      GetData(); // this is what it is all about
    }
    else { // NOEDIT was called for this field
      //  determine SGwhich field to be positioned on
      if ((PriorField < Field)) {
        PriorField = Field;
        ++Field;
      }
      else {
        PriorField = Field;
        --Field;
      }
      if (Field < 0)
        Field = -1;
      if (Field >= (int)TableSize[SGwhich])
        Field = -1;
    }
  } while (Field != -1);
  DisableMouse();
  Activity = _None;
  /* if this was a nested ReadGets (SGwhich >0) , we need to restore SGBuffer
  before leaving, so that a) any validation routine, autohelp or fkey
  routine that was calling ReadGets can now get back to playing with the
  original SGBuffer, and b) when the original ReadGets gets control,
  SGBuffer will be restored. */
  if (SGwhich > 0)
    SGBuffer = SGBufSave[SGwhich - 1];
  if (Repaint) // default setting
    for (Field = 0; Field < (int)TableSize[SGwhich]; Field++) { // repaint fields with say colors
      with = GetTable[SGwhich][Field];
      if (with->LeftSymbol)
        FastWrite((char _far *)(" "),Wrow(with->row),Wcol(with->LeftColumn - 1),SayColor);
      if (with->RightSymbol)
        FastWrite((char _far *)(" "),Wrow(with->row),Wcol(with->RightColumn + 1),SayColor);
      ChangeAttribute(with->RightColumn - with->LeftColumn + 1,Wrow(with->row),Wcol(with->LeftColumn),with->say_color);
      TellDesqViewAboutChange();
    }
  ClearGets(); // must be called to release allocated memory
  // set colors back to the current values
#ifdef _MSC_VER
  _settextcolor(SayColor & 0x0F);
  _setbkcolor((SayColor & 0xF0) >> 4);
#else
  textattr(SayColor);
#endif
  RestoreCursor(savedcursor);
  SGFieldIndex = 0;

  if (SGwhich > 0)
    SRV(RESTORE, 0);
} // end readgets

#endif // NotWindows
