/* filename: DESQVIEW.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS
  
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <sayget.h>
  
int DesqView = 0;
  
void CheckForDesqView(void)
{
  unsigned int priorbaseseg;
  unsigned int videooffset, newvo;
  union MYREGS cpu;
  
  // check for the presence of TopView or DesqView
  DesqView = FALSE;
  priorbaseseg = BaseOfScreen;
  videooffset = 0;
  memset(&cpu,0,sizeof(cpu));
  // get address of screen buffer to write to
  
  cpu.x.r_ax = 0xFE00; // TopView function
  cpu.x.r_es = BaseOfScreen; // BASESEG value,  0xB000
  cpu.x.r_di = videooffset; // start with a known video buffer address
  intr(0x10,&cpu.x); // get the topview buffer
  BaseOfScreen = cpu.x.r_es; // new baseseg if TopView,DesqView, or Windows present
  newvo = cpu.x.r_di;  // new offset
  if ((BaseOfScreen != priorbaseseg) || (newvo != videooffset)) {
    WaitForRetrace = FALSE;
    DesqView = TRUE;
    videooffset = newvo;
  }
}
  
void TellDesqViewAboutChange(void)
{
  union MYREGS cpu;
  
  // tell TopView/DesqView we changed the screen
  if (DesqView) {
    memset(&cpu,0,sizeof(cpu));
    cpu.x.r_ax = 0xFF00;
    cpu.x.r_cx = 4000; // assume full screen
    intr(0x10,&cpu.x);
  }
}
#endif
