/* filename: COMMAS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
  
char * Commas(void *value, VarTypes typ, int width, int decimals)
{ // Pass to it a number string with or without decimals, this function
  // will return a string with commas inserted at the proper locations
  static char _tzfar ret[63] = "";
  char  A[45], DecStr[19], *cptr, *beg, *cur;
  int   i, len, sign = FALSE;
  
  if (width > 44)
    width = 44;
  if (decimals > 18)
    decimals = 18; // dBASE limit for decimals
  switch (typ) {
    case _SC : // signed char
    case _UC : // unsigned char
    case _A  : // ascii
      sprintf(ret, "%*d", width, *(char *)value);
      return ret;
    case _SH : // short
    case _I  : // int
      itoa(*(int *)value, A, 10);
      break;
    case _US : // unsigned short
    case _UI : // unsigned int
      ltoa((long)*(unsigned int *)value, A, 10);
      break;
    case _LI : // long int
      ltoa(*(long *)value, A, 10);
      break;
    case _UL : // unsigned long
      ultoa(*(unsigned long *)value, A, 10);
      break;
    case _S :  // string
      strncpy(A, (const char *)value, 30);
      *(A + 30) = 0;
      cptr = strchr(A, DecimalSymbol);
      if (cptr)
        *cptr = '.';
      break;
    case _F :  // float
      sprintf(A, "%*.*f", width, decimals, *(float *)value);
      break;
    case _DF : // double
      sprintf(A, "%*.*f", width, decimals, *(double *)value);
      break;
    case _LD : // long double
      sprintf(A, "%*.*Lf", width, decimals, *(long double *)value);
      break;
      // all the other types
    case _L:  // logic
    case _D:  // date
    case _T:  // time
    case _M: // memo
    case _STATIC:
    case _PASSWORD:
    case _UNDEFINEDTYPE:
      SetError(InvalidParameter, 2, Invalid_parameter, " [Commas()]");
      return (char *) value;
  }
  sign = strchr(A, '-') ? TRUE : FALSE;
  // Remove any spaces passed on and find and delete a sign if present
  for (beg = cur = A; *cur; cur++)
    if (*cur != ' ' && *cur != '-' && *cur != '+')
      *beg++ = *cur;
  *beg = 0;
  if ((cptr = strchr(A, '.')) != NULL) { // find decimal point if present
    *cptr++ = 0;
    for (i = 0; i < decimals; i++) {
      if (*cptr)
        *(DecStr+i) = *cptr++;
      else
        *(DecStr+i) = '0';
    }
    *(DecStr + i) = 0;
  }
  else
    *DecStr = 0;
  len = strlen(A);
  cptr = A + len + (len-1)/3;
  *cptr-- = 0;
  for(len--, i = 1; len >= 0; i++)
    if (i % 4)
      *cptr-- = A[len--];
    else
      *cptr-- = ThousandsSeparator;
  if (*DecStr)
    sprintf(ret, "%s%s%c%s", sign ? "-":"", A, DecimalSymbol, DecStr);
  else
    sprintf(ret, "%s%s", sign ? "-":"", A);
  
  if (width)
    *(ret + width) = 0;
  if ((cptr = strchr(ret, DecimalSymbol)) == NULL && *DecStr)
    memset(ret, '*', width); // overflow
  else
    memcpy(ret, LPad(ret, width), width+1);
  return ret;
}
  
