/* filename: REPORT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <utils.h>
#include <sayget.h>
#include <tzprint.h>
#include <parser.h>
#include <dbf.h>
#include <report.h>
#ifdef _MSC_VER
#include <graph.h>
#endif

#define TOTAL    0
#define GROUP    1
#define SUBGROUP 2

#define STR (STRSIZ-1)

typedef double  TotalsArray[MaxFieldCount];// must be double only

void PrintHeading(void);
void ShiftLineNumber(int number);

extern void (*ReportCheckPrinterStatusPtr)(void);
// Report needs its own checker; this pointer is defined in WriteToAlt
extern int  DisplayPageLength;
extern int  LineNumberCounter;
extern jmp_buf ReportJmp; // now defined in tzprint\writoalt.c

OverrideRPTTemplate _tzfar OverrideRPT = {0};
FileHeaderType FileHeader;
unsigned int   Copies = 0;
unsigned char  WhereXMessage= 0, WhereYMessage = 0;
unsigned char  ReportColumnWidth = 0;
int   BlinkMessage = 0;
char  *ReportMessage = NULL;
char  *blankLine = NULL;
char  *PreReportCode = NULL, *PostReportCode = NULL;
int   AppendFlag = 0;   // used to append to an existing file
int   ReportResult  = 0;   // 0=normal, 1=user pressed escape
char  ReportColumnString[90] = { 0 }; // Should be big enough for Name+NameTail
int   PageLength = 0;// just RepTempl->LinesPerPage
int   Continuous = 0;// true if RepTempl->LinesPerPage is 0

static BOOL   RPTVersion5 = FALSE;
static int   *ContinuationString = NULL;
static int    ExcessCharacterFlag;
static int    GroupFieldNumber, SubGroupFieldNumber;
static int    oldOrder;
static double *Total = NULL, *GroupTotal = NULL, *SubGroupTotal = NULL; //TotalsArray
static char   *NumberString = NULL;
static char _tzfar DateString[11] = "";
static int    HasMemos;
static long   *MemoPointer = NULL;
// pointer to byte in memo file where we are in the current memo for the ith field
static char  **MemoLine = NULL;// string storage to handle printing memos
static char   *tmp_buf = NULL;
static unsigned char *ECol = NULL;
static char  *cmd = NULL;

void WriteToAltNoConsole(char *str);

static void ShiftString(char * s, unsigned char number)
{
  register int i;

  if (*s) {
    if ((unsigned char) *s < number)
      number = (unsigned char) *s;
    for(i=0; i<(int)number; i++)
      s[i] = s[i+1];
    s[i] = 0;
  }
}

static void GetMem(void **p, size_t size)
{
  if ((*p = malloc(size)) == NULL)
    longjmp(ReportJmp, 217);
}

static void ReadRptFile(char * fname)
{
  int      i, j, error;
  char     filename[100], *ptr;
  FILE *   fptr;
  ReportColumnType *rc;

  strcpy(filename,AddExt(fname,"RPT"));
  fptr = fopen(filename, "rb");
  if (!fptr) {
    error = errno;
    ptr = (errno == 2) ? ReportFormNotFound : ErrorOpeningReportFormatFile;
    goto _ERROR_;
  }
  if (fread(&FileHeader, sizeof(FileHeader), 1, fptr) != 1) {
    error = errno;
    ptr = ErrorReadingReportFormatFile;
    goto _ERROR_;
  }
  ShiftString(FileHeader.Signature,15); //getting rid of Pascal-like strings
  i = sizeof(ReportTemplateType) - ((255-128) * sizeof(void*));//added to support 255 fields

  j = strcmp(FileHeader.Signature,"TOPAZ RPT V5.00");
  RPTVersion5 = j ? FALSE : TRUE;
  if (strcmp(FileHeader.Signature,"TOPAZ RPT V2.50") &&
      strcmp(FileHeader.Signature,"TOPAZ RPT V2.80") &&
      strcmp(FileHeader.Signature,"TOPAZ RPT V4.00") && j) {
    SetError(220,2, filename, NotATOPAZReportFile);
    return;
  }
  ShiftString(FileHeader.DBFName,12);
  if (!j)
    RepTempl->UnderlineChar = ' ';
  if (fread(RepTempl, 1, i, fptr) != (unsigned) i) {
    error = errno;
    ptr = ErrorReadingReportFormatFile;
    goto _ERROR_;
  }
  ShiftString(RepTempl->Title,STR);
  ShiftString(RepTempl->PreTitlePrinterCode,STR);
  ShiftString(RepTempl->PostTitlePrinterCode,STR);
  ShiftString(RepTempl->GroupField,10);
  ShiftString(RepTempl->GroupHeading,STR);
  ShiftString(RepTempl->SubGroupField,10);
  ShiftString(RepTempl->SubGroupHeading,STR);
  // When PrintOn == FALSE and AlternateOn == FALSE report
  // page length is adjusted to MaxAvailableRows :
  DisplayPageLength = (int) MaxAvailRows() - 2;
  if (ConsoleOn && (!PrintOn) && (!AlternateOn)) {
    if((int)RepTempl->LinesPerPage > DisplayPageLength)
      RepTempl->LinesPerPage = DisplayPageLength;
    RepTempl->TopMargin = 0;
    RepTempl->BottomMargin = 0;
  }
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    if ((RepTempl->FieldMap[i] = malloc(sizeof(ReportColumnType))) == NULL) {
      error = InsufficientMemory;
      ptr = InsufficientMemoryForReportForm;
      goto _ERROR_;
    }
    rc = RepTempl->FieldMap[i];
    if (fread(rc, sizeof(ReportColumnType), 1, fptr) != 1) {
      error = errno;
      ptr = ErrorReadingReportFormatFile;
      goto _ERROR_;
    }
    ShiftString(rc->Name,10);
    ShiftString(rc->NameTail, 77);
    ShiftString(rc->Heading,132);
    ShiftString(rc->PrePrinterCode,80);
    ShiftString(rc->PostPrinterCode,80);
    if (rc->N) { // if the field is not a user defined field, find its field number
      j = 0;
      do {
        ++j;
      } while(strcmp(rc->Name, Field(j)) && (j != FieldCount()));
      if (!strcmp(rc->Name, Field(j)))
        rc->N = j;
      else // field was not found, so DBF structure must have been modified
        // since the last REPGEN session. Make the field number 0xFF
        rc->N = 0xFF;
    }
  }
  fclose(fptr);
  return;

_ERROR_:
  SetError(error, 4, ptr, "(", filename, "). [ReportForm]");
}

static void LeftPad(char *buf, char * x, int width)
{
  int len = strlen(x), diff;

  if (width > STR)
    len = width = STR;
  if (width > len) {
    diff = width - len;
    memset(buf, ' ', diff);
    strncpy(buf + diff, x, STR - diff);
  }
  else
    strncpy(buf, x, STR);
  buf[STR] = 0;
}

#define RWIDTH 25

static char *WithCommas(double value, unsigned char width, unsigned char decimals)
// Pass to it a number string with or without decimals, this function will
// return a string with commas inserted at the proper locations
{
  char A[RWIDTH], DecStr[RWIDTH], NStr[RWIDTH], Sign;
  static char _tzfar temp[RWIDTH] = "";
  char *ptr;
  unsigned char DecSymPos = 0;
  int i, j;
  size_t len;

  *DecStr = 0;
  strcpy(A, SReal((long double)value, width, decimals));
  // Remove any spaces and a sign passed on
  Sign = (value < 0.0F) ? '-' : ' ';
  for(i=0, ptr = A; (i<=RWIDTH) && *ptr; i++, ptr++) {
    if ((*ptr == ' ') || (*ptr == '-'))
      --i;
    else
      temp[i] = *ptr;
  }
  temp[i] = 0;
  len = strlen(temp);
  if ((ptr = strchr(temp, (int) DecimalSymbol)) == NULL)
    DecSymPos = len;
  else
    DecSymPos = (unsigned char)(ptr - (char*) temp);
  for(i=0, ptr = temp; *ptr != '\0'; i++, ptr++) {
    if (i<(int)DecSymPos)
      NStr[i] = *ptr;
    else {
      NStr[i] = '\0';
      strcpy(DecStr, ptr);
      break;
    }
  }
  NStr[i] = 0;
  //  Now insert commas into NStr
  strcpy(A, NStr);
  i = DecSymPos % 3;
  for(j=0,ptr = &NStr[i]; *ptr != 0; j++,i++, ptr++) {
    if (!(j%3) && (i)) {
      A[i] = ThousandsSeparator;
      ++i;
    }
    A[i] = *ptr;
  }
  A[i] = 0;
  strcat(A, DecStr);
  sprintf(temp, "%c%*s", Sign, width-1, A);
  return temp;
}

static void PrintTotals(int type)
{
  int      i;
  int      TotalsFlag;
  ReportColumnType *rc;
  double *ptr;
  char buffer[STRSIZ];

  switch (type) {
    case    TOTAL: ptr =         Total; break;
    case    GROUP: ptr =    GroupTotal; break;
    case SUBGROUP: ptr = SubGroupTotal; break;
  }
  TotalsFlag = FALSE;
  for(i = 0; i < (int)RepTempl->RepMaxOrder; i++)
    TotalsFlag = TotalsFlag || RepTempl->FieldMap[i]->TotalThisColumn;
  if (TotalsFlag) {
    if (type == TOTAL) {
      ShiftLineNumber(1);
      WriteToAlt("%s%s", Space(RepTempl->LeftMargin-1), Stars_Total_Stars);
    }
    else {
      if (RepTempl->LinesPerPage - LineNumber < 1)
        ShiftLineNumber(PageLength);
      WriteToAlt("%s%s", Space(RepTempl->LeftMargin-1), (type == GROUP) ? Stars_SubTotal_Stars : Stars_SubSubTotal_Stars);
    }
    ShiftLineNumber(1);
    WriteToAlt("%s  ", LM); // 2 spaces need to account for delete star
    for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
      rc = RepTempl->FieldMap[i];
      if (type == TOTAL)
        WriteToAlt(PrinterCode(rc->PrePrinterCode));
      if (rc->TotalThisColumn) {
        if (rc->Commas) {
          LeftPad(buffer, WithCommas(*(ptr+i), rc->Width,rc->DecimalPlaces),rc->Width);
          WriteToAlt(buffer);
        }
        else
          WriteToAlt(SReal(*(ptr+i), rc->Width, rc->DecimalPlaces));
      }
      else
        WriteToAlt(Space(rc->Width));
      if (i != (int)RepTempl->RepMaxOrder-1)
        WriteToAlt(Space(rc->Tab));
      if (type == TOTAL)
        WriteToAlt(PrinterCode(rc->PostPrinterCode));
    }
    if (type != TOTAL)
      memset((type == GROUP) ? GroupTotal : SubGroupTotal, 0, sizeof(TotalsArray));
    ShiftLineNumber(1);
  }
}

static void ExtractFromQuotes(char *dest, char * _label)
{
  char *sptr;
  int  StartCol, EndCol;
  char x[STRSIZ];

  StartCol = PosOf(1,_label,cmd);
  if (StartCol < 0)
    *x = 0;
  else {
    EndCol = StartCol + strlen(_label);
    strcpy(x, &cmd[EndCol + 1]);// +2 to skip around first double quote
    sptr = strchr(x, '\'');
    *sptr = 0;
    EndCol += (int) (sptr - x) + 2;
    // remove the entire clause from the command
    Delete(cmd,StartCol,EndCol - StartCol + 1);
  }
  strcpy(dest, x);
}

static void KillSpaces(char *substr, int offset)
{
  int pos;

  while((pos = PosOf(1, substr, cmd)) >= 0)
    Delete(cmd, pos + offset, 1);
}

static int CheckClause(char *clause, char *str)
{
  int pos;

  if ((pos = PosOf(1, clause, str)) >= 0) {
    Delete(str,pos, strlen(clause));
    return 1;
  }
  else
    return 0;
}

static int CheckClauseInt(char *clause, char *source)
{
  int pos, number = 1, len = strlen(clause);
  char str[STRSIZ], *ptr;

  pos = PosOf(1, clause, source);
  if (pos >= 0) {
    strcpy(str, &source[pos + len]);
    ptr = strchr(str,' ');
    if (ptr)
      *ptr = 0;
    Delete(source, pos, len+strlen(str));
    number = atoi(str);
    if (number < 1)
      number = 1;
  }
  return number;
}

static void ParseCommandString(char * command)
{
  int  i, pos;
  char FileName[80];
  int  LeaveCaseAlone;
  int  PrinterCol;
  char PrinterName[11];

  cmd = command;
  *AlternateName = 0;
  if (!*Trim(command)) {
    SetError(InvalidParameter,1,RPTFileNotSpecified);
    return;
  }
  KillSpaces("  ", 0); // get rid of extra spaces:
  KillSpaces(" =", 0); // get rid of ' =' and '= '
  KillSpaces("= ", 1);
  // upper case everything outside of double quotes (i.e., leave the message string alone)
  LeaveCaseAlone = FALSE;
  for (i = 0; i < (int)strlen(command); i++) {
    if (command[i] == '\'')
      LeaveCaseAlone = !LeaveCaseAlone;
    if (!LeaveCaseAlone)
      command[i] = toupper(command[i]);
  }
  if ((pos = PosOf(1, " ", command)) < 0) {
    strcpy(FileName, command);
    *command = 0;
  }
  else {// RPT filename MUST be first parameter in the command string:
    strncpy(FileName, command, pos);
    FileName[pos] = 0;
    Delete(command, 0, pos+1);
  }
  // look for a message string
  WhereXMessage = wherex();
  WhereYMessage = wherey();
  *ReportMessage = 0;
  BlinkMessage = 0;
  *PreReportCode = 0;
  *PostReportCode = 0;
  ExtractFromQuotes(ReportMessage, "MESSAGE=");
  ExtractFromQuotes(UserHeading,"HEADING=");
  ExtractFromQuotes(PreReportCode,"PRECODE=");
  ExtractFromQuotes(PostReportCode,"POSTCODE=");
  PrinterCol = PosOf(1,"PRINTER=",command);
  if (PrinterCol >= 0) {
    strcpy(PrinterName,&command[PrinterCol + 8]);
    *(strchr(PrinterName,' ')) = '\0';
    Delete(command,PrinterCol, 8 + strlen(PrinterName));
    PrintDevice = 0;
    if (PosOf(1,"LPT", PrinterName) == 0)
      PrintDevice = atoi(&PrinterName[3]) - 1;
    if (PrintDevice>3)
      PrintDevice = 0;
  }
  else
    PrintDevice = 0;
  // look for the destination
  BlinkMessage = CheckClause("BLINK", command);
  PrintOn = CheckClause("TO PRINT", command);
  ConsoleOn = CheckClause("TO SCREEN", command);
  if ((pos = PosOf(1,"TO FILE",command)) >= 0) {
    AlternateOn = TRUE;
    strcpy(AlternateName,&command[pos + 8]);
    *(strchr(AlternateName,' ')) = '\0';
    Delete(command,pos,PosOf(1,AlternateName,command)-pos + strlen(AlternateName));
    strcpy(AlternateName,AddExt(Ltrim(AlternateName),"TXT"));
    if (!ValidFilename(AlternateName)) {
      SetError(InvalidParameter,2,AlternateName,NotAValidDOSFilename);
      return;
    }
  }
  else
    AlternateOn = FALSE;
  // if no destination is specified, default to the screen
  if (!(PrintOn || ConsoleOn || AlternateOn))
    ConsoleOn = TRUE;
  if (ConsoleOn) {
#ifdef _MSC_VER
    _clearscreen(_GWINDOW);
#else
    clrscr();
#endif
    gotoxy(1,1);
  }
  ConnectFlag = CheckClause("CONNECT", command);
  if (!ConnectFlag) {
    PageNumber = 1; // if not connected, PageNumber is reset to 1
    LineNumber = 1;
  }
  // look for starting page number if specified
  if (!ConnectFlag) // cannot specify a page number if report is connected to prior
    PageNumber = CheckClauseInt("PAGE=",command);
  // look for number of copies
  Copies = CheckClauseInt("COPIES=",command);
  // open the alternate file
  AppendFlag = CheckClause(" APPEND",command);
  if (AppendFlag)
    strcat(AlternateName, " APPEND");
  SetAlternateTo(AlternateName);
  strcpy(command,FileName);
}

static char * GroupSubGroupHeading(int type)
{
  static char _tzfar temp[STRSIZ] = { 0 };
  char *(*HeadingPtr)(void);
  char *      gptr;

  HeadingPtr = (type == GROUP) ? GroupHeadingPtr : SubGroupHeadingPtr;
  if (!HeadingPtr)
    return "";
  else {
    strcpy(temp, HeadingPtr());
    // replace semicolons with cr/lf
    while ((gptr = strchr(temp,';')) != NULL) {
      *gptr = 0;
      sprintf(tmp_buf,"\r\n%s",gptr+1);
      strcat(gptr-1, tmp_buf);
    }
    return temp;
  }
}

static char *GroupSubGroupData(int grouptype)
{ // By else-default the func may return garbage from the latest call
  static char _tzfar temp[STRSIZ] = { 0 };
  int  n;
  char *groupfield;

  groupfield = (grouptype == GROUP) ? RepTempl->GroupField : RepTempl->SubGroupField;
  n = (grouptype == GROUP) ? GroupFieldNumber : SubGroupFieldNumber;
  if ((UsersColumnFunc || RPTVersion5) && (n == 0)) {
    if (*(RepTempl->FieldMap[n]->Name) == '@') {
      strcpy(ReportColumnString, Trim(groupfield+1));
      ReportColumnWidth = 0;
      dBASEOrder = oldOrder;
      strcpy(temp, UsersColumnFunc());
    }
    else
      strcpy(temp, iEvaluate(Trim(groupfield)));
    dBASEOrder = FALSE;
  }
  else {
    switch (FieldType(n)) {
      case 'C':
      case 'D':
      case 'N':
      case 'F':
        return (char *)(FieldAddress(n));
      case 'L':
        return (*(BOOL *)FieldAddress(n)) ? "T" : "F";
      case 'M':
        return Replicate('-',RepTempl->FieldMap[n]->Width);
    }
  }
  return temp;
}

static char * WrapString(char *x, unsigned char s, unsigned char w, unsigned char *e)
// given a string x, a starting column s, and a width w,
//   this function computes the ending column+1 e,
//   and returns the string that will fit in the width
{
  unsigned int test, len = strlen(x);

  *e = test = s + w - 1;
  if ((test >= len) || (test > STRSIZ-1)) {
    // string is shorter than or equal to the width, so no wrap is
    // necessary, or.. the width plus the starting column takes us past
    // the size of a string
    strcpy(tmp_buf, &x[s-1]);
    tmp_buf[test+1] = 0;
    *e = 0;   // signal that no more to do
    return Pad(Trim(tmp_buf), w);
  }
  // is the next char a space? that means we can break the string right here
  if (x[test] == ' ') {
    *e = s + w + 1;   // furthermore, we can just skip over the space for the next pass
    strcpy(tmp_buf, &x[s-1]);
    tmp_buf[w] = 0;
    //  are there more chars to wrap next pass?
    if ((*e > len) || (!Trim(&x[*e-1])[0]))
      *e = 0;
    else
      ExcessCharacterFlag = TRUE;
    return tmp_buf;
  }
  else {   // its not that easy...we need to find a place to break up the string
    if (x[*e+1] == ' ' && s>1) {
      ++*e;
      ++s;
    }
    while ((x[*e] != ' ') && (*e > s))
      --*e;   // find the right most blank char
    if (*e == s)   // no blank chars found, so use all chars
      *e = s + w - 1;
    ++*e;
    strcpy(tmp_buf, &x[s-1]);
    tmp_buf[*e-s+1] = 0;
    //  are there more chars to wrap next pass?
    if ((*e > len) || (!Trim(&x[*e-1])[0]))
      *e = 0;
    else
      ExcessCharacterFlag = TRUE;
    return Pad(Trim(tmp_buf),w);
  }
}   //  WrapString

static int MemoEof(unsigned char n)
{
  unsigned char x;
  FILE *mf;

  mf = WorkArea[Selected]->MemoArea->Memofile;
  if (MemoPointer[n] > 0) {
    fseek(mf, MemoPointer[n], SEEK_SET);
    fread(&x, 1, 1, mf);
    return x == 0x1A;
  }
  return TRUE;
}

static void MemoReadLn(unsigned char n, char * x)
{
  unsigned char c;
  char cstr[2] = { 0, 0 };
  FILE *mf;

  x[0] = 0;
  if (MemoPointer[n] > 0) {
    mf = WorkArea[Selected]->MemoArea->Memofile;
    do {
      fseek(mf, MemoPointer[n],SEEK_SET);
      if (fread(&c,1,1,mf) == 1) {
        if ((c!=0x0D)&&(c!=0x0A)&&(c!=0x1A)&&(c!=0x8D)) { // 8D is the soft cr
          *cstr = c; // stringize c...
          strcat(x, cstr);
        }
        ++MemoPointer[n];
      }
      else
        MemoPointer[n] = 0;
    } while ((c!=0x0A)&&(c!=0x1A) && !feof(mf));
  }
}

static char * MemoString(unsigned char n, unsigned char e)
{
  if (!e) {
    if (MemoEof(n))
      return "";
    MemoReadLn(n,MemoLine[n]);
  }
  return MemoLine[n];
}

static char *ReportLine(void)
{
  char    temp1[STRSIZ], temp2[STRSIZ];
  char    usersString[STRSIZ], LogicalString[2];
  int     i;
  double *dptr, dvalue;
  long   *longvalueptr;
  ReportColumnType *rc;

  memset(ECol, 0, sizeof(ECol));
  ExcessCharacterFlag = FALSE;
  strcpy(temp1, LM);   // set the left margin
  // set the deleted record indicator
  strcat(temp1, Deleted() ? "* " : "  ");
  // step through each column
  for(i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    rc = RepTempl->FieldMap[i];
    strcat(temp1, PrinterCode(rc->PrePrinterCode));
    if (rc->N) {
     switch (FieldType(rc->N)) {
      case 'C':
        strcpy(usersString,Trim((char *)FieldAddress(rc->N)));
        strcat(temp1, *usersString ?
        WrapString(usersString,1,rc->Width,&ECol[i]) :
        Space(rc->Width));
        break;
      case 'D':
        strcpy(DateString,Trim(FieldAddress(rc->N)));
        if (rc->BlankZeros && ((strcmp(DateString,"  /  /") == 0) || (strcmp(DateString,"  .  .") == 0) || (strcmp(DateString,"  -  -") == 0)))
          *DateString = 0;
        strcat(temp1, Pad(DateString,rc->Width));
        break;
      case 'N':
      case 'F':
        if (FieldDec(rc->N) == 0) { //  field is a long
          longvalueptr = (long *)FieldAddress(rc->N);
          strcpy(NumberString, SInteger(*longvalueptr, 0));
          if (rc->TotalThisColumn) {
            Total[i] += *longvalueptr;
            if (GroupTotal)
              GroupTotal[i] += *longvalueptr;
            if (SubGroupTotal)
              SubGroupTotal[i] += *longvalueptr;
          }
        }
        else {  //  numeric value is a real (Double)
          dptr = (double *)FieldAddress(rc->N);
          strcpy(NumberString,SReal(*dptr,rc->Width,rc->DecimalPlaces));
          if (rc->TotalThisColumn) {
            Total[i] += *dptr;
            if (GroupTotal)
              GroupTotal[i] += *dptr;
            if (SubGroupTotal)
              SubGroupTotal[i] += *dptr;
          }
        }
        if (rc->Commas)
          strcpy(NumberString,WithCommas(atof(NumberString), rc->Width,rc->DecimalPlaces));
        if (strlen(NumberString) > rc->Width)
          strcpy(NumberString,Replicate('*',rc->Width));
        if (rc->BlankZeros && (RealVal(NumberString) == 0.0F))
          strcpy(NumberString,Space(rc->Width));
        LeftPad(temp2, NumberString,rc->Width);
        strcat(temp1, temp2);
        break;
      case 'L':
        *(int*)LogicalString = *(BOOL *)FieldAddress(rc->N) ? 'T\0' : 'F\0';
        if (rc->BlankZeros && (*LogicalString == 'F'))
          *LogicalString = ' ';
        strcat(temp1, Space(rc->Width / 2));
        strcat(temp1, LogicalString);
        strcat(temp1, Space(rc->Width - (rc->Width / 2) - 1));
        break;
      case 'M':
        strcpy(temp2,Trim(MemoString(rc->N,ECol[i])));
        strcat(temp1, *temp2 ?
          WrapString(temp2,1,rc->Width,&ECol[i]) : Space(rc->Width));
        if (!MemoEof(rc->N))
          ExcessCharacterFlag = ContinuationString[i] = TRUE;
        break;
     }   //  case
    }
    else {  // user wants to supply his own function,
            // or the field is a dBASE expression
      if (UsersColumnFunc || RPTVersion5) {
        if (*rc->Name == '@') {  // UDF indicator
          strcpy(ReportColumnString, Trim(rc->Name+1));// remove the '@' char
          ReportColumnWidth = rc->Width;
          dBASEOrder = oldOrder;
          strcpy(usersString,Trim(UsersColumnFunc()));
        }
        else {
          strcpy(ReportColumnString, Trim(rc->Name));
          strcat(ReportColumnString, Trim(rc->NameTail));
          strcpy(usersString, iEvaluate(ReportColumnString));
          *ReportColumnString = 0;
        }
        dBASEOrder = FALSE;
        if (*usersString) {
          strcpy(temp2,WrapString(usersString,1,rc->Width,&ECol[i]));
          strcat(temp1, temp2);
          if (rc->TotalThisColumn) {
            dvalue = RealVal(usersString);
            Total[i] += dvalue;
            if (GroupTotal)
              GroupTotal[i] += dvalue;
            if (SubGroupTotal)
              SubGroupTotal[i] += dvalue;
          }
          if (strlen(usersString) > rc->Width)
            ExcessCharacterFlag =  ContinuationString[i] = TRUE;
        }
        else
          strcat(temp1, Space(rc->Width));
      }
      else  //  users func = NULL
        strcat(temp1,Space(rc->Width));
    }
    if (i < (int)RepTempl->RepMaxOrder)
      strcat(temp1, Space(rc->Tab));   // no need for tab on the last data column
    strcat(temp1, PrinterCode(rc->PostPrinterCode));
  }
  return Trim(temp1);
}   //  ReportLine

static char * ExcessLine(void)
{
  char      temp1[STRSIZ], temp2[STRSIZ], usersString[STRSIZ];
  int i;
  unsigned char scol, k;
  ReportColumnType *rc;

  ExcessCharacterFlag = FALSE;
  strcpy(temp1,LM);
  strcat(temp1, "  ");
  // 2 spaces are necessary..they are reserved for the delete indicator
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    rc = RepTempl->FieldMap[i];
    strcat(temp1,PrinterCode(rc->PrePrinterCode));
    if ((ECol[i] == 0) && (!ContinuationString[i]))
      strcat(temp1, Space(rc->Width));
    else {
      if (rc->N) {
        scol = ECol[i];
        if (scol == 0)
          scol = 1;
        strcat(temp1,
        Pad(Ltrim(WrapString(Trim((FieldType(rc->N) == 'M') ?
        MemoString(rc->N,ECol[i]) : FieldAddress(rc->N)),scol,
        rc->Width,&ECol[i])),rc->Width));
      }
      else {
        if ((UsersColumnFunc || RPTVersion5) && (ECol[i] > 0)) {
          if (*rc->Name == '@') {
            strcpy(ReportColumnString, Trim(rc->Name+1));
            ReportColumnWidth = rc->Width;
            dBASEOrder = oldOrder;
            strcpy(usersString,Trim(UsersColumnFunc()));
          }
          else {
            strcpy(ReportColumnString, Trim(rc->Name));
            strcat(ReportColumnString, Trim(rc->NameTail));
            strcpy(usersString, iEvaluate(ReportColumnString));
            *ReportColumnString = 0;
          }
          dBASEOrder = FALSE;
          scol = ContinuationString[i] ? ECol[i] : 1;
          strcpy(temp2,Pad(Ltrim(WrapString(usersString,scol,rc->Width,&ECol[i])),rc->Width));
          strncat(temp1, temp2, STRSIZ-1-strlen(temp1));
        }
        else {
          strcat(temp1, Space(rc->Width));
          ContinuationString[i] = FALSE;
        }
      }
    }
    if (i < (int)(RepTempl->RepMaxOrder-1))
      strcat(temp1,Space(rc->Tab));
    strcat(temp1,PrinterCode(rc->PostPrinterCode));
  }
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    k = RepTempl->FieldMap[i]->N;
    if (HasMemos || !k) {
      if (k) {
        if (FieldType((int)k) == 'M')
          ContinuationString[i] = (ECol[i] > 0) ? TRUE : !MemoEof(k);
      }
      else
        ContinuationString[i] = ECol[i] > 0;
    }
    if (ContinuationString[i])
      ExcessCharacterFlag = TRUE;
  }
  return Trim(temp1);
}   //  ExcessLine

static void FreeMemoLines(void)
{
  int i, k;

  if (HasMemos)
    for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
      k = RepTempl->FieldMap[i]->N;
      if (k)
        if ((k <= MaxFieldCount) && (FieldType((int) k) == 'M'))
          free(MemoLine[k]);
    }
}

static void cleanrepmem(void)
{ // release memory taken by ReportForm:
  int i;

  FreePtrClear((void*) &NumberString);
  FreePtrClear((void*) &tmp_buf);
  FreePtrClear((void*) &ECol);
  FreePtrClear((void*) &ContinuationString);
  FreePtrClear((void*) &ReportMessage);
  FreePtrClear((void*) &blankLine);
  FreePtrClear((void*) &MemoPointer);
  FreePtrClear((void*) &UserHeading);
  FreePtrClear((void*) &RepPCbuf);
  FreePtrClear((void*) &PostReportCode);
  FreePtrClear((void*) &PreReportCode);
  FreePtrClear((void*) &LM);
  FreeMemoLines();
  FreePtrClear((void*) &MemoLine);
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++)
    FreePtrClear((void*) &(RepTempl->FieldMap[i]));
  FreePtrClear((void*) &RepTempl);
  FreePtrClear((void*) &SubGroupTotal);
  FreePtrClear((void*) &GroupTotal);
  FreePtrClear((void*) &Total);
}

void ReportForm(const char * reportfname)
{
  int   i, saveConsoleOn, k;
  char  CurrentGroupData[STRSIZ];
  char  CurrentSubGroupData[STRSIZ];
  int   UseTotalsFlag;
  char  reportstring[STRSIZ];
  int   FirstGroup;
  int   DynamicGrouping;
  unsigned char *MaxNumberOfRows = (unsigned char *)MK_FP(0x40,0x84);
  char  LastRow;   //  will be either 25, 43, or 50
  char  SeparatorLine[STRSIZ];
  char  SaveGroupHeading[STRSIZ], SaveSubGroupHeading[STRSIZ];
  int   SubFlag, jumper;
  short saveWrap;
  unsigned saveCursor;

#ifdef _MSC_VER // set wrap off
  saveWrap = _wrapon(_GWRAPOFF);
#else
  saveWrap = _wscroll;
  _wscroll = 0;
#endif
  LastRow = (*MaxNumberOfRows > 0) ? (*MaxNumberOfRows + 1) : 25;
  LineNumberCounter = 1;
  oldOrder = dBASEOrder;
  dBASEOrder = FALSE;
  SubGroupTotal = GroupTotal = Total = NULL;
  // use longjmp to allow the user to hit ESC at any time in a screen
  // listing and return to the next line of code, which can then exit
  jumper = setjmp(ReportJmp);
  if (jumper) {
#ifdef _MSC_VER // set wrap to saveWrap on exit
    _wrapon(saveWrap);
#else
    _wscroll = saveWrap;
#endif
    ReportCheckPrinterStatusPtr = NULL;
    if (jumper == 217) // 'no memory' event
      SetError(217, 1, " [ReportForm]");
    else {
      At(WhereXMessage,WhereYMessage,Space(strlen(ReportMessage)));
      Paint((int)WhereXMessage,(int)WhereYMessage,(char)strlen(ReportMessage),7,0);
    }
    SetAlternateTo("");
    cleanrepmem();
    dBASEOrder = oldOrder;
    ReportResult = 1;
    return;
  }
  GetMem((void**)&RepTempl, sizeof(ReportTemplateType));
  GetMem((void**)&LM, STRSIZ);
  GetMem((void**)&PreReportCode, STRSIZ);
  GetMem((void**)&PostReportCode, STRSIZ);
  GetMem((void**)&RepPCbuf, STRSIZ);
  GetMem((void**)&UserHeading, STRSIZ);
  GetMem((void**)&MemoPointer, MaxFieldCount * sizeof(long));

  GetMem((void**)&blankLine, 84);
  memset(blankLine, ' ', 80);
  *(int*) (blankLine + 80) = '\r\0';

  GetMem((void**)&ReportMessage, 84);
  GetMem((void**)&ContinuationString, MaxFieldCount * sizeof(int));
  GetMem((void**)&ECol, MaxFieldCount * sizeof(char));
  GetMem((void**)&tmp_buf, STRSIZ);
  GetMem((void**)&NumberString, STRSIZ);
  RepTempl->RepMaxOrder = ReportResult = 0;
  ReportCheckPrinterStatusPtr = ReportCheckPrinterStatus;
  strcpy(RepPCbuf, Ltrim(reportfname));
  // parse the command line and open the Alternate device
  ParseCommandString(RepPCbuf);
  ReadRptFile(RepPCbuf);

  if (OverrideRPT.PageWidth)
    RepTempl->PageWidth = OverrideRPT.PageWidth;
  if (OverrideRPT.TopMargin)
    RepTempl->TopMargin = OverrideRPT.TopMargin;
  if (OverrideRPT.BottomMargin)
    RepTempl->BottomMargin = OverrideRPT.BottomMargin;
  if (OverrideRPT.LeftMargin)
    RepTempl->LeftMargin = OverrideRPT.LeftMargin;
  if (OverrideRPT.RightMargin)
    RepTempl->RightMargin = OverrideRPT.RightMargin;
  if (OverrideRPT.LinesPerPage)
    RepTempl->LinesPerPage = OverrideRPT.LinesPerPage;
  if (OverrideRPT.OverrideBooleans) {
    RepTempl->DoubleSpace = OverrideRPT.DoubleSpace;
    RepTempl->EjectBefore = OverrideRPT.EjectBefore;
    RepTempl->EjectAfter = OverrideRPT.EjectAfter;
  }

  // the following 9 lines are from former ParseCommandString()
  // if connected to prior report, check whether to go to a new page
  // ..not enough room for header and headings
  if ((LineNumber > RepTempl->LinesPerPage - RepTempl->BottomMargin - 10)
  && RepTempl->LinesPerPage && ConnectFlag) {
    ++PageNumber;
    LineNumber = 1;
    ShiftLineNumber(0);
  }
  // if there are memos, we need to allocate pointers
  //  to the string vars for them,
  //  well as initialize the byte offset pointers into the dbt file
  HasMemos = FALSE;
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
    k = RepTempl->FieldMap[i]->N;
    if (k)
      if ((k <= MaxFieldCount) && (FieldType(k) == 'M')) {
        if (!HasMemos) // we found a first memo field, get some memory...
          GetMem((void**) &MemoLine, MaxFieldCount * sizeof(void*));
        GetMem((void**) &(MemoLine[k]), STRSIZ);
        HasMemos = TRUE;
      }
  }
  // if the report calls for at least one memo field,
  //  but has the user linked in the memo unit?
  if (HasMemos && !WorkArea[Selected]->MemoArea) {
    cleanrepmem();
    SetError(InvalidParameter,3, "Memo ", Not_linked_in,"[ReportForm]");
    return;
  }
  PageLength = RepTempl->LinesPerPage-RepTempl->BottomMargin;
  Continuous = (RepTempl->LinesPerPage == 0);
  // report starts here:
  for (i = 0; i < (int)RepTempl->RepMaxOrder; i++)
    ContinuationString[i] = FALSE;
  if (!ConsoleOn) {
    At(WhereXMessage,WhereYMessage,ReportMessage);
    if (BlinkMessage)
      Paint((int)WhereXMessage,(int)WhereYMessage,(char)strlen(ReportMessage),1,11);
    else
      Paint((int)WhereXMessage,(int)WhereYMessage,(char)strlen(ReportMessage),11,1);
  }
  //  Print pre-report printer codes now:
  saveConsoleOn = ConsoleOn;
  ConsoleOn = FALSE;
  WriteToAlt(PrinterCode(PreReportCode));
  ConsoleOn = saveConsoleOn;
  if (RepTempl->EjectBefore)
    ShiftLineNumber(0);
  PrintHeading();
  // determine which field numbers are the fields being grouped and subgrouped, if any:
  GroupFieldNumber =  SubGroupFieldNumber = 0;
  UseTotalsFlag = FALSE;
  for(i = 0; i < (int)RepTempl->RepMaxOrder; i++)
    if (RepTempl->FieldMap[i]->TotalThisColumn)
      UseTotalsFlag = TRUE;
  if (UseTotalsFlag) {
    GetMem((void**) &Total, sizeof(TotalsArray));
    memset(Total, 0, sizeof(TotalsArray));
  }
  k = FieldCount();
  if ((Trim(RepTempl->GroupField)[0]) || GroupHeadingPtr) {
    for (i = 0; i < k; i++)
      if (strcmp(Field(i),RepTempl->GroupField) == 0)
        GroupFieldNumber = i;
    if (UseTotalsFlag) {
      GetMem((void**) &GroupTotal, sizeof(TotalsArray));
      memset(GroupTotal, 0, sizeof(TotalsArray));
    }
  }
  if ((Trim(RepTempl->SubGroupField)[0]) || SubGroupHeadingPtr) {
    for(i = 0; i < k; i++)
      if (strcmp(Field(i), RepTempl->SubGroupField) == 0)
        SubGroupFieldNumber = i;
    if (UseTotalsFlag) {
      GetMem((void**) &SubGroupTotal, sizeof(TotalsArray));
      memset(SubGroupTotal,0,sizeof(TotalsArray));
    }
  }
  *CurrentGroupData = *CurrentSubGroupData = 0;
  FirstGroup = TRUE;
  if (!GroupHeadingPtr && SubGroupHeadingPtr) {
    GroupHeadingPtr = SubGroupHeadingPtr;
    SubGroupHeadingPtr = NULL;
  }
  DynamicGrouping = GroupHeadingPtr != NULL;
  GoTop();
  SaveCursor(&saveCursor);
  SetCursorOff();
  while (!dEOF()) {
    if (DynamicGrouping) {
      SubFlag = FALSE;
      strcpy(SaveGroupHeading,GroupSubGroupHeading(GROUP));
      if (SaveGroupHeading[0]) {
        if (!FirstGroup) {
          if (SubGroupHeadingPtr) {
            PrintTotals(SUBGROUP);
          }
          PrintTotals(GROUP);
          if (RepTempl->PageEjectAfterGroup)
            ShiftLineNumber(PageLength);
        }
        else
          FirstGroup = FALSE;
        WriteToAlt("%s%s",Space(RepTempl->LeftMargin - 1),SaveGroupHeading);
        ShiftLineNumber(1);
        if (RepTempl->DoubleSpace)
          ShiftLineNumber(1);
      }
      else {
        if (SubGroupHeadingPtr) {
          strcpy(SaveSubGroupHeading,GroupSubGroupHeading(SUBGROUP));
          if (SaveSubGroupHeading[0])
            PrintTotals(SUBGROUP);
          SubFlag = TRUE;
        }
      }
      if (SubGroupHeadingPtr) {
        if (!SubFlag)
          strcpy(SaveSubGroupHeading,GroupSubGroupHeading(SUBGROUP));
        if (SaveSubGroupHeading[0]) {
          WriteToAlt("%s%s",Space(RepTempl->LeftMargin -1),SaveSubGroupHeading);
          ShiftLineNumber(1);
          if (RepTempl->DoubleSpace)
            ShiftLineNumber(1);
        }
      }
    } // end of dynamic grouping
    else {
      if (SubGroupFieldNumber > 0) // sub-group changed but group did not
        if ((strcmp(GroupSubGroupData(SUBGROUP),CurrentSubGroupData) != 0)
          && (strcmp(GroupSubGroupData(GROUP),CurrentGroupData) == 0)
          && CurrentSubGroupData[0])   //  and not first time
          PrintTotals(SUBGROUP);
      if (GroupFieldNumber > 0)
        if (strcmp(GroupSubGroupData(GROUP),CurrentGroupData) != 0) {
          if ((SubGroupFieldNumber > 0) && CurrentSubGroupData[0])
            PrintTotals(SUBGROUP);
          if (CurrentGroupData[0])
            PrintTotals(GROUP);
          if (RepTempl->PageEjectAfterGroup && CurrentGroupData[0])
            ShiftLineNumber(PageLength);
          strcpy(CurrentGroupData,GroupSubGroupData(GROUP));
          CurrentSubGroupData[0] = '\0';
          ShiftLineNumber(1);
          WriteToAlt("%s** %s %s",Space(RepTempl->LeftMargin - 1),Trim(RepTempl->GroupHeading),CurrentGroupData);
          ShiftLineNumber(1);
          if (RepTempl->DoubleSpace)
            ShiftLineNumber(1);
        }
      if (SubGroupFieldNumber > 0)
        if (strcmp(GroupSubGroupData(SUBGROUP), CurrentSubGroupData) != 0) {
          strcpy(CurrentSubGroupData,GroupSubGroupData(SUBGROUP));
          ShiftLineNumber(1);
          WriteToAlt("%s* %s %s", Space(RepTempl->LeftMargin - 1),Trim(RepTempl->SubGroupHeading),CurrentSubGroupData);
          ShiftLineNumber(1);
          if (RepTempl->DoubleSpace)
            ShiftLineNumber(1);
        }
    } // end of static grouping
    if (HasMemos) // set up the memopointers for the memos of this record
      for (i = 0; i < (int)RepTempl->RepMaxOrder; i++) {
        k = RepTempl->FieldMap[i]->N;
        if (k)
          if ((k <= MaxFieldCount) && (FieldType(k) == 'M'))
            MemoPointer[k] = *((long *) FieldAddress(k)) * 512;
      }
    strcpy(reportstring,ReportLine());
    // ReportLine is a string function that "assembles" one line of data,
    // and sets the ExcessCharacterFlag indicating that another
    // line is need for data that wraps
    if (!RepTempl->SummaryReportOnly) {
      if (UserEject())
        ShiftLineNumber(PageLength);
      // before we print the record, check with the user
      // to see if he wants a page eject before the record
      // next, see if the user wishes to insert a divider line of text
      strcpy(SeparatorLine,UserDivider());
      if (SeparatorLine[0]) {
        WriteToAlt(SeparatorLine);
        ShiftLineNumber(1);
      }
      WriteToAlt(reportstring);
      ShiftLineNumber(1);
      for (i = 0; i < (int)RepTempl->RepMaxOrder; i++)
        if (ContinuationString[i])
          ExcessCharacterFlag = TRUE;
      while (ExcessCharacterFlag) {
        WriteToAlt(ExcessLine());
        ShiftLineNumber(1);
      }
      if (RepTempl->DoubleSpace)
        ShiftLineNumber(1);
    }
    Skip(1); // go to the next record
  } // dEOF
  RestoreCursor(saveCursor);   // was SetCursorOn();
  if (DynamicGrouping) {
    if (SubGroupHeadingPtr)
      PrintTotals(SUBGROUP);
    PrintTotals(GROUP);
  }
  else {
    if (GroupFieldNumber > 0) {
      if ((SubGroupFieldNumber > 0))
        PrintTotals(SUBGROUP);
      PrintTotals(GROUP);
    }
  }
  PrintTotals(TOTAL);
  // Print post-report printer code now:
  WriteToAltNoConsole(PrinterCode(PreReportCode));
  if (RepTempl->EjectAfter)
    ShiftLineNumber(0);
  if (ConsoleOn) {
    for(i = wherey(); i<LastRow; i++) // clean the last page
      printf(blankLine);
    printf(EndOfReport);
    Wait("");
  }
  SetAlternateTo("");
  At(WhereXMessage,WhereYMessage,Space(strlen(ReportMessage)));
  Paint((int)WhereXMessage,(int)WhereYMessage,(char)strlen(ReportMessage),7,0);
  cleanrepmem();
  ReportCheckPrinterStatusPtr = NULL;// Report needs its own Checker
  dBASEOrder = oldOrder;
  PrintDevice = 0; // always reset to default value
#ifdef _MSC_VER// reset wrap to saved on exit
  _wrapon(saveWrap);
#else
  _wscroll = saveWrap;
#endif
  return;
} // ReportForm
