/* filename: PICKLIST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <string.h>
#ifdef _MSC_VER
#include <graph.h>
#endif
#include <sayget.h>
#include <dbf.h>
#include <pick.h>
  
#define TAGME   1
#define PICKME  2
  
extern int FirstItem;
extern int ItemNo;
extern int MaxItem;
extern int IndexedFile;
extern PickWindowPtr CurrentWindow;
  
void GoToTopItem(void);
void GoToNextItem(void);
char * UsersString(int i);
  
extern int PickOlddBASEOrder;
  
long wmMakeChoice(char * (*StringMaker)(int), long minItem,
long maxItem, long startItem, int PICKorTAG);
extern void (* PickCalcPtr)(void);
void MouseScroll(int up, unsigned char x1, unsigned char y1,
unsigned char x2, unsigned char y2);
  
int wmPickNo(void)
{
  return IndexedFile ? (int) RecNo() : ItemNo;
}
  
static int CheckWatchKeys(unsigned char temp)
{
  if (PickCalcPtr) {
    if (strchr(WatchKeys, temp)) {
      if (!PickOlddBASEOrder)
        dBASEOrder = FALSE;
      LastKey = temp;
      PickCalcPtr();
      dBASEOrder = TRUE;
      return TRUE;
    }
  }
  return FALSE;
}
  
char wmKey(unsigned char * VisibleItem)
{
  unsigned char temp = 0;
  ActivityType SaveActivity;
  EventRec e;
  static int LeftButtonWasDown = FALSE;
  
  SaveActivity = Activity;
  Activity = _Pick;
  GetEvent(&e);
  Activity = SaveActivity;
  switch (e.WhichEvent) {
    case Mouse:
    switch (e.v.sMouse.TargetID) {
      case ReservedID:
        temp = '\x1B';
        break;
      case ReservedID + 1:
        MouseScroll(FALSE, e.v.sMouse.X, e.v.sMouse.Y, e.v.sMouse.X, e.v.sMouse.Y);
        break;
      case ReservedID + 2:
        MouseScroll(TRUE, e.v.sMouse.X, e.v.sMouse.Y, e.v.sMouse.X, e.v.sMouse.Y);
        break;
      case ReservedID + 3:
        if (LeftButtonWasDown) {
          MouseScroll(FALSE, 1, 1, 80, (unsigned char) (CurrentWindow->r1+1));
          LeftButtonWasDown = FALSE;
        }
        break;
      case ReservedID + 4:
        if (LeftButtonWasDown) {
          MouseScroll(TRUE, 1, (unsigned char) (CurrentWindow->R2+1), 80, (unsigned char)MaxAvailRows());
          LeftButtonWasDown = FALSE;
        }
        break;
      default: // mouse click on a pick list item, ignore hits on area below maxitem
        if ((FirstItem + e.v.sMouse.TargetID - 1) <= MaxItem) {
          temp = (unsigned char) (e.v.sMouse.DoubleClick ? '\xFD' : '\xFE');
          *VisibleItem = e.v.sMouse.TargetID;
          LeftButtonWasDown = IsLeftButtonDown();
        }
        break;
    }
      break;
    case Keyboard:
      temp = e.v.sKeyboard.Key;
      if (temp) {
        if (CheckWatchKeys(temp))
          return 0;
      }
      else { // extended key...
        temp = e.v.sKeyboard.ScanCode;
        if (CheckWatchKeys(temp))
          return 0;
        switch (temp) {
          case 'H':
          case  15: temp = '\x05'; break; // UpArrow
          case 'P': temp = '\x18'; break; // DnArrow
          case 'K': temp = '\x13'; break; // LtArrow
          case 'M': temp = '\x04'; break; // RtArrow
          case 'I': temp = '\x12'; break; // PgUp
          case 'Q': temp = '\x03'; break; // PgDn
          case 'G': temp = '\x01'; break; // Home
          case 'O': temp = (unsigned char) '\xFF'; break; // End
          default:  temp = 0; break;
        }
      }
      break;
  }
  return temp;
}
  
void wmHuntItem(char KeyStroke)
{
  char set1[30] = { "!\"#$%&'{|}~\x01\x03\x04\x05\x08\x09\x0D\x12\x13\x18\x1B\x20\xfd\xfe\xff" };
  long StartHunt, start, maxitem;
  int first_time, found, i;
  char ItemString[STRSIZ];
  
  StartHunt = ItemNo;
  start = ItemNo;
  maxitem = MaxItem;
  first_time = TRUE;
  if (Hunt && !strchr(set1, UpCase(KeyStroke)) && ((unsigned) KeyStroke < 0xB0)) {
  
    tryfromtop:
  
    for (i = (int) start, found = 0; (i <= (int) maxitem) && !found; ++i) {
      strcpy(ItemString,  Ltrim(UsersString(i)));
      if ((UpCase(*ItemString) == UpCase(KeyStroke)) || KeyPressed())
        found = TRUE;
      if (KeyPressed())
        break;
    }
    if (found) {
      while (--i != start)
        GoToNextItem();
    }
    if (KeyPressed()) {
      while (KeyPressed())
        getch();
    }
    else { // if we get to the bottom and don't find the item...
      // continue the hunt at the top of the list.
      if (!found && first_time) {
        start = 1;
        maxitem = StartHunt;
        GoToTopItem();
        first_time = 0;
        goto tryfromtop;
      }
    }
  }
}
  
long PickList(char *(*StringMaker)(int), long minItem, long maxItem, long startItem)
{
  return wmMakeChoice(StringMaker, minItem, maxItem, startItem, PICKME);
}
  
