/* filename: WRITMEMF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <utils.h>
#include <memo.h>

extern char *MemoLineTails;

char *DBT (void);
long filesize (FILE *stream);
long NewMemoByteOffset (char *);
int  search_block(long, long, char *);
void add_to_chain(long, long);

char SoftCR[2] = "\xAE";
int  writeok, lb;
long Blocks = 0L;
static int fhandle = 0;
static unsigned count = 0;
static char _tzfar fname[] = { " [EditMemo/CloseMemo]" }, *Pool;

#ifdef NET

int LockMemoFile (void) // just lock the tenth byte
{
  int Success;
  unsigned char Count;
#ifdef WINDOWS
  int i;
#endif
  if (!WorkArea[Selected]->Exclusive) {
    Count = 0;
    do {
      Success = LockUnlock (0, fileno(WorkArea[Selected]->MemoArea->Memofile), 10, 1) == 0;
      ++Count;
      if (!Success)
#ifdef WINDOWS
        for (i = 1; i <= 5000; i++) ;
      // wait about a timer tick
#else
        delay (50);
#endif
    } while (!(Success || (Count > 10)));
    return Success;
  }
  return TRUE;
}

int UnLockMemoFile (void)
{
  if (!WorkArea[Selected]->Exclusive)
    return LockUnlock (1, fileno(WorkArea[Selected]->MemoArea->Memofile), 10, 1) == 0;
  return TRUE;
}
#endif

static int WriteOutOk (char *s, long BlockNo)
{
  int BlockSize;
  dbfRecord d;

  d = WorkArea[Selected]->Handle;

  errno = 0;
  if(DBMemoType == DB4WithDB4Memo) {
    if (!lb) {
      lseek (fhandle, BlockNo*Bsize+sizeof(GROUP_HDR), SEEK_SET);
      BlockSize = Bsize - sizeof(GROUP_HDR);
    }
    else {
      lseek (fhandle, BlockNo*Bsize, SEEK_SET);
      BlockSize = Bsize;
    }
    if (d.EncryptProc)
      d.EncryptProc(s,BlockSize);
    if (write (fhandle,s, BlockSize) != BlockSize)
      errno = ferror (WorkArea[Selected]->MemoArea->Memofile);
  }
  else {
    if (d.EncryptProc)
      d.EncryptProc(s,Bsize);
    lseek (fhandle, BlockNo*Bsize, SEEK_SET);
    if (write (fhandle,s, Bsize) != (int)Bsize)
      errno = ferror (WorkArea[Selected]->MemoArea->Memofile);
  }
  if (errno) {
    // block write & Errorcheck
    writeok = FALSE;
    SetError (errno, 2, DBT (), fname);
    return FALSE;
  }
  return TRUE;
}

void MainHeader(long block, int mode)
{
  // mode: 1 - write, 0 - read
  DBFError = 0;
  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  lseek (fhandle, 0L, SEEK_SET);
  if(mode) {
    if(write (fhandle, &block, sizeof(long)) != sizeof(long))
      DBFError = 29;
  }
  else {
    if(read (fhandle, &block, sizeof(long)) != sizeof(long))
      DBFError = 30;
  }
  if(DBFError)
    SetError (DBFError, 2, DBT (), fname);
  return;
}

void GroupHeader(long *block, GROUP_HDR *gr_hdr, int mode)
{
  // mode: 1 - write, 0 - read

  DBFError = 0;
  lseek (fhandle, *block*Bsize, SEEK_SET);
  if(mode) {
    if(write (fhandle, gr_hdr, sizeof(GROUP_HDR)) != sizeof(GROUP_HDR))
      DBFError = 29;
  }
  else {
    if (read (fhandle, gr_hdr, sizeof(GROUP_HDR)) != sizeof(GROUP_HDR))
      DBFError = 30;
    *block = (gr_hdr->group_length+sizeof(GROUP_HDR))/Bsize+1;
  }
  if(DBFError)
    SetError (DBFError, 2, DBT (), fname);
  return;
}

void UpdateGroupHeader (long ThisLength, long MemoBlock)
// update the memo file header with the new count of blocks
{
  GROUP_HDR gr_hdr;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  DBFError = 0;
  gr_hdr.flag = -1;
  gr_hdr.header_length = 8;
  gr_hdr.group_length = ThisLength+sizeof(GROUP_HDR);
  lseek (fhandle, MemoBlock*Bsize, SEEK_SET);
  if(write (fhandle, &gr_hdr, sizeof(GROUP_HDR)) != sizeof(GROUP_HDR)) {
    DBFError = 29;
    goto err;
  }
#ifdef NET
  if (MultiUser)
    if (!UnLockMemoFile ()) { // generate an error
      DBFError = 1018;
      goto err;
    }
#endif
  return;
err:
  SetError (DBFError, 2, DBT (), fname);
  return;
}

void UpdateMemoHeader (void)
// update the memo file header with the new count of blocks
{
  long NewSize;
  long InvalidBlocks;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  DBFError = 0;
  NewSize = filesize (WorkArea[Selected]->MemoArea->Memofile);
  if (NewSize % Bsize == 0)
    NewSize /= Bsize;
  else
    NewSize = (NewSize / Bsize) + 1;
  lseek (fhandle, 0L, SEEK_SET);
  if(write (fhandle, &NewSize, sizeof(long)) != sizeof(long)) {
    DBFError = 29;
    goto err;
  }
  if (BlocksReadFromFile > 0) {
    lseek (fhandle, 32L, SEEK_SET);
    if(read (fhandle, &InvalidBlocks, sizeof(long)) != sizeof(long)) {
      DBFError = 30;
      goto err;
    }
    lseek (fhandle, 32L, SEEK_SET);
    InvalidBlocks += BlocksReadFromFile;
    //keep track of invalid block count
    if(write (fhandle, &InvalidBlocks, sizeof(long)) != sizeof(long)) {
      DBFError = 29;
      goto err;
    }
  }
#ifdef NET
  if (MultiUser)
    if (!UnLockMemoFile ()) {
      // generate an error
      DBFError = 1018;
      goto err;
    }
#endif
  return;
err:
  SetError (DBFError, 2, DBT (), fname);
  return;
}

long WriteMemoF (long MemoBlock)
{
  int LineNumber;
  unsigned BlockSize;
  long avail, OldBlocks = 0L, tsize, address;
  struct diskfree_t freed;
  GROUP_HDR gr_hdr;

  writeok = TRUE;

  tsize = (DBMemoType == DB4WithDB3Memo) ? 1 /*EOFZ*/ : 0;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);

  if (Linebuffer[0])
    for (LineNumber = 0; LineNumber < Highestline; LineNumber++) {
      tsize += strlen (Linebuffer[LineNumber]);
      if(MemoLineTails[LineNumber])
        tsize += 2;
    }
  // String+CR+LF
  if ((tsize < 3) && (DBMemoType == DB4WithDB3Memo)) {
    address = 0;
#ifndef WINDOWS
    EditorResult = 1;
#endif
    goto Done;
  }
  _dos_getdiskfree (0, &freed);
  avail = (long) freed.avail_clusters * (long) freed.bytes_per_sector
  * (long) freed.sectors_per_cluster;
  if (tsize >= avail) {
    SetError (1004, 2, WorkArea[Selected]->MemoArea->Memofilename, fname);
    return 0L;
  }
  if ((Pool = (char *)malloc(Bsize+1)) == NULL) {
    SetError (217, 1, fname);
    return 0L;
  }

  address = NewMemoByteOffset(fname);
  if (!address) {
    FreePtrClear((void *)&Pool);
    return 0L;
  }

  if(DBMemoType == DB4WithDB3Memo) {
    MemoBlock = address / 512;
    BlockSize = Bsize;
  }
  if(DBMemoType == DB4WithDB4Memo) {
    Blocks = (tsize+sizeof(GROUP_HDR))/Bsize+1;
    if(MemoBlock) {
      OldBlocks = MemoBlock;
      GroupHeader(&OldBlocks,&gr_hdr,0);
      if(Blocks > OldBlocks)
        add_to_chain(MemoBlock,gr_hdr.group_length);
    }
    MemoBlock = search_block(Blocks, MemoBlock, fname);
    UpdateGroupHeader (tsize,MemoBlock); // also unlocks memo if multi-user
    BlockSize = Bsize - sizeof(GROUP_HDR);
  }
  count = 0;
  lb = 0;
  memset(Pool,0,Bsize);
  for (LineNumber = 0; LineNumber < Highestline; LineNumber++) {
    if (count+strlen(Linebuffer[LineNumber]) >= BlockSize) {
      strncat(Pool,Linebuffer[LineNumber],BlockSize-count);
      if (!WriteOutOk(Pool,MemoBlock+lb))
        goto Done;
      memset(Pool,0,Bsize+1);
      strcpy(Pool,Copy(Linebuffer[LineNumber],BlockSize-count,255));
      lb++;
      count = count + strlen(Linebuffer[LineNumber]) - BlockSize;
      BlockSize = Bsize;
    }
    else {
      count += strlen(Linebuffer[LineNumber]);
      strcat(Pool,Linebuffer[LineNumber]);
    }
    if(MemoLineTails[LineNumber]) {
      EndE[0] = MemoLineTails[LineNumber];
      if (count + 1 == BlockSize) {
        Pool[count + 1] = EndE[0];
        count++;
        if (!WriteOutOk(Pool,MemoBlock+lb))
          goto Done;
        memset(Pool,0,Bsize+1);
        lb++;
        count = 0;
        BlockSize = Bsize;
      }
      else if (count + 2 == BlockSize) {
        strcat(Pool,EndE);
        count += 2;
        if (!WriteOutOk(Pool,MemoBlock+lb))
          goto Done;
        memset(Pool,0,Bsize+1);
        lb++;
        count = 0;
        BlockSize = Bsize;
      }
      else {
        strcat(Pool,EndE);
        count += 2;
      }
    }
  }
  if(DBMemoType == DB4WithDB3Memo) {
    strcat(Pool,"\x1A");
    if (!WriteOutOk(Pool,MemoBlock+lb))
      goto Done;
    UpdateMemoHeader (); // also unlocks memo if multi-user
  }
  else {
    strcat(Pool,"\x0");
    if (!WriteOutOk (Pool,MemoBlock+lb))
      goto Done;
  }
Done:
  FreePtrClear((void*)&MemoLineTails);
  FreePtrClear((void*)&Pool);
  if(DBMemoType == DB4WithDB4Memo)
    return MemoBlock;
  else
    if (writeok)
      return (address / Bsize);
  return 0;
}
