/* filename: WINWRMEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef WINDOWS

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <memo.h>

char *DBT(void);
void UpdateMemoHeader(void);
long NewMemoByteOffset(char *);
void UpdateGroupHeader(long, long);
void MainHeader(long,int);
long search_block(long, long, char *);

static char _tzfar fname[] = {" [WinWriteMemo]"};

static int fwritememo(char *buf,unsigned len)
{
  if (WorkArea[Selected]->Handle.EncryptProc)
    WorkArea[Selected]->Handle.EncryptProc(buf,len);
  if (fwrite(buf, 1, len, WorkArea[Selected]->MemoArea->Memofile) != len) {
    SetError(254, 2, DBT(), fname); // internal error
    return FALSE;
  }
  return TRUE;
}

long WinWriteMemo(char *abuffer, unsigned char width)
{
  struct diskfree_t free;
  long Blocks, MemoBlock;
  unsigned offset, NumChars, tsize, buf_off, fl = 0;
  int done, fhandle;
  char buf[Bsize+1];

  DBMemoType = WorkArea[Selected]->Handle.HasMemo;
  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  tsize   = strlen(abuffer);
  if (DBMemoType == DB4WithDB3Memo)
    ++tsize;
  if (tsize < 2)
    goto exit_point;
  _dos_getdiskfree(0, &free);
  if ((long) tsize >= (long) free.avail_clusters * (long) free.bytes_per_sector *
    (long) free.sectors_per_cluster) {
    SetError(1004, 2, WorkArea[Selected]->MemoArea->Memofilename, fname);
    return 0L;
  }
  MemoBlock = NewMemoByteOffset(fname);
  if (!MemoBlock)
    return 0L;
  if (DBMemoType == DB4WithDB4Memo) {
    Blocks = (tsize+sizeof(GROUP_HDR))/Bsize+2;
    MemoBlock = search_block(Blocks,0,fname);
    lseek(fhandle,MemoBlock*Bsize+sizeof(GROUP_HDR),SEEK_SET);
    fl = sizeof(GROUP_HDR);
  }
  offset  = buf_off = tsize = 0;
  memset(buf,0,Bsize+1);
  do {
    NumChars = 0;
    while((NumChars < (unsigned)width) && abuffer[offset] && (buf_off < Bsize - fl)) {
      buf[buf_off++] = abuffer[offset++];
      tsize++;
      ++NumChars;
    }
    done = abuffer[offset] == 0;
    if (!done && buf_off < Bsize - fl) {
      if (NumChars == (unsigned)width) {  //  backup to end of last word
        while(abuffer[offset] != ' ') {
          --offset;
          buf[buf_off--] = 0;
          tsize--;
        }
        buf[buf_off++] = '\x8D';
        tsize++;
        if (buf_off >= Bsize - fl) {
          if (!fwritememo(buf,Bsize-fl))
            goto exit_point;
          fl = 0;
          memset(buf,0,Bsize+1);
          buf_off = 0;
        }
        buf[buf_off++] = '\n';
        tsize++;
        if (buf_off >= Bsize - fl) {
          if (!fwritememo(buf,Bsize-fl))
            goto exit_point;
          fl = 0;
          memset(buf,0,Bsize+1);
          buf_off = 0;
        }
      }
      else {
        buf[buf_off++] = '\r';
        tsize++;
        if (buf_off >= Bsize - fl) {
          if (!fwritememo(buf,Bsize-fl))
            goto exit_point;
          fl = 0;
          memset(buf,0,Bsize+1);
          buf_off = 0;
        }
        buf[buf_off++] = '\n';
        tsize++;
        if (buf_off >= Bsize - fl) {
          if (!fwritememo(buf,Bsize-fl))
            goto exit_point;
          fl = 0;
          memset(buf,0,Bsize+1);
          buf_off = 0;
        }
      }
    }
    if (buf_off >= Bsize - fl) {
      if (!fwritememo(buf,Bsize-fl))
        goto exit_point;
      fl = 0;
      memset(buf,0,Bsize+1);
      buf_off = 0;
    }
  } while (!done);
  if (DBMemoType == DB4WithDB3Memo) {
    buf[buf_off++] = '\x1A';
    if (!fwritememo(buf, Bsize - fl))
      goto exit_point;
    UpdateMemoHeader(); // also unlocks memo file if multi-user
    return MemoBlock / Bsize;
  }
  else {
    UpdateGroupHeader(tsize+sizeof(GROUP_HDR),MemoBlock);
    if (!fwritememo(buf, Bsize - fl))
      goto exit_point;
    return MemoBlock;
  }
exit_point:
  *EndE = '\r';
  return 0L;
}
#endif // WINDOWS
