/* filename: WINRDMEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef WINDOWS
  
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <memo.h>
  
long filesize(FILE *stream);
char *DBT(void);
  
static char _tzfar fname[] = { " [WinReadMemo]" };
  
BOOL WinReadMemo(long StartingMemoBlock, char *Dest, unsigned int MaxChars,
                 unsigned int WrapWidth)
{
  char *GetBuf = NULL, s[11];
  int  EndOfMemo, i = 0, Memo_IV;
  long address, sum;
  FILE *mfile;
  unsigned offset=0, result, StartOfLine, NBlocks, gr_len, ft;
  GROUP_HDR gr_hdr;
  
  DBMemoType = WorkArea[Selected]->Handle.HasMemo;
  mfile = WorkArea[Selected]->MemoArea->Memofile;
  
  if (!WrapWidth)
    WrapWidth = 0xFFFF;
  BlocksReadFromFile = 0;    //  keep track of invalid block count
  memset(Dest, 0, MaxChars); //  initialize the target buffer
  
  if (!StartingMemoBlock)
    return TRUE;
  gr_len = sizeof(GROUP_HDR);
  --MaxChars;
  address = Bsize * StartingMemoBlock; // calculate offset in file of first block of this memo
  
  sum = lseek(fileno(mfile),0L,SEEK_END);
  if ((address < 0L) || (address > sum)) {
    sprintf(s, "%ld", RecNo());
    SetError(1003, 4, DBT(), Record_number, s, fname);
    return FALSE;
  }
  fseek(mfile, address, SEEK_SET);
  
  if (DBMemoType == DB4WithDB4Memo)
    if (fread(&gr_hdr,1,gr_len,mfile) != gr_len) {
      DBFError = 30;
      goto bailout;
    }
  errno = 0; // clear error
  // read blocks of bsize, parse, and transfer to client buffer
  NBlocks = 0;
  EndOfMemo = FALSE;
  StartOfLine = 0;
  if ((GetBuf = (char *)malloc(Bsize+1)) == NULL) {
    DBFError = 217;
    goto bailout;
  }
  memset(GetBuf,0,Bsize+1);
  Memo_IV = (gr_hdr.flag == -1) ? 1 : 0;
  sum = Memo_IV ? gr_hdr.group_length - gr_len : -1;
  ft = Memo_IV ? gr_len : 0;
  fseek(mfile,address+ft,SEEK_SET);
  
  do {
    ++NBlocks;
    result = fread(GetBuf, 1, Bsize-ft, mfile);
    if (WorkArea[Selected]->Handle.DecryptProc)
      WorkArea[Selected]->Handle.DecryptProc(GetBuf,Bsize-ft);
    ft = 0;
    if (result > 0) {
      offset = StartOfLine = 0;
      do {
        // Cr/Lf, soft cr, end of memo, last char of block
        // time to wrap
        if (GetBuf[offset] == '\r') {
          Dest[i++] = '\r';
          Dest[i++] = '\n';
          offset += 2;
          StartOfLine = offset;
        }
        if(GetBuf[offset] == '\x8D') {
          offset += 2;
          StartOfLine = offset;
        }
        if (Memo_IV)
          if ((long)offset + Bsize * (NBlocks-1) - gr_len >= sum) {
            EndOfMemo = TRUE;                  
            offset = result;
          }
        if ((GetBuf[offset] == '\x1A') || (offset == MaxChars)) {
          EndOfMemo = TRUE;
          offset = result;
        }
        if ((offset - StartOfLine) == WrapWidth) {
          while ((GetBuf[offset] != ' ') && (offset > StartOfLine)) {
            --offset;
            --Dest;
          }
          Dest[i++] = '\r';
          Dest[i++] = '\n';
          while (GetBuf[offset] == ' ')
            ++offset;
          StartOfLine = offset;
        }
        if(offset != result)
          Dest[i++] = GetBuf[offset++];
      }  while ( offset < result );
    } // result > 0
    else
      EndOfMemo = TRUE;
  } while (!EndOfMemo);
  DBFError = errno;
  FreePtrClear((void*)&GetBuf);
  if (DBFError)
    goto bailout;
  BlocksReadFromFile = NBlocks; // to keep track of invalid block count
  
  return TRUE;
  
bailout:
  SetError(DBFError, 1, fname);
  return FALSE;
}
#endif
