/* filename: REFORMAT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <memo.h>
  
void MakeDynString(char *, int );
void ForgetDynString(int );
  
static unsigned char Column, RMargin;
static int currentL;
  
unsigned len(int WhichLine)
{
  if (((unsigned int)WhichLine <= MaxLines) && (Linebuffer[WhichLine] != NULL))
    return strlen(Linebuffer[WhichLine]);
  else
    return 0;
}
  
void TrimCurrentLine(void)
{
  char s[STRSIZ] = "";
  unsigned char OriginalLength;
  
  strcpy(s, Linebuffer[currentL-1]);
  OriginalLength = strlen(s);
  strcpy(s,Trim(s));
  if (strlen(s) < OriginalLength) {
    ForgetDynString(currentL-1);
    MakeDynString(s,currentL-1);
  }
}
  
void InsertALine(void)
{
  if ((Highestline < (long)MaxLines)  && ((unsigned)currentL < MaxLines)) {
    memmove(&Linebuffer[currentL],&Linebuffer[currentL-1],(Highestline - currentL + 1) * 4);
    Linebuffer[currentL] = NULL;
    MakeDynString("",currentL);
    ++Highestline;
  }
}
  
void DivideLine(int Blank)
{
  char s[STRSIZ] = "", l[STRSIZ] = "";
  
  if ((unsigned)currentL < MaxLines) {
    strcpy(s,Linebuffer[currentL-1]+Column);
    strncpy(l, Linebuffer[currentL-1], Blank ? Column : Column + 1);
    strcpy(s,Ltrim(Trim(s)));
    strcpy(l,Ltrim(Trim(l)));
    ForgetDynString(currentL-1);
    MakeDynString(l,currentL-1);
    InsertALine();
    ForgetDynString(currentL);
    MakeDynString(s,currentL);
  }
}
  
void JoinNextLine(void)
{
  unsigned len1, len2;
  char line1[STRSIZ] = "", line2[STRSIZ] = "";
  char tmp[STRSIZ] = "", tmp2[STRSIZ] = "";
  unsigned char CharsToMove;
  unsigned char SpaceAvailable;
  int NothingToDo;
  
  if ((currentL == Highestline) || ((unsigned)(currentL + 2) > MaxLines))
    return;
  
  NothingToDo = FALSE;
  do {
    memset(line1,0,STRSIZ);
    memset(line2,0,STRSIZ);
    memset(tmp2,0,STRSIZ);
    memset(tmp,0,STRSIZ);
    strcpy(line1,Trim(Linebuffer[currentL-1]));
    strcpy(line2,Ltrim(Trim(Linebuffer[currentL])));
    len1 = strlen(line1);
    len2 = strlen(line2);
    if ((len1 > 0) && ( len1 < RMargin )
    && (currentL < Highestline) && (len2 > 0)) {
      // calc chars to move
      SpaceAvailable = RMargin - len1 - 1;
      if (len2 <= SpaceAvailable) // next line is short
        CharsToMove = len2;
      else { // next line is longer than the room we have on line 1
        CharsToMove = SpaceAvailable + 1;
        while ((CharsToMove > 0) && (line2[CharsToMove-1] != ' '))
          --CharsToMove;
        if (CharsToMove > 0)
          --CharsToMove;
      }
      if (CharsToMove > 0) {
        strncat(tmp2,line2,(unsigned)CharsToMove);
        sprintf(tmp,"%s %s",line1, tmp2);
        strcpy(tmp2,line2+CharsToMove+1);
        strcpy(line2,tmp2);
        if (!strlen(line2)) {
          ForgetDynString(currentL);
          // move lines below, up
          memmove(&Linebuffer[currentL],&Linebuffer[currentL + 1],(Highestline - currentL + 2) * 4);
  
          if (Highestline < (long)MaxLines)
            ForgetDynString(Highestline);
          else
            Linebuffer[MaxLines] = NULL;
          --Highestline;
        }
        else {
          ForgetDynString(currentL);
          MakeDynString(line2,currentL);
          NothingToDo = TRUE;
        }
        ForgetDynString(currentL-1);
        MakeDynString(tmp,currentL-1);
      }
      else
        NothingToDo = TRUE;
    }
    else
      NothingToDo = TRUE;
  }  while (!(NothingToDo));
}
  
void Reformat(unsigned char LMargin, unsigned char RRMargin)
{
  int c;
  char temp[STRSIZ]="";
  
  RMargin = RRMargin - LMargin;
  Column = 1;
  currentL = 1;
  
  // Continue until end of text
  while ((currentL < Highestline)) {
    TrimCurrentLine();
    JoinNextLine();
    // Break line to stay within margin
    if (len(currentL-1) > RMargin) {
      c = len(currentL-1);
      if (c > (int)RMargin)
        c = RMargin + 1;
      while (c > (int)RMargin) {
        // Move left to previous blank
        while ((c > 1) && (Linebuffer[currentL-1][c] != ' '))
          --c;
        // Move left to previous non-blank
        while ((c > 1) && (Linebuffer[currentL-1][c] == ' '))
          --c;
      }
      // Right to blank
      ++c;
      // Right to next non-blank
      while (((unsigned)c < len(currentL-1)) && (Linebuffer[currentL-1][c] == ' '))
        ++c;
      --c;
      // Line is only one word and longer than the margin
      if (c <= 1) {
        Column = RMargin;
        DivideLine(FALSE);
      }
      else {
        Column = c;
        DivideLine(TRUE);
      }
      Column = strlen(Linebuffer[currentL-1]);
    }
    // Get the nextline
    if ((currentL < Highestline) && (Linebuffer[currentL] != NULL)) {
      ++currentL;
      Column = len(currentL-1);
    }
    else
      return;
  }
  if (LMargin > 0) {
    for (c = 0; c < Highestline; c++) {
      memset(temp,0,STRSIZ);
      sprintf(temp,"%s%s", Space(LMargin), Linebuffer[c]);
      ForgetDynString(c);
      MakeDynString(temp,c);
    }
  }
}
