/* filename: PACKMFIL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <io.h>
#include <malloc.h>
#ifdef _MSC_VER
 #include <direct.h>
#else
 #include <dir.h>
#endif
#include <string.h>
#include <ctype.h>
#include <memo.h>

long AppendMemo(long);
void SetPeekCacheTo(unsigned);

FILE *Newmemo = NULL;

static char _tzfar PMFname[] = {" [PackMemoFile]"};

static void CreateNewMemoFile(char *newname, char *name) // just used for packing memo file
{
  MEMO4_HDR memo_header;
  int fhandle;

  if (DBMemoType == DB4WithDB4Memo) {
    memset(&memo_header,0,sizeof(MEMO4_HDR));
    strcpy(memo_header.filename,name);
    errno = 0;
  }
#ifdef NET
  if ((Newmemo = _fsopen(newname, "wb", NonSharableReadWrite)) == NULL)
#else
  if ((Newmemo = fopen(newname, "wb")) == NULL)
#endif
    {
      SetError(errno, 3, Failure_to_open, newname, PMFname);
      return;
    }
  fhandle = fileno(Newmemo);
  errno = 0;
  if (DBMemoType == DB4WithDB4Memo) {
    memo_header.next_free_block = 1;
    memo_header.version = 0x102;
    memo_header.block_size = Bsize;
    write(fhandle,&memo_header,sizeof(MEMO4_HDR));
  }
  lseek(fhandle,(long)Bsize,SEEK_SET);
}

long filesize(FILE *stream)
{
  long curpos, length;

  curpos = ftell(stream);
  fseek(stream, 0L, SEEK_END);
  length = ftell(stream);
  fseek(stream, curpos, SEEK_SET);
  return length;
}

static void CloseNewMemoFile(void) // just used for packing memo file
{
  long NewSize;

  if(DBMemoType == DB4WithDB3Memo) {
    if(fwrite(&EOFZ, 1, sizeof(EOFZ), Newmemo) != sizeof(EOFZ))
      goto err;
  }
  NewSize = filesize(Newmemo);
  NewSize = (NewSize % Bsize) ? NewSize/Bsize+1 : NewSize/Bsize;
  fseek(Newmemo, 0L, SEEK_SET);
  if (fwrite(&NewSize, 1, sizeof(NewSize), Newmemo) != sizeof(NewSize))
    goto err;
  if (fclose(Newmemo) == EOF)
    goto err;
  return;
err:
  SetError(errno, 2, DBT(), PMFname);
}

void CloseMemoFile(void)
{
  MemoAreaType *ma = WorkArea[Selected]->MemoArea;

  if (ma) {
    if(fclose(ma->Memofile) == EOF) {
      SetError(errno, 2, ma->Memofilename, " [Use/CloseDatabases]");
      return;
    }
    free(ma);
    WorkArea[Selected]->MemoArea = NULL;
  }
}

void OpenMemoFile(char *MemoFileName)
{
  unsigned int SaveFileMode;
  char Memoname[STRSIZ];
  WorkAreaType *wa;
  int err = 0;

  wa = WorkArea[Selected];

  strcpy(Memoname, ReplaceExt(MemoFileName, "DBT"));
  if (wa->MemoArea) { // already open
    err = 1007;
    goto bailout;
  }
  if ((wa->MemoArea = (MemoAreaType *)malloc(sizeof(MemoAreaType))) == NULL) {
    err = 217;
    goto bailout;
  }
  strcpy(wa->MemoArea->Memofilename, Memoname);
  SaveFileMode = FileMode;
  FileMode = SH_DENYRW; //non-sharable
#ifdef NET
  if (MultiUser && !wa->Exclusive)
    FileMode = SH_DENYNO; // sharable
#endif
  errno = 0;
  wa->MemoArea->Memofile = _fsopen(Memoname, "rb+", FileMode);
  FileMode = SaveFileMode;
  if (errno) {
    free(wa->MemoArea);
    wa->MemoArea = NULL;
    err = errno;
  }
bailout:
  if (err)
    SetError(err, 2, Memoname, " [Use/Pack]");
}

void PackMemoFile(void)
// support routines now nested so that the temp file-var and the buffer
// can be on the stack
{
  int field_index[MaxFieldCount+1]; // maximum 255 fileds in the record...
  int j, fieldcount, field_no = 0;
  long i, reccount;
  long MemoField;           // used to hold value from memo field
  char FieldValue[11];      // used with peek and poke
  char packname[_MAX_PATH]; // name of temp file
  char mname[_MAX_PATH];
  char drive[_MAX_DRIVE];
  char dir[_MAX_DIR];
  char name[_MAX_FNAME];
  char ext[_MAX_EXT];
  struct diskfree_t free;
  long avail;
  WorkAreaType *wa;
  MemoAreaType *ma;
  dbfRecord R;

  wa = WorkArea[Selected];
  ma = wa->MemoArea;
  DBMemoType = WorkArea[Selected]->Handle.HasMemo;
  memset(field_index, 0, sizeof(field_index));

  if (NoMemoInUse((char *) PMFname))
    return;
  *drive = (char)(toupper(ma->Memofilename[0]) - 64);

  _dos_getdiskfree(*drive, &free);
  avail = (long) free.avail_clusters * (long) free.bytes_per_sector
  * (long) free.sectors_per_cluster;

  if (avail < filesize(ma->Memofile)) {
    SetError(1012, 2, DBF(), PMFname);
    return;
  }
#ifdef NET
  if (!wa->Exclusive) {
    SetError(ExclusiveUseRequired, 1, PMFname);
    return;
  }
#endif
  strcpy(packname, ma->Memofilename);
  fnsplit(packname,drive,dir,name,ext); // strip off extension

  sprintf(packname,"%s%s%s.$$$",drive,dir,name); // add our temporary extension
  CreateNewMemoFile(packname,name);
  fieldcount = FieldCount();
  for (j = 1; j <= fieldcount; j++) { // look at all the memo fields in the record
    if (FieldType(j) == 'M')
      field_index[field_no++] = j; // register the MEMO field number
  }
  R = wa->Handle;
  if (!R.DecryptProc)
    SetPeekCacheTo(16000U); // try to get memory for PeekBuffer
  reccount = RecCount();

  for (i = 1; i <= reccount; i++) { // look at every record in database
    for (j = 0; field_index[j] != 0; j++) { // scan all MEMO fields
      // get the value in the memo field and use it to copy that memo to the new file
      if (R.DecryptProc) {
        GetDbfRecord(&R,i);
        memcpy(FieldValue, R.CurRecord+R.Fields[field_index[j]-1].Off,10);
      }
      else
        strcpy(FieldValue, Peek(field_index[j], (long)i));
      MemoField = atol(FieldValue);
      if (MemoField > 0) {
        MemoField = AppendMemo(MemoField);
        ltoa(MemoField, FieldValue, 10);
        strcpy(FieldValue, LPad(FieldValue, 10));
        if (R.DecryptProc) {
          memcpy(R.CurRecord+R.Fields[field_index[j]-1].Off,FieldValue,10);
          PutDbfRecord(&R,i);
        }
        else
          Poke(FieldValue, field_index[j], (long)i);
      }
    }
  }
  if (!R.DecryptProc)
    SetPeekCacheTo(0); // will free memory, allocated for PeekBuffer
  CloseNewMemoFile();
  if (!errno) {
    strcpy(mname, ma->Memofilename);
    CloseMemoFile();
    remove(mname);
    rename(packname,mname);
    mname[strlen(mname) - 4] = 0;
    OpenMemoFile(mname);
    // GoTop;
    // there are reasons NOT to do this. Besides, since Peek and Poke are the
    // only routines used, let's just leave the dbf positioned to whereever it was
  }
}
