/* filename: OPENMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <memo.h>

long GroupMemoLength = 0L;

int MemoOpen(MemoFile *);
int MemoInOut(MemoFile *);
int MemoFlush(MemoFile *);
int MemoClose(MemoFile *);

MemoFile *OpenMemo(long *MemoPtr, char *Mode)
{
  MemoFile *mf;
  GROUP_HDR gr_hdr;
  int fhandle;

  if(NoMemoInUse("OpenMemo"))
    return NULL;

  if ((*Mode == 'r') && !*MemoPtr)
    return NULL;

  DBMemoType = WorkArea[Selected]->Handle.HasMemo;

  if((mf = (MemoFile *)malloc(sizeof(MemoFile))) == NULL)
    return NULL;

  switch(*Mode) {
    case 'r' :
      if(DBMemoType == DB4WithDB4Memo) {
        fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
        lseek (fhandle, *MemoPtr*Bsize, SEEK_SET);
        read (fhandle, &gr_hdr, sizeof(GROUP_HDR));
        GroupMemoLength = gr_hdr.group_length;
      }
      mf->mode = _fmInput;
      break;
    case 'w' :
      if(DBMemoType == DB4WithDB3Memo)
        *MemoPtr = 0; // "clear" the memo file, just to mimic the behavior
      mf->mode = _fmOutput;
      break;
    case 'a' :
      mf->mode = _fmInOut;
      break;
    default :
      free(mf);
      return NULL; // ERROR - bad Mode
  }
  mf->Handle = 0xFFFF;
  mf->BufSize = 0;
  mf->BufPtr = NULL;
  mf->OpenFunc  = MemoOpen;
  mf->InOutFunc = MemoInOut;
  mf->FlushFunc = MemoFlush;
  mf->CloseFunc = MemoClose;
  mf->MemoPtr = MemoPtr;
  mf->Selected = Selected;
  mf->Name[0] = 0;

  if(MemoOpen(mf) != 0) {
    free(mf);
    return NULL;
  }
  return mf;
}
