/* filename: NEWMBYOF.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <errno.h>
#include <memo.h>

char *DBT(void);
int LockMemoFile(void);
long filesize(FILE *stream);

long NewMemoByteOffset(char *funcname)
{
  int fhandle;
  char getbuf[Bsize];
  long address, FillSize;

  errno = 0;
  memset(getbuf, 0, sizeof(getbuf));

#ifdef NET
  if (MultiUser)
    if (!LockMemoFile()) {
      SetError(1017, 2, DBT(), funcname);
      return 0L;
    }
#endif

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  address = filesize(WorkArea[Selected]->MemoArea->Memofile);

  if (address == BsizePlusOne /*513*/) // handle the exception first
  { // memo file only had a header..no data yet
    lseek(fhandle,Bsize,SEEK_SET); // start writing at 513th byte
    return BsizePlusOne;
  }
  FillSize = Bsize - (address % Bsize);

  if (FillSize != Bsize) { // pad the file to a 512 boundary
    lseek(fhandle,address,SEEK_SET); // seek past end of file
    if(write(fhandle,getbuf,(unsigned)FillSize) == (int)FillSize)
      address += FillSize;
  }
  else
    lseek(fhandle,address,SEEK_SET);

  if (errno) {
    SetError(errno, 2, DBT(), funcname);
    return 0L;
  }
  return address;
}
