/* filename: GETMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#include <malloc.h>
#include <string.h>
#include <errno.h>
#include <memo.h>

void ClearLineBuffers(int);
void MakeDynString(char *, int);
void ForgetDynString(int);
int  NoMem(void);
long filesize(FILE *stream);

char *MemoLineTails;
long BlocksReadFromFile;
unsigned char MemoX1 = 0, MemoX2 = 0, MemoY1 = 0, MemoY2 = 0;

static int currentline, Head;
static int  fhandle, Memo_IV, WrapWidth, curbl;
static long MemoLength, mark;
static const char *callerName;

extern unsigned char WordWrapWidth;

static void AddLineToEditBuffer(char *Line)
{
  char buf[2*Bsize];

  if (Linebuffer[currentline]) {
    sprintf(buf,"%s%s",Linebuffer[currentline],Line);
    ForgetDynString(currentline);
    Head = 0;
  }
  else
    strcpy(buf,Line);
  if ((unsigned)currentline < MaxLines) {
    MakeDynString(buf,currentline);
    if (NoMem())
      SetError(InsufficientMemory, 2, DBT(), callerName);
    else {
      if (!Head) {
        ++currentline;
        ++Highestline;
      }
    }
  }
}

static unsigned PutInLinebuffer(char *s)
{
  int startofline = 0, offset;
  char Temp[STRSIZ];
  unsigned len = strlen(s);

  if(len >= (unsigned)WrapWidth+1) {
    memset(Temp,0,sizeof(Temp));
    offset = WrapWidth;
    for(; (unsigned)offset <= len; ) {
      if(s[offset-1] != ' ' && s[offset-1] != '\x0')
        if(strchr(s+offset,' '))
          for(;s[offset-1] != ' ';--offset);
      strncpy(Temp,&s[startofline],offset-startofline-Head);
      AddLineToEditBuffer(Temp);
      memset(Temp,0,sizeof(Temp));
      startofline = offset;
      offset += WrapWidth+1;
    }
    strncpy(Temp,&s[startofline],offset-startofline);
    len = strlen(Temp);
    if (*Trim(Temp))
      return len;
  }
  else
    AddLineToEditBuffer(s);
  return 0;
}

static void putsomelines(char *s)
{
  char *p, *pr, *pi, *current, Line[Bsize];

  pr = pi = current = s;
  memset(Line,0,Bsize);

  do {
    pr = strchr(current,'\r');
    pi = strchr(current,'\x8D');
    if (!pi && !pr && current && curbl != BlocksReadFromFile) {
      // Head - line tail of the memo block, which didn't contain '\r',
      // and hence, this tail will be cat to the beginning of the memo next block
      Head = strlen(current);
      PutInLinebuffer(current);
      return;
    }
    if(!pr)
      p = pi;
    if(!pi)
      p = pr;
    if(pi && pr)
      p = (pr > pi) ? pi : pr;
    if( (Highestline == 1) && !p) {
      PutInLinebuffer(s);
      current = p;
    }
    if(p) {
      if((int)(p-current+Head) >= WrapWidth+1) {
        if(memchr(current, ' ',(unsigned)(p-current)))
          while(((int)(p-current+Head) >= WrapWidth+1)  || (*p != ' '))
            p--;
        else
          while((int)(p-current+Head) >= WrapWidth+1)
            p--;
        memcpy(Line,current,(unsigned)(p-current));
        p -= PutInLinebuffer(Line);
        current = p;
      }
      else {
        memcpy(Line,current,(unsigned)(p-current));
        PutInLinebuffer(Line);
        MemoLineTails[currentline-1] = *p;
        current = p+2;
      }
    }
    memset(Line,0,STRSIZ);
  } while (p);
  if (current)
    PutInLinebuffer(current);
}

static void GetMemoIIILength(long offset)
{
  char mem[Bsize+1], *ptr;
  dbfRecord d;

  d = WorkArea[Selected]->Handle;

  lseek(fhandle,offset,SEEK_SET);
  memset(mem,0,Bsize+1);
  read(fhandle,mem,Bsize);
  if (d.DecryptProc)
    d.DecryptProc(mem,Bsize);
  if(errno) {
    DBFError = 30;
    goto err;
  }
  while(!memchr(mem,'\x1A',Bsize)) {
    MemoLength += strlen(mem);
    memset(mem,0,Bsize+1);
    read(fhandle,mem,Bsize);
    if (d.DecryptProc)
      d.DecryptProc(mem,Bsize);
    if(errno) {
      DBFError = 30;
      goto err;
    }
  }
  ptr = memchr(mem,'\x1A',Bsize);
  *ptr = 0;
  MemoLength += strlen(mem);
  return;
err:
  SetError(DBFError, 1, callerName);
}

static void readbuf(long offset)
{
  char getbuf[Bsize+1], buf[Bsize+1], *ptr;
  int BlockSize;
  dbfRecord d;

  d = WorkArea[Selected]->Handle;

  memset(getbuf,0,Bsize+1);
  memset(buf,0,Bsize+1);
  BlockSize = Bsize;
  if (curbl == 1) {
    offset += Memo_IV ? sizeof(GROUP_HDR) : 0;
    if (Memo_IV)
      BlockSize = Bsize - sizeof(GROUP_HDR);
  }
  lseek(fhandle,offset,SEEK_SET);
  errno = 0;
  read(fhandle,getbuf,BlockSize);
  if (d.DecryptProc)
    d.DecryptProc(getbuf,BlockSize);
  if((ptr = memchr(getbuf,'\x1A',BlockSize)) != NULL)
    *ptr = 0;
  if(errno) {
    SetError(30, 1, callerName);
    return;
  }
  putsomelines(getbuf);
}

static void GetMemo_III(long address)
{
  Memo_IV = FALSE;
  BlocksReadFromFile = curbl = 0;
  GetMemoIIILength(address);
  BlocksReadFromFile = MemoLength % Bsize ? MemoLength / Bsize + 1 : MemoLength / Bsize; // keep track of invalid block count
  while(curbl < BlocksReadFromFile)
    readbuf(address+curbl++*Bsize);
}

BOOL GetMemo(long address, const char *callername)
{
  GROUP_HDR gr_hdr;

  callerName = callername;
  ClearLineBuffers(FALSE); // flush any existing memo data from memory
  currentline = 0; // start at line one of the array of lines
  MemoLength = mark = Head = 0;
  Memo_IV = TRUE;

#ifndef WINDOWS
  WrapWidth = Wrap ? MemoX2 - MemoX1 - 1 : STRSIZ-1;
#else
  WrapWidth = STRSIZ-1;
#endif

  errno = 0;
  if((MemoLineTails = (char *)malloc((unsigned)(MaxLines+1))) == NULL) {
    DBFError = 217;
    goto DONE;
  }
  memset(MemoLineTails,0,MaxLines+1);
  DBMemoType = WorkArea[Selected]->Handle.HasMemo;
  if (!address) // just initialize the text buffer
    return TRUE;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  address *= Bsize; // calculate offset in file of first block of this memo

  if ((address < 0) || (address > filesize(WorkArea[Selected]->MemoArea->Memofile)))
  {
    SetError(1003, 5, DBT(), Record_number, " ", SInteger(RecNo(),0), callerName);
    return FALSE;
  }
  Txtin = TRUE;
  // begin reading blocks of bsize,converting to strings
  if(DBMemoType == DB4WithDB3Memo)
    GetMemo_III(address);
  else {
    lseek(fhandle,address,SEEK_SET);
    memset(&gr_hdr,0,sizeof(GROUP_HDR));
    if(read(fhandle,&gr_hdr,sizeof(GROUP_HDR)) != sizeof(GROUP_HDR)) {
      DBFError = 30;
      goto DONE;
    }
    if(gr_hdr.flag != -1) {
      GetMemo_III(address);
      goto DONE;
    }
    MemoLength = gr_hdr.group_length - sizeof(GROUP_HDR);
    BlocksReadFromFile = gr_hdr.group_length % Bsize ? gr_hdr.group_length / Bsize + 1 : gr_hdr.group_length / Bsize;
    curbl = 0;
    while (curbl < BlocksReadFromFile)
      readbuf(address+curbl++*Bsize);
  }
DONE:
  if (DBFError) {
    FreePtrClear((void*)&MemoLineTails);
    SetError(DBFError, 2, DBT(), callerName);
    return FALSE;
  }
  if (Highestline > 1)
    --Highestline;
  return TRUE;
}
