/* filename: DBT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <memo.h>

void MainHeader(long, int);

char *DBT(void) // returns the memo filename
{
  return ( ReplaceExt(DBF(),"DBT") );
}

static int CheckDB3Memo(long size, long *MemoBlock)
{
  char buf[Bsize];
  int offset = 0, fhandle, sign = 0;
  dbfRecord d;

  d = WorkArea[Selected]->Handle;
  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);

  lseek (fhandle, *MemoBlock*Bsize, SEEK_SET);
  while(sign != -1) {
    read(fhandle,buf,Bsize);
    if (d.DecryptProc)
      d.DecryptProc(buf,Bsize);
    if(strchr(buf,'\x1A'))
      sign = -1;
    offset++;
  }
  if(offset*Bsize < size)
    return FALSE;
  return TRUE;
}

void add_to_chain(long blockno, long size)
{
  int fhandle, out = FALSE;
  long current=0L, next=1L, total;
  MEMO4_HDR memo_hdr;
  DELGROUP_HDR del_hdr;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);

  total = lseek(fhandle,0L,SEEK_END);
  total /= Bsize;
  if(!total)
    total = 1;
  lseek(fhandle,0L,SEEK_SET);
  if(read(fhandle,&memo_hdr,sizeof(MEMO4_HDR)) != sizeof(MEMO4_HDR)) {
    DBFError = 30;
    goto err;
  }
  next = memo_hdr.next_free_block;
  if(next != total) {
    if( blockno > next ) {
      do {
        lseek(fhandle,next*Bsize,SEEK_SET);
        if(read(fhandle,&del_hdr,sizeof(DELGROUP_HDR)) != sizeof(DELGROUP_HDR)) {
          DBFError = 30;
          goto err;
        }
        current = next;
        next = del_hdr.next_free_block;
        if( blockno < next ) {
          lseek(fhandle,current*Bsize,SEEK_SET);
          if(write(fhandle,&blockno,sizeof(long)) != sizeof(long)) {
            DBFError = 29;
            goto err;
          }
          lseek(fhandle,blockno*Bsize,SEEK_SET);
          del_hdr.next_free_block = next;
          del_hdr.size_in_blocks = size/Bsize+1;
          if(write(fhandle,&del_hdr,sizeof(DELGROUP_HDR)) != sizeof(DELGROUP_HDR)) {
            DBFError = 29;
            goto err;
          }
          out = TRUE;
        }
      } while (!out);
    }
    else {
      MainHeader(blockno,1);
      lseek(fhandle,blockno*Bsize,SEEK_SET);
      del_hdr.next_free_block = next;
      del_hdr.size_in_blocks = size/Bsize + 1;
      if(write(fhandle,&del_hdr,sizeof(DELGROUP_HDR)) != sizeof(DELGROUP_HDR)) {
        DBFError = 29;
        goto err;
      }
    }
  }
  DBFError = 0;
err:
  if(DBFError) {
    SetError(DBFError, 2, DBT(), " [EditMemo/CloseMemo]");
    return;
  }
}

long search_block(long size, long MemoBlock, char *funcname)
{
  long total, next, current = 0L, prev;
  int fhandle, out = FALSE;
  MEMO4_HDR memo_hdr;
  GROUP_HDR gr_hdr;
  DELGROUP_HDR del_hdr;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);

  total = lseek(fhandle,0L,SEEK_END);
  total = total/Bsize;
  if (!total)
    total = 1;
  if (MemoBlock) {
    lseek(fhandle,MemoBlock*Bsize,SEEK_SET);
    if (read(fhandle,&gr_hdr,sizeof(GROUP_HDR)) != sizeof(GROUP_HDR)) {
      DBFError = 30;
      goto err;
    }
    if (gr_hdr.flag != -1)
      if(CheckDB3Memo(size,&MemoBlock))
        return MemoBlock;
    if (gr_hdr.group_length-sizeof(GROUP_HDR)/Bsize+1 >= size)
      return MemoBlock;
  }
  lseek(fhandle,0L,SEEK_SET);
  if(read(fhandle,&memo_hdr,sizeof(MEMO4_HDR)) != sizeof(MEMO4_HDR)) {
    DBFError = 30;
    goto err;
  }
  next = memo_hdr.next_free_block;
  if(total <= next) {
    MainHeader(next+size,1);
    return next;
  }
  else
    do {
      lseek(fhandle,next*Bsize,SEEK_SET);
      if(read(fhandle,&del_hdr,sizeof(DELGROUP_HDR)) != sizeof(DELGROUP_HDR)) {
        DBFError = 30;
        goto err;
      }
      prev = current;
      current = next;
      next = del_hdr.next_free_block;
      if( size <= del_hdr.size_in_blocks )
        out = TRUE;
      if( (next == total) && out ) {
        lseek(fhandle,prev*Bsize,SEEK_SET);
        if(write(fhandle,&next,sizeof(long)) != sizeof(long)) {
          DBFError = 29;
          goto err;
        }
        return current;
      }
      if( (next == total) && !out ) {
        size += next;
        lseek(fhandle,prev*Bsize,SEEK_SET);
        if(write(fhandle,&size,sizeof(long)) != sizeof(long)) {
          DBFError = 29;
          goto err;
        }
        return next;
      }
    } while (!out);

  lseek(fhandle,current*Bsize,SEEK_SET);
  if(read(fhandle,&del_hdr,sizeof(DELGROUP_HDR)) != sizeof(DELGROUP_HDR)) {
    DBFError = 30;
    goto err;
  }
  lseek(fhandle,prev*Bsize,SEEK_SET);
  if(write(fhandle,&del_hdr.next_free_block,sizeof(long)) != sizeof(long)) {
    DBFError = 29;
    goto err;
  }
  return current;
err:
  SetError(DBFError, 2, DBT(), funcname);
  return 1;
}
