/* filename: CRMEMFIL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <memo.h>

char *DBT(void);
static char _tzfar fname[] = {" [CreateMemoFile]"};

void CreateMemoFile(char *memofilename)
{
  FILE *mf;
  MEMO4_HDR memo_header;
  char CreateBuffer[BsizePlusOne];
  DirStr dir;
  NameStr name;
  ExtStr ext;

  DBMemoType = WorkArea[Selected]->Handle.HasMemo;
  errno = 0;
  FSplit(memofilename,dir,name,ext);
  strcpy(memofilename,ReplaceExt(memofilename,"DBT"));
  if(DBMemoType == DB4WithDB4Memo) {
    memset(&memo_header,0,sizeof(MEMO4_HDR));
    strcpy(memo_header.filename,name);
  }
#ifdef NET
  if((mf = _fsopen(memofilename, "wb", NonSharableReadWrite)) == NULL)
#else
  if((mf = fopen(memofilename, "wb")) == NULL)
#endif
    if (errno) {
      SetError(errno, 2, DBT(), fname);
      return;
    }
  if(DBMemoType == DB4WithDB3Memo) {
    memset(CreateBuffer, 0, BsizePlusOne);
    *CreateBuffer = '\x01'; // number of blocks in an empty memo file
    CreateBuffer[BsizePlusOne-1] = EOFZ;
    write(fileno(mf),CreateBuffer,BsizePlusOne);
  }
  else {
    memo_header.next_free_block = 1;
    memo_header.version = 0x102;
    memo_header.block_size = Bsize;
    write(fileno(mf),&memo_header,sizeof(MEMO4_HDR));
  }
  if (errno) {
    SetError(errno, 2, DBT(), fname);
    return;
  }
  fclose(mf);
  if (errno)
    SetError(errno, 2, DBT(), fname);
}
