/* filename: APPMEMO.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <io.h>
#include <malloc.h>
#include <string.h>
#include <errno.h>
#include <memo.h>

char *DBT(void);
long filesize(FILE *stream);

extern FILE *Newmemo;

int EndOfMemo;
static char *PackBuffer;
static char _tzfar fname[] = {" [PackMemoFile]"};
static int fhandle;
static long len_III;

static int CheckForEndofMemo(int BytesRead)
{
  int i;
  unsigned j;

  for (i = 0; i < BytesRead; i++)
    if (*(PackBuffer+i) == EOFZ) {
      EndOfMemo = TRUE;
      *(PackBuffer+i+1) = 0;
      j = strlen(PackBuffer);
      if (j < (unsigned)i)
        return j + 1;
      else
        return i + 1;
    }
  return i;
}

static void PadTo512Boundary(void)
{
  int BytesToPad, result;

  BytesToPad = Bsize - (unsigned)(filesize(Newmemo) % Bsize);
  if ((BytesToPad == Bsize) && filesize(Newmemo))
    return; // we are already on a boundary
  memset(PackBuffer, 32, BytesToPad);
  fseek(Newmemo,filesize(Newmemo),SEEK_SET);
  if (WorkArea[Selected]->Handle.EncryptProc)
    WorkArea[Selected]->Handle.EncryptProc(PackBuffer,BytesToPad);
  result = write(fileno(Newmemo),PackBuffer,BytesToPad);
  if (result != BytesToPad) {
    SetError(1005, 2, DBT(), fname); // writerror
    return;
  }
}

static void ReadWriteBlocks(long m_len, int fl)
{
  long len_IV = 0;
  int BytesRead, BlockLength, result;
  char s[8];
  dbfRecord d = WorkArea[Selected]->Handle;

  len_III = 0;
  EndOfMemo = FALSE;
  if(fl)
    write(fileno(Newmemo),s,sizeof(GROUP_HDR));
  while ((!EndOfMemo && !feof(Newmemo)) && (len_IV <= m_len)) {
    memset(PackBuffer, 0, sizeof(PackBuffer));
    BytesRead = read(fhandle,PackBuffer,Bsize);
    if (d.DecryptProc)
      d.DecryptProc(PackBuffer,Bsize);
    if (BytesRead > 0) {
      if(m_len) {
        BlockLength = Bsize;
        len_IV += Bsize;
      }
      else {
        BlockLength = CheckForEndofMemo(BytesRead);
        len_III += BlockLength;
      }
      if (d.EncryptProc && fl) {
        d.EncryptProc(PackBuffer,Bsize-sizeof(GROUP_HDR));
        result = write(fileno(Newmemo),PackBuffer,Bsize-sizeof(GROUP_HDR));
        fl = 0;
        if (result != Bsize-sizeof(GROUP_HDR)) {
          SetError(1005, 2, DBT(), fname); // write error
          return;
        }
      }
      else {
        if (d.EncryptProc)
          d.EncryptProc(PackBuffer,Bsize);
        result = write(fileno(Newmemo),PackBuffer,Bsize);
        if (result != Bsize) {
          SetError(1005, 2, DBT(), fname); // write error
          return;
        }
      }
    }
  }
  PadTo512Boundary();
}

long AppendMemo(long oldadd) // just used for packing memo file
{
  char s[11];
  long offset;
  GROUP_HDR gr_hdr;

  fhandle = fileno(WorkArea[Selected]->MemoArea->Memofile);
  errno = 0;
  if((PackBuffer = (char *)malloc(Bsize)) == NULL) {
    DBFError = 217;
    goto err;
  }
  PadTo512Boundary();

  offset = filesize(Newmemo) / Bsize;
  fseek(Newmemo,offset*Bsize,SEEK_SET);
  oldadd *= Bsize;
  if (oldadd < filesize(WorkArea[Selected]->MemoArea->Memofile))
    lseek(fhandle,(long)oldadd,SEEK_SET);
  else {
    sprintf(s,"0%d",RecNo());
    SetError(1003, 4, DBT(), Record_number, s, fname);
    return 0L;
  }
  if(DBMemoType == DB4WithDB3Memo)
    ReadWriteBlocks(0,0);
  else {
    if(read(fhandle,&gr_hdr,sizeof(GROUP_HDR)) != sizeof(GROUP_HDR)) {
      DBFError = 30;
      goto err;
    }
    if (gr_hdr.flag != -1) {
      lseek(fhandle,oldadd,SEEK_SET);
      ReadWriteBlocks(0,1);
      gr_hdr.flag = -1;
      gr_hdr.header_length = 8;
      gr_hdr.group_length = len_III + sizeof(GROUP_HDR) - 1;
      fseek(Newmemo,offset*Bsize,SEEK_SET);
      if(write(fileno(Newmemo),&gr_hdr,sizeof(GROUP_HDR)) != sizeof(GROUP_HDR)) {
        DBFError = 29;
        goto err;
      }
    }
    else {
      lseek(fhandle,oldadd,SEEK_SET);
      ReadWriteBlocks(gr_hdr.group_length,0);
    }
  }
  DBFError = 0;
err:
  FreePtrClear((void *)&PackBuffer);
  if(DBFError) {
    SetError(DBFError, 2, DBT(), fname);
    return 0L;
  }
  return offset;
}
