/* filename: SAVE2MEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>
#include <dbf.h>
#include <tzmem.h>

extern LinkType *MemPtr;

void SaveTo(const char *memFile)
{
  MemHeader Header;
  LinkType *TempPtr;
  double j;
  int  f;
  char CtrlZ = '\x1A';
  char *errmsg = write_;
  char  fname[80];

  if (!MemPtr)
    return;
  strcpy(fname, Trim(memFile));
  if (!*fname) {
    SetError(InvalidParameter, 1, No_filename_specified_SaveTo);
    return;
  }
  strcpy(fname, Upper(AddExt(fname, "MEM")));
  if (!ValidFilename(fname)) {
    SetError(InvalidParameter, 4, _not_a_valid_DOS_filename " [SaveTo(",fname,")]");
    return;
  }
  if ((f = open(fname, O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE)) == -1) {
    errmsg = open_;
    goto file_error;
  }
  else
  	errno = 0;// open() sets this flag if file does not exist
  TempPtr = MemPtr;
  while (TempPtr) {
    memset(&Header, 0, sizeof(Header));
    strcpy(Header.Name, TempPtr->Name);
    switch (TempPtr->Typ) {
      case 'C':
        Header.TypeID = 0x00C3;
        Header.Len = strlen(TempPtr->StrPtr) + 1;
        break;
      case 'D':
        Header.TypeID = 0x00C4;
        break;
      case 'I':
        Header.TypeID = 0x02C6;
        break;
      case 'L':
        Header.TypeID = 0x00CC;
        Header.Len = 1;
        break;
      case 'F':
        Header.TypeID = 0x00CE;
        break;
    }
    if (write(f, &Header, sizeof(Header)) != sizeof(Header))
      goto file_error;
    switch (TempPtr->Typ) {
      case 'C':
        write(f, TempPtr->StrPtr, Header.Len);
        break;
      case 'D':
        j = (double) JulianFromDate(TempPtr->Data);
        write(f, &j, sizeof(double));
        break;
      case 'I':
        write(f, TempPtr->Data, sizeof(int));
        break;
      case 'L':
        write(f, TempPtr->Data, sizeof(char));
        break;
      case 'F':
        write(f, TempPtr->Data, sizeof(double));
        break;
    }
    if (errno)
      goto file_error;
    TempPtr = TempPtr->NextPtr;
  } // over linked list loop
  if (write(f, &CtrlZ, 1) != 1) // write the ^Z char at the end of the file
    goto file_error;
  if (close(f)) {
    errmsg = close_;
    goto file_error;
  }
  return;

file_error:
  SetError(errno, 5, _attempting_to_, errmsg, " [SaveTo(", fname, ")]");
}
