/* filename: VALIDNDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#ifdef WINDOWS
#include <windows.h>
#else
#include <conio.h>
#include <dialog.h>
#endif
#include <common.h>
#include <dbf.h>

BOOL SilentValidMode = FALSE;

#define User_break_at_loop "User break at loop"
#define _of_ " of "
#define SpaceRecord   "  Record"
#define SpaceCurrent  " Current"
#define SpacePrevious "Previous"
#define SpaceNext     "    Next"
#define Current_key_is_ "Current key is "
#define smaller_ "smaller "
#define bigger_  "bigger "
#define than_next_one "than next one"
#define The_first_part_of_index_test_is_completed_succesfully "The first part of index test is completed succesfully."
#define Now_we_are_about_to_begin_checking_index_integrity "Now we are about to begin checking index integrity."
#define This_may_take_much_time_please_press_YES_to_confirm "This may take much time, please, press YES to confirm."
#define No_of_records_in_index  "No of records in index"
#define No_of_records_in_DBF    "No of records in DBF  "
#define failure_to_get_the_file_information "failure to get the file information"
#define Not_an_ordinary_file  "Not an ordinary file"
#define No_read_permission_on_file "No read permission on file"
#define No_write_permission_on_file "No write permission on file"
#define Wrong_index_file_size "Wrong index file size"
#define File_is_out_of_date  "File is out of date"
#define You_should_use_ValidIndexCB "You should use ValidIndexCB with this index file."
#define Corrupted_Index_Header "Corrupted index file header."
#define File_already_open "File is open, cannot check it, file should be closed"

#define MinTimeDiff_s 10
#define BIGGER  0
#define SMALLER 1

static  int  quit, klen, kiss, cycle, fromCB;
static  char *kbuf, *message;
static  long counter;
static  PUDK_func ptr;
static  PUDC_func cmp;

static int AdvanceAll(char * source)
{
#ifdef WINDOWS
  source[0] = source[0];
#else
  if (RotorEnabled)
    AdvanceRotor();
  if (Odometer)
    printf("\r%d(3):%6ld", cycle, counter);
  if (ProgressEnabled)
    AdvanceProgress();
  if (kbhit())
    if (getch() == 0x1B) {
      if (!SilentValidMode) {
        sprintf(message, "%s: %s %ld%s%ld\n", source, User_break_at_loop, counter, _of_, RecCount());
        DialogBox(message, PressAnyKey);
      }
      quit = TRUE;
      return 1;
    }
#endif
  return 0;
}

static char *Check(int param)
{
  char *p, *p1;
  int ret;

  p = (*ptr)();
  ret = (*cmp)(kbuf, p, klen);
  if ((param == BIGGER && ret < 0) || (param == SMALLER && ret > 0)) {
    if (!SilentValidMode) {
      if (param == BIGGER) p1 = bigger_;
      if (param == SMALLER) p1 = smaller_;
      sprintf(message, "\n%s%s%s\n",Current_key_is_,p1,than_next_one);
      sprintf(message+strlen(message),SpaceRecord" : %ld\n", RecNo());
      if (kiss) {
        sprintf(message+strlen(message),SpaceCurrent" : '%s'\n", p);
        sprintf(message+strlen(message),SpaceNext" : '%s'\n", kbuf);
      }
#ifdef WINDOWS
      WDialogBox(message, "ValidIndex", MB_OK | MB_ICONEXCLAMATION);
#else
      DialogBox(message, PressAnyKey);
#endif
    }
    return NULL;
  }
  return p;
}

static int FindAllThePrevious(void)
{ // using Skip() in this function
  char *p;

  counter = 0L;
  GoBottom();
  memcpy(kbuf, (*ptr)(), klen+1);
  while(!dBOF() && !DBFError) {
    counter++;
    if (AdvanceAll("[SkipBackward]")) return 0;
    if ((p = Check(BIGGER)) == NULL) return -1;
    memcpy(kbuf, p, klen+1);
    Skip(-1);
  }
  return (DBFError) ? (-1) : 0;
}

static int FindAllTheNext(void)
{ // using RawGo() in this function
  char *p;

  counter = 0L;
  GoTop();
  memcpy(kbuf, (*ptr)(), klen+1);
  _Find(kbuf);
  while(!Ind[Selected][0]->EOFFlag && !DBFError) {
    counter++;
    if (AdvanceAll("[SkipForward]")) return 0;
    if ((p = Check(SMALLER)) == NULL) return -1;
    memcpy(kbuf, p, klen+1);
    RawGo(FindNextRecFunc());
  }
  return (DBFError) ? (-1) : 0;
}

static int CountRecords(void)
{
  counter = 0L;
  GoTop();
  while(!Ind[Selected][0]->EOFFlag && !DBFError) {
    if (AdvanceAll("[CountNodes]")) break;
    counter++;
    FindNextRecFunc();
  }
  return (DBFError) ? (-1) : 0;
}

BOOL ThoroughIndexTest(unsigned char order)
{
  int ret = -1, unique;
  unsigned char saveOrder;
  PIndexType p;
#ifdef NET
  int locked = 0;
#endif

  quit = FALSE;
  DBFError = 0;
  saveOrder = CurrentOrder();
  SetOrderTo(order);
  p = Ind[Selected][0];
  ptr = p->KeyMaker;
  cmp = p->cmp;
  klen = p->header.key_len;
  kiss = p->kiss;

  if (ptr == 0 || DBFError)   goto bailout;

#ifdef WINDOWS
  if (!SilentValidMode) {
    sprintf(message, "%s %s %s",
      The_first_part_of_index_test_is_completed_succesfully,
      Now_we_are_about_to_begin_checking_index_integrity,
      This_may_take_much_time_please_press_YES_to_confirm);
    if (WDialogBox(message, "ValidIndex", MB_YESNO | MB_ICONQUESTION) != IDYES)
    {
      ret = 0;
      goto bailout;
    }
  }
#else
  while(kbhit())  getch(); // clear keyboard buffer
  if (ProgressPtr) {
    SetProgressOff();
    StartProgress(3 * RecCount());
  }
#endif
  cycle = 1;

#ifdef NET
  if (Semaphore[Selected]) { // maybe we should just Use("...exclusive") ?
    locked = 1;
    SetReadSemaphoreProc(TRUE);
  }
#endif

  ret = CountRecords();
  if (quit || DBFError) goto bailout;
  unique = Ind[Selected][order-1]->header.unique;
  if (counter != RecCount()) {
    if (!unique || counter > RecCount()) {
      if (!SilentValidMode) {
        sprintf(message, No_of_records_in_index": %ld\n"
                         No_of_records_in_DBF": %ld", counter, RecCount());
#ifdef WINDOWS
        WDialogBox(message, "ValidIndex", MB_OK | MB_ICONEXCLAMATION);
#else
        DialogBox(message, PressAnyKey);
#endif
      }
      ret = -1;
      goto bailout;
    }
  }
  cycle = 2;
  ret = FindAllTheNext();
  if (ret || quit)  goto bailout;

  cycle = 3;
  ret = FindAllThePrevious();
  if (ret || quit)  goto bailout;

  ret = 0;
bailout:
#ifdef NET
  if (locked)  SetReadSemaphoreProc(FALSE);
#endif
  SetOrderTo(saveOrder);
  return ret;
}

BOOL ValidIndexInternal(const void *inptr, int thorough, int notopen, PUDK_func kmaker)
{
  struct stat statbuf;
  char bigstr[512]; // filename + message + kbuf
  char *msg_ptr = NULL;
  long DBFLastUpdated, saveRec;
  int saveAutoHalt, order, handle, error, ret = FALSE;

  saveAutoHalt = AutoHalt;
  memset(bigstr, 0, 512);

  if (fstat(WorkArea[Selected]->Handle.v.dFile, &statbuf) == -1) {
    msg_ptr = failure_to_get_the_file_information;
    goto OUT;
  }
  DBFLastUpdated = statbuf.st_ctime;

  if (notopen) {
    strcpy(bigstr, AddExt(inptr, "NDX"));
    if (stat(bigstr, &statbuf) == -1) {
      msg_ptr = failure_to_get_the_file_information;
      goto OUT;
    }
    kbuf = bigstr + strlen(bigstr) + 1;
  }
  else {
    handle = *(int *)inptr;
    if (fstat(handle, &statbuf) == -1)  goto OUT;
    kbuf = bigstr;
  }
  message = kbuf + MAX_NDX_EXPRESSION_SIZE + 1;

  // analyse the information returned
  if (!(statbuf.st_mode & S_IFREG)) {
    msg_ptr = Not_an_ordinary_file;
    goto OUT;
  }
  if (!(statbuf.st_mode & S_IREAD)) {
    msg_ptr = No_read_permission_on_file;
    goto OUT;
  }
  if (!(statbuf.st_mode & S_IWRITE)) {
    msg_ptr = No_write_permission_on_file;
    goto OUT;
  }
  if (statbuf.st_size < 1024) {
    msg_ptr = Wrong_index_file_size;
    goto OUT;
  }
  if ((DBFLastUpdated - statbuf.st_ctime) > MinTimeDiff_s) {
    msg_ptr = File_is_out_of_date;
    goto OUT;
  }
  AutoHalt = 0;
  if (notopen) {
    DBFError = 0;
    for (order = 1; Ind[Selected][order-1]; order++)
      if (order == MaxOrder)
        goto OUT;

    saveRec = RecNo();
    SetIndexToCB(kmaker, bigstr, order);
    if (DBFError) {
      error = TRUE;
      if (DBFError == 220)
        msg_ptr = File_already_open;
      if (DBFError == 223)
        if (fromCB)
          msg_ptr = You_should_use_ValidIndexCB;
        else
          msg_ptr = Corrupted_Index_Header;
    }
    else {
      error = FALSE;
      if (thorough)
        ret = ThoroughIndexTest((unsigned char)order) == 0;
      else
        ret = TRUE;
    }
    CloseOneIndex(Selected, order-1);
    RawGo(saveRec);
    Skip(0);   // Sync
    if (error)  goto OUT;
  }
  else {
    saveRec = RecNo();
    if (thorough)
      ret = ThoroughIndexTest((unsigned char)order) == 0;
    else
      ret = TRUE;
    RawGo(saveRec);
    Skip(0);   // Sync
  }
OUT:
  if (msg_ptr && !SilentValidMode)
#ifdef WINDOWS
    WDialogBox(msg_ptr, "ValidIndex", MB_OK | MB_ICONEXCLAMATION);
#else
    DialogBox(msg_ptr, PressAnyKey);
#endif
  AutoHalt = saveAutoHalt;
  return ret;
}

BOOL ValidIndex(const char *fname, BOOL thorough)
{
  fromCB = 0;
  return ValidIndexInternal(fname, thorough, TRUE, NULL);
}

BOOL ValidIndexCB(const char *fname, BOOL thorough, PUDK_func kmaker)
{
  fromCB = 1;
  return ValidIndexInternal(fname, thorough, TRUE, kmaker);
}
#endif
