/* filename: TREEPATH.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _MSC_VER
#pragma argsused
#endif
// len is never used, but this function must have memcpy-like syntax !
int double_compare( const void * first, const void * second, size_t len )
{
  return  (*(double*)first == *(double*)second)? 0 : ((*(double*)first > *(double*)second)?1:-1);
}

void clean_path(int area, int order, int all)
{
  PIndexType p;
  PPath current, tmp;

  p = Ind[area][order];
  current = p->path;
  if (p && current) {
    if (all)
      p->path = NULL;
    else {
      memset (&current->counter, 0, sizeof(Path) - 2*sizeof(void *));
      current->counter = -1;
      tmp = current->next;
      current->next = NULL;
      current = tmp;
    }
    while (current) {
      tmp = current->next;
      free (current);
      current = tmp;
    }
  }
  p->cpath = p->path;
}

void add_path(long block_no, int order)
{
  PPath cpath, path;
  PIndexType   p;

  p = Ind[Selected][order];
  cpath = p->cpath;
  ++ cpath->counter;
  if (cpath->counter >= PATH_DEPTH) {// path buffer is full
    if ((path = malloc(sizeof(Path))) == NULL) {
      SetError( InsufficientMemory, 1, "[add_path]" );
      return;
    }
    cpath->next = (void *) path;
    memset(path,0,sizeof(Path));
    path->prev = (void *) cpath;
    cpath = p->cpath = path;
  }
  cpath->blockno[cpath->counter] = block_no;
  memmove(&cpath->blocks[cpath->counter], p->BlockBufferPtr, BLOCK_SIZE);
}

long up_path(int order)
{
  PPath cpath, path;
  PIndexType p;

  p = Ind[Selected][order];
  cpath = p->cpath;
  if (!cpath->counter && cpath == p->path)
    return 0L; // root block
  if (!cpath->counter) {// path buffer is empty, deallocate memory
    path = cpath->prev;
    path->next = NULL;
    free(cpath);
    cpath = p->cpath = path;
  }
  --cpath->counter;
  return cpath->blockno[cpath->counter];
}

long up_path_prev(int order)
{
  PIndexType p;
  long block, cblock, pblock;
  PPath cpath;
  short  g_len, offset;

  p = Ind[Selected][order];
  cpath = p->cpath;
  cblock = cpath->blockno[cpath->counter];
  g_len = p->header.group_len / sizeof(long);
  do {
    block = cblock;
    if ((cblock = up_path(order)) == 0L) return 0L;// root block, quit
    GetNode( cblock, order );
  } while (p->Index->block_num == block);
  // now find a previous block
  cblock = p->Index->block_num;
  for(offset = 0; cblock && cblock != block; offset++) {
    pblock = cblock;
    cblock = *((long *)p->Index + offset * g_len);
  }
  // go down to find the last key
  p->Index = Dfind_last(p, pblock, order, TRUE);
  p->currnode = NoDe;
  return p->Index->DBFRecNo;
}

long up_path_next(int order)
{
  PIndexType p;
  long block, cblock, pblock;
  PPath cpath;
  short g_len, offset;

  p = Ind[Selected][order];
  cpath = p->cpath;
  cblock = cpath->blockno[cpath->counter];
  g_len = p->header.group_len / sizeof(long);
  do {
    block = cblock;
    if ((cblock = up_path(order)) == 0L) return 0L; // root block, quit
    GetNode(cblock, order);
    pblock = *((long *)p->Index + p->BlockBufferPtr->num_keys * g_len);
  } while (pblock == block);
  cblock = p->Index->block_num;
  for(offset = 1; cblock && pblock != block; offset++) {
    pblock = cblock;
    cblock = *((long *)p->Index + offset * g_len);
  }
  while(cblock) {// find leaf
    GetNode(cblock, order);
    add_path(cblock, order);
    cblock = p->Index->block_num;
  }
  return p->Index->DBFRecNo;
}

void * ScanPaths(long block, int area, int order)
{
  PPath cpath;
  PIndexType p;
  int counter;

  p = Ind[area][order];
  cpath = p->path;
  counter = cpath->counter;
  if (cpath == NULL || counter == -1)
    return NULL; // no path... no search...


  if (!counter) // root
    return (block == cpath->blockno[counter]) ? &cpath->blocks[0]:NULL;

  while (counter >= 0) {
    if (cpath->blockno[counter] == block)
      return &cpath->blocks[counter];
    if (!counter) {
      cpath = cpath->next;
      if (!cpath)
        return NULL; // not found
      counter = (p->cpath == cpath) ? (cpath->counter+1) : PATH_DEPTH;
    }
    counter--;
  }
  return NULL;
}
#endif // NDX_TYPE
