/* filename: SYNCIDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <index.h>

extern int OrderChanged;

#ifndef NET
void SyncIndexProc(void)
{
  char k[101];
  int saveorder, len;
  PIndexType p;
#ifndef NDX_TYPE
  int saveSoundexFlag, saveDescending;
#endif
  int saveZerOrder = ZerOrder[Selected];

  saveorder = SyncOrder;
  SyncOrder = 0; //  this is the order number
  p = Ind[Selected][SyncOrder];
  if (p) { // Not NULL means the index is open
    if (RecNo() > RecCount()) { // we are beyond EOF..just point Index to our "pseudonode"
      FindLastRecFunc(); // this positions the index to EOF
      RawGo(RecCount() + 1L);
      p->EOFFlag = TRUE; //  reset the flag
#ifdef NDX_TYPE
      SetPseudoNode(Selected, SyncOrder);
#else
      SetPseudoNode(Selected, SyncOrder, p->Index->Entry);
#endif
      SyncOrder = saveorder;
      return;
    }
    // following added to fix problem with SetOrderTo with an empty dbf
    if (RecCount() == 0L) {// empty file
      p->BOFFlag = p->EOFFlag = TRUE; // reset the flags
#ifdef NDX_TYPE
      SetPseudoNode(Selected, SyncOrder);
      SyncOrder = saveorder;
      return;
    }
    len = p->header.key_len;
    SyncPOrder = SyncOrder; // for parser
    memcpy(k, FarKey(SyncOrder), len+1);
    if (strlen(k) != (size_t) len && p->kiss)
#else
      SetPseudoNode(Selected, SyncOrder, 0);
      SyncOrder = saveorder;
      return;
    }
    len = p->KeyLength;
    memcpy(k, FarKey(SyncOrder), len+1);
    if (strlen(k) != (size_t) len)
#endif
    {
      SetError(BadSize,11,incorrect_key_length_returned_by_user_defined_keymaker,
      "\r\n", expected_length, SInteger(len, 3),
      "\r\n", key_equals,"[",k,"] ", IndexName(SyncOrder)," [GO]");
      SyncOrder = saveorder;
      return;
    }
    ZerOrder[Selected] = 0;
#ifdef NDX_TYPE
    _Find(k);
#else
    InhibitGo = TRUE;// tell FIND not to move the database record
    saveSoundexFlag = p->SoundexFlag;
    saveDescending = p->Descending;
    p->SoundexFlag = FALSE;
    p->Descending = FALSE;
    Find(k);
    p->SoundexFlag = saveSoundexFlag;
    p->Descending = saveDescending;
    InhibitGo = FALSE;
#endif
    if (!Found) {
      ZerOrder[Selected] = saveZerOrder;
      SetError(OutOfRange, 5, key_quote, Trim(k), endquote_not_in_index,
      IndexName(SyncOrder), ". [SyncIndexProc]");
      SyncOrder = saveorder;
      return;
    }
    InhibitGo = TRUE;// don't let FindNextRec move the database
    while((memcmp(p->Index->Key,k,len) == 0) && (p->Index->DBFRecNo != RecNo()))
      FindNextRecFunc();// we found a node, but is it the right one?
    InhibitGo = FALSE;
    if (memcmp(p->Index->Key,k,len) != 0) {
      ZerOrder[Selected] = saveZerOrder;
      SetError(OutOfRange, 5, record_with_key_quote,Trim(k),
      endquote_not_in_index,IndexName(SyncOrder),". [SyncIndexProc]");
      SyncOrder = saveorder;
      return;
    }
  }
  ZerOrder[Selected] = saveZerOrder;
  SyncOrder = saveorder;
}
#else

void SyncIndexProc(void)
{
  char  k[101], TotalIndexes;
  int   oldsyncorder, len, saveZerOrder = ZerOrder[Selected];
  long  CurrentRecNo;
  PIndexType p;
#ifndef NDX_TYPE
  int saveSoundexFlag, saveDescending;
#endif

  oldsyncorder = SyncOrder;
  CurrentRecNo = RecNo();
  if (SyncAll) // Replace() made this call
    TotalIndexes = MaxOrder;
  else         // normally only sync up the primary index
    TotalIndexes = 1;
  IndexesChanged();
  ZerOrder[Selected] = 0;
  for (SyncOrder = 0; SyncOrder < TotalIndexes; SyncOrder++) {
    OrderChanged = 1;
    p = Ind[Selected][SyncOrder];
    if (p) {  // Not NULL means the index is open
      if (CurrentRecNo == 0 || (CurrentRecNo > RecCount())) {
        // we are beyond EOF..just point Index to our "pseudonode"
        FindLastRecFunc();   // this positions the index to EOF
        RawGo(RecCount() + 1L);
        p->EOFFlag = TRUE;   //  reset the flag
#ifdef NDX_TYPE
        SetPseudoNode(Selected, SyncOrder);
#else
        SetPseudoNode(Selected, SyncOrder, p->Index->Entry);
#endif
        continue;
      }
#ifdef NDX_TYPE
      len = p->header.key_len;
      SyncPOrder = SyncOrder; // for parser
      memcpy(k, FarKey(SyncOrder), len+1);
      if (strlen(k) != (size_t) len && p->kiss)
#else
      len = p->KeyLength;
      memcpy(k, FarKey(SyncOrder), len+1);
      if (strlen(k) != (size_t) len)
#endif
      {
        ZerOrder[Selected] = saveZerOrder;
        OrderChanged =1;
        SyncOrder = oldsyncorder;
        SetError(BadSize,10,incorrect_key_length_returned_by_user_defined_keymaker,
        "\r\n", expected_length, SInteger(len, 3),
        "\r\n", key_equals, "[", k, "] ", IndexName(SyncOrder));
        assertJumper();
        return;
      }
#ifdef NDX_TYPE
      IndexesChanged();
      _Find(k);
#else
      saveSoundexFlag = p->SoundexFlag;
      saveDescending = p->Descending;
      p->SoundexFlag = FALSE;
      p->Descending = FALSE;
      InhibitGo = TRUE;// tell FIND not to move the database record
      // find will handle checking to see if it needs to read the anchor
      Find(k);
      p->SoundexFlag = saveSoundexFlag;
      p->Descending = saveDescending;
#endif
      if (!Found) {
        InhibitGo = FALSE;
        ZerOrder[Selected] = saveZerOrder;
        OrderChanged = 1;
        SyncOrder = oldsyncorder;
        SetError(OutOfRange, 7, key_quote, Trim(k),
        endquote_not_in_index, IndexName(SyncOrder),
        ". [SyncIndex-1]", "Record: ",SInteger(CurrentRecNo,0));
        assertJumper();
        return;
      }
      // we found a node, but is it the right one?
      while((memcmp(p->Index->Key,k,len) == 0) && (p->Index->DBFRecNo != CurrentRecNo))
        FindNextRecFunc();
      InhibitGo = FALSE;
      if (memcmp(p->Index->Key,k,len) != 0) {
        ZerOrder[Selected] = saveZerOrder;
        OrderChanged = 1;
        SyncOrder = oldsyncorder;
        SetError(OutOfRange, 5, record_with_key_quote, Trim(k),
          endquote_not_in_index,IndexName(SyncOrder),". [SyncIndex-2]");
        assertJumper();
        return;
      }
    }
  }
  ZerOrder[Selected] = saveZerOrder;
  SyncOrder = oldsyncorder;
  OrderChanged = 1;
}
#endif // NET
