/* filename: STACK.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <common.h>
#include <parser.h>

PParseBufferStruct MakeParserHandle;
static PParseBufferStruct P;
static PStackNode         Sptr;

#ifdef DYNAMIC_TYPE
static int  ws_top; // top of the working stack

PStackNode GetFirstSStackNode(void)
{
  return &((PTag) P->ss_first)->snode;
}

PStackNode GetNextSStackNode(void)
{
  P->ss_list = P->ss_list->next;
  return &((PTag) P->ss_list)->snode;
}

// Check the semantic stack overflow
static void SStackCheck(void)
{
  if (!P->ss_list) {
    if (allocate_and_link(&P->ss_list, sizeof(StackNode)) == NULL)

      SetError(InsufficientMemory, 1, " [PARSER/SStackCheck]");
    P->ss_first = P->ss_list;
    return;
  }
  if (P->ss_list->next == P->ss_first) {
    if (allocate_and_link(&P->ss_list, sizeof(StackNode)) == NULL)
      SetError(InsufficientMemory, 1, " [PARSER/SStackCheck]");
  }
  else
    P->ss_list = P->ss_list->next;
}

// Check the working stack overflow
static void WStackCheck(void)
{
  if (!P->ws_list) {
    if (allocate_and_link(&P->ws_list, sizeof(StackNode)) == NULL)
      SetError(InsufficientMemory, 1, " [PARSER/SStackCheck]");
    P->ws_first = P->ws_list;
    if (P->ReturnType != 'M' && P->ReturnType != 'C')
      P->ReturnPtr = &((PTag) P->ws_first)->snode.type;
    return;
  }

  if (P->ws_list->next == P->ws_first) {
    if (allocate_and_link(&P->ws_list, sizeof(StackNode)) == NULL)
      SetError(InsufficientMemory, 1, " [PARSER/WStackCheck]");
  }
  else
    P->ws_list = P->ws_list->next;
}

#else

// Get address of current stack node increment stack pointer
PStackNode GetSStackNode(void)
{
  return &P->SemanticStack[P->SemanticStackPtr++];
}

// Check stack overflow
static void SStackCheck(void)
{
  if(P->SemanticStackPtr == MAXSTACKDEPTH) {
    SetError(SemanticStackOverflow, 2, Semantic_stack_overflow, " [PARSER/SStackCheck]");
    return;
  }
}

static void WStackCheck(void)
{
  if(P->WorkStackPtr == MAXSTACKDEPTH) {
    SetError(WorkingStackOverflow, 2, Working_stack_overflow, " [PARSER/WStackCheck]");
    return;
  }
}
#endif

// Allocate memory in the working pool and copy date into it
static char *Allocate(void *data, int size)
{
  char *ptr, *pool_edge;

  pool_edge = P->WorkingPool + P->WorkingPoolSize;

  if(P->WorkingPoolPtr + size > pool_edge) {
    SetError(WorkingPoolOverflow, 2, Working_pool_overflow, " [PARSER/Allocate]");
    return NULL;
  }
  ptr = memcpy(P->WorkingPoolPtr, data, size);
  P->WorkingPoolPtr += size;

  return ptr;
}

// Add action node into the semantics stack
void PushSA(int Action, char ArgsNo)
{
  SStackCheck();
#ifdef DYNAMIC_TYPE
  Sptr = &((PTag) P->ss_list)->snode;
#else
  Sptr = &P->SemanticStack[P->SemanticStackPtr++];
#endif
  Sptr->Action = Action;
  Sptr->ArgsNo  = ArgsNo;
  Sptr->ArgType = 0;
}

// Add data node into semantics stack
void PushSD(int DataType, void *Data)
{
  SStackCheck();
#ifdef DYNAMIC_TYPE
  Sptr = &((PTag) P->ss_list)->snode;
#else
  Sptr = &P->SemanticStack[P->SemanticStackPtr++];
#endif
  Sptr->Action = 0;
  Sptr->ArgType = DataType;
  switch(DataType) {
    case _NUMBERTYPE :
      Sptr->type.N = *(N_PTR)Data;
      break;
    case _STRINGTYPE :
      Sptr->type.C  = (C_PTR)Data;
      break;
    case _DATETYPE :
      Sptr->type.D  = *(D_PTR)Data;
      break;
    case _LOGICALTYPE :
      Sptr->type.L  = *(L_PTR)Data;
      break;
    default : // this should not ever happen
      SetError(UnknownDataType, 2, Unknown_data_type, " [PARSER/PushSD]");
      break;
  }
}

// Add data node into the working stack
void PushWD(int DataType, void *Data)
{
#ifdef DYNAMIC_TYPE
  if (!ws_top)
    WStackCheck();
  else
    ws_top = 0;
  Sptr = &((PTag) P->ws_list)->snode;
#else
  WStackCheck();
  Sptr = &P->WorkStack[P->WorkStackPtr++];
#endif
  Sptr->Action = 0;
  Sptr->ArgType = DataType;
  switch(DataType) {
    case _NUMBERTYPE :
      Sptr->type.N = *(N_PTR)Data;
      break;
    case _STRINGTYPE :
      Sptr->type.C = Allocate((C_PTR)Data, strlen((C_PTR)Data) + 1);
      break;
    case _DATETYPE :
      Sptr->type.D = *(D_PTR)Data;
      break;
    case _LOGICALTYPE :
      Sptr->type.L  = *(L_PTR)Data;
      break;
    default : // this should not ever happen
      SetError(UnknownDataType, 2, Unknown_data_type, " [PARSER/PushWD]");
      break;
  }
}

// Push memo into the working pool and modify the working stack
void PushMemoInWD(void *Data)
{
  if (!Data)
    return;
#ifdef DYNAMIC_TYPE
  if (!ws_top)
    WStackCheck();
  else
    ws_top = 0;
  Sptr = &((PTag) P->ws_list)->snode;
#else
  WStackCheck();
  Sptr = &P->WorkStack[P->WorkStackPtr++];
#endif
  Sptr->Action = 0;
  Sptr->ArgType = _MEMOTYPE;
  PushMemo(P, Sptr, Data);
}

// Get data node from the working stack
void *PopWD(void)
{
#ifdef DYNAMIC_TYPE
  Sptr = &((PTag) P->ws_list)->snode;
  if (P->ws_first == P->ws_list)
    ws_top = 1;
  else
    P->ws_list = P->ws_list->prev;
#else
  if(!P->WorkStackPtr) {
    SetError(WorkingStackEmpty, 2, Working_stack_empty, " [PARSER/PopWD]");
    return NULL;
  }
  Sptr = &P->WorkStack[--P->WorkStackPtr];
#endif
  switch(Sptr->ArgType) {
    case _STRINGTYPE :
      P->WorkingPoolPtr = Sptr->type.C;
      return Sptr->type.C;
    case _DATETYPE :
      return &Sptr->type.D;
    case _NUMBERTYPE :
      return &Sptr->type.N;
    case _LOGICALTYPE :
      return &Sptr->type.L;
  } // this should not ever happen
  SetError(UnknownDataType, 2, Unknown_data_type, " [PARSER/PopWD]");
  return NULL;
}

char *GetStringAddressInWS(void)
{ // Instead of Popping-Modifying-Pushing the same string sometimes it
  // is better to modify it right in the working stack
  // this is true only if we do not change the string length or
  // just shorten the string
#ifdef DYNAMIC_TYPE
  return ((PTag) P->ws_list)->snode.type.C;
#else
  if(!P->WorkStackPtr) {
    SetError(WorkingStackEmpty, 2, Working_stack_empty, " [PARSER/GetDirect]");
    return NULL;
  }
  return P->WorkStack[P->WorkStackPtr-1].type.C;
#endif
}

#ifdef PARSER_EXTENSIONS

void type_save_restore_parameters(int save)
{ // this function is for t_TYPE only
  // (a bad guy: uses recursive call to AssignExpr)
  static int saveError, saveHalt;
  static PParseBufferStruct save_handle;
  static unsigned memosize;
#ifdef DYNAMIC_TYPE
  static int savePtr;
#endif

  if (save) {
    saveError = DBFError;
    saveHalt  = AutoHalt;
    save_handle = P;
    memosize = MemoGetSize;
    MemoGetSize = 0U; // reduce extra memory consuming for memo pool
    AutoHalt  = 0;
#ifdef DYNAMIC_TYPE
    savePtr = ws_top;
#endif
  }
  else {
    P = save_handle;
    DBFError = saveError;
    AutoHalt = saveHalt;
    MemoGetSize = memosize;
#ifdef DYNAMIC_TYPE
    ws_top = savePtr;
#endif
  }
}
#endif

void InitEngine(PParseBufferStruct p)
{
  P = p;
  P->WorkingPoolPtr   = P->WorkingPool;
#ifdef DYNAMIC_TYPE
  P->ss_list = P->ss_first;
  P->ws_list = P->ws_first;
  ws_top = P->ws_first ? 1 : 0;
#else
  P->SemanticStackPtr = 0;
  P->WorkStackPtr     = 0;
#endif
}

void *GetNewKeyPtr(void)
{
  return P->ReturnPtr;
}

char *MakeParserEngine(void)
{
  // InitEngine(MakeParserHandle);
  P = MakeParserHandle;
  P->WorkingPoolPtr   = P->WorkingPool;
#ifdef DYNAMIC_TYPE
  P->ss_list = P->ss_first;
  P->ws_list = P->ws_first;
  ws_top = P->ws_first ? 1 : 0;
#else
  P->SemanticStackPtr = 0;
  P->WorkStackPtr     = 0;
#endif
  BuildNewKey();
  return (char *)P->ReturnPtr;
}
  
