/* filename: SOFTSYNC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NET
#include <string.h>
#include <sayget.h>
#include <index.h>

void SoftSyncIndex(void)
// called before a findnextrec when multi-user and
// we detect that the tree has been modified
{
  char    k[101];
  int     len;
  PIndexType p;
#ifndef NDX_TYPE
  int     saveSoundexFlag, saveDescending;
#endif

  p = Ind[Selected][0];
  if (RecNo() > RecCount()) { // we are beyond EOF..just point Index to our "pseudonode"
    FindLastRecFunc();   // this positions the index to EOF
    RawGo(RecCount()+1);
    p->EOFFlag = TRUE;   //  reset the flag
#ifdef NDX_TYPE
    SetPseudoNode(Selected, 0);
    return;
  }
  len = p->header.key_len;
  SyncPOrder = 0; // for parser
  memcpy(k,FarKey(0),len+1);// get the key for the current record
  if (strlen(k) != (size_t) len && p->kiss) {
#else
    SetPseudoNode(Selected, 0, p->Index->Entry);
    return;
  }
  len = p->KeyLength;
  memcpy(k,FarKey(0),len+1);// get the key for the current record
  InhibitGo = TRUE; // tell FIND not to move the database record
  if (strlen(k) != (size_t) len) {
#endif
    SetError(BadSize,10,incorrect_key_length_returned_by_user_defined_keymaker,
    "\r\n",expected_length,SInteger(len,3),
    "\r\n",key_equals,"[",k,"] ",IndexName(0));
    assertJumper();
  }
#ifdef NDX_TYPE
  _Find(k);
#else
  saveSoundexFlag = p->SoundexFlag;
  saveDescending = p->Descending;
  p->SoundexFlag = FALSE;
  p->Descending = FALSE;
  FindingEdge = TRUE;
  Find(k);
  FindingEdge = InhibitGo = FALSE;
  p->SoundexFlag = saveSoundexFlag;
  p->Descending = saveDescending;
#endif
  if (!Found) {
    SetError(OutOfRange,5,record_with_key_quote,Trim(k),endquote_not_in_index,IndexName(0),". [GO/SOFTSYNCINDEX]");
    assertJumper();
  }
  else {
    while ((memcmp(p->Index->Key,k,len) == 0) && (p->Index->DBFRecNo != RecNo()))
      FindNextRecFunc();// we Found a node, but is it the right one?
    if (memcmp(p->Index->Key,k,len)) {
      SetError(OutOfRange,5,record_with_key_quote,Trim(k),
      endquote_not_in_index,IndexName(0),". [GO/SOFTSYNCINDEX]");
      assertJumper();
    }
  }
}
#endif // NET
