/* filename: SETORDR2.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <setjmp.h>
#include <index.h>

int ZerOrder[AbsoluteMaxWorkareas] = {0};
extern int OrderChanged;
extern jmp_buf Jumper;

void ResetCache(void)
{
  PIndexType p;

  if (NeverCacheIndexes)
    return;
  p = Ind[Selected][0];

  // now clear the Cache for the currently Selected area:
  // but, before clearing the cache, save Index to NodeBuffer
  // (since Index may be pointing to a node in the cache,
  // which we are about to trash) and then point Index to NodeBuffer

#ifdef NDX_TYPE
  memcpy( &p->BlockBuffer, p->BlockBufferPtr, BLOCK_SIZE );
  p->BlockBufferPtr = &p->BlockBuffer;
  p->Index = (PNode)((char *)p->BlockBufferPtr + sizeof(long) +
                            p->currnode * p->header.group_len);
  if (Cache[Selected]) {
    memset(Cache[Selected], 0, CacheMemSize[Selected]);
    memset(CachePtrs[Selected],0,
    CacheMemSize[Selected]/BLOCK_SIZE * (sizeof(void *)+sizeof(long)));
  }
#else
  memcpy(&p->NodeBuffer,p->Index,sizeof(Node));
  p->Index = &p->NodeBuffer;
  if (Cache[Selected]) {
    memset(Cache[Selected], 0, CacheMemSize[Selected]);
    CNSize[Selected] = (unsigned) p->NodeSize;
  }
#endif
}

void SetOrderToPrim(unsigned char n)
{
  PIndexType TempInd[MaxOrder], p, pnew;
  unsigned char OrderMap[MaxOrder];
  int  i, EndOfFile;
  char *err_ptr;
  char err_msg[STRSIZ];

  ZerOrder[Selected] = 0;
  //  Notice: before this routine is called, we have checked that there
  // is a database open in the current workarea and the value of N is
  // in range for indexes (0..15)
  p = Ind[Selected][0];
  if (!p) { // if there is no primary index, how can you swap?
    err_ptr = no_primary_index_active;
    goto bailout;
  } // if n is already the Selected index, then we can just exit
  if (RecCount())
    RawGo(RecNo());
  if (n == CurrentOrder()-1U)
    return;
  // check that the index we are trying to switch to is open:
  if (!Ind[Selected][n]) {
    err_ptr = index_not_open;
    goto bailout;
  }
  EndOfFile = p->EOFFlag;
  // initialize the order map
  for (i = 0; i < MaxOrder; i++)
    OrderMap[i] = i;
  // swap 1 with n
  OrderMap[0] = n;
  OrderMap[n] = 0;
  // change the order of the Ind pointers
  for (i = 0; i < MaxOrder; i++)
    TempInd[i] = SaveInd[Selected][i];
  for (i = 0; i < MaxOrder; i++)
    Ind[Selected][i] = TempInd[OrderMap[i]];
  pnew = Ind[Selected][0];

#ifdef NDX_TYPE
  // Swap path pointers
  pnew->path =  p->path;
  pnew->cpath=  p->cpath;
  p->path = p->cpath = 0;
  OrderChanged = 1;
#endif
  SyncOrder = SyncPOrder = 0;
  ResetCache();
  // now sync up the indexes..which will work fine as long as there are
  // records, and we are not at EndOfFile...the reason is that SyncIndex
  // looks at the current key to "find itself", and the current key is
  // blank. If we are at EndOFFile we need to GoBottom and SKIP 1.
  // If there are no records, no syncing is required
  if (!RecCount()) {
    StoreCurrentKeys();
    OrderArray[Selected] = n;
    return;
  }
  if (EndOfFile) {   // this is derived from SetEOF
    FindLastRecFunc();
    RawGo (RecCount() + 1L);
    pnew->EOFFlag = TRUE;
#ifdef NDX_TYPE
    SetPseudoNode(Selected, 0);
#else
    SetPseudoNode(Selected, 0, pnew->Index->Entry);
#endif
    StoreCurrentKeys();
    OrderArray[Selected] = n;
  }
  return;

bailout:
  sprintf(err_msg, "%s. (DBF=%s) [SetOrderTo(%d)]", err_ptr, DBF(), n+1);
  SetError(IndexNotOpen, 1, err_msg);
  assertJumper();
  return;
}

void SetOrderTo(unsigned char n)
{
  if (setjmp(Jumper))
    return;
  DBFError = 0;
  if (!*DBF()) { // or no database is open
    SetError(NotInUse,4,Database_not_open," [SetOrderTo(",SInteger(n,0),")]");
    assertJumper();
    return;
  } // check that n is in range
  if (n > MaxOrder) {
    SetError(InvalidParameter, 6, invalid_index_order_specified,
    ". (DBF=", DBF(), ") [SetOrderTo(", SInteger(n,0), ")]");
    return;
  }
  if (n) {
    --n; // make n 0-based
#ifdef NET
    SetReadSemaphoreProc(1);
#endif
    SetOrderToPrim(n);
    SyncIndexProc();
    StoreCurrentKeys();
#ifdef NET
    SetReadSemaphoreProc(0);
#endif
    OrderArray[Selected] = n;
  }
  else
    ZerOrder[Selected] = 1;
}
