/* filename: SEMAPHOR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NET
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <share.h>
#include <errno.h>
#include <sayget.h>
#include <dbf.h>
#include <index.h>
#ifdef WINDOWS
#include <windows.h>
#define SEMAPHORE_TIMEOUT 100000L // in milliseconds (100 sec)
#else
#define SEMAPHORE_TIMEOUT 1820U   // ticks
// Timer ticks before time out attempting to lock or read a semaphore file.
// There are 18.2065 ticks per second thus 1820 ticks = 100 seconds.
// Zero means never time out, but never set it to zero
// (always will generate "FatalError")
#endif

SemaphoreRecord *Semaphore[HelpWorkArea+1] = {NULL};

unsigned char UserCount(char area)
{
  if (Semaphore[--area]) {
    HandleSemaphore(area, CheckUserCount);
    return Semaphore[area]->Data.Users;
  }
  else
    return 0;
}

static char * SemaphoreFilename(void)
{
  return ReplaceExt(DBF(), "@S@");
}

static char * ActionName(ActionType action)
{
  switch (action) {
    case Login:   return "LOGIN";
    case Logout:  return "LOGOUT";
    case IncRead: return "INCREAD";
    case DecRead: return "DECREAD";
    case LockSemaphore:   return "LOCKSEMAPHORE";
    case UnlockSemaphore: return "UNLOCKSEMAPHORE";
    case CheckUserCount: return "CheckUserCount";
    default: return "";
  }
}

static int LockSemaphoreFile(char area, ActionType action)
{
  int  SfLocked = 0, counter;
  int i;

  for (counter = 0; !SfLocked && (counter < 10000); counter++) {
    SfLocked = !LockUnlock(0, Semaphore[area]->SF, 1, sizeof(Semaphore[area]->Data));
    if (!SfLocked)
      for (i = 1; i < 1000; i++) ; // wait a mini-moment
  }
  if (!SfLocked) {
    SetError(1202, 3, File_Locked, SemaphoreFilename(), ActionName(action));
    return FALSE;
  }
  else
    Semaphore[area]->LockFlag = TRUE;
  return TRUE;
}

static void UnlockSemaphoreFile(char area, ActionType action)
{
  if (LockUnlock(1, Semaphore[area]->SF, 1, sizeof(Semaphore[area]->Data)))
    SetError(1202, 2, SemaphoreFilename(), ActionName(action));
  Semaphore[area]->LockFlag = FALSE;
}

static void FatalError(void)
{
  SetError(SemaphoreError, 4, Error_reading, SemaphoreFilename(),
    Cause_and_cure, SemaphoreFilename());
}

void HandleSemaphore(char area, ActionType action)
{
  long  ReadTryTicks, WaitTicks;
  int   DbfLocked, tmp, i, counter;
  SemaphoreRecord *sa;
  int   sf; // semaphore handle
  char *errptr;
#ifdef NETLOG
  char  tmpbuf[STRSIZ];
#endif

  if (area > HelpWorkArea) {
    errptr = Work_area_out_of_range;
    goto error1;
  }
  if (IsExclusive()) // if the database is opened exclusive, we don't need to do all this
    return;
  sa = Semaphore[area];
  if (sa)
    sf = sa->SF;
  switch (action) {
    case IncRead:
    case DecRead:
      if (sa->LockFlag) return;
      if ((action == IncRead) && sa->Reading) return;
      if ((action == DecRead) && (!sa->Reading)) return;
      // lock the semaphore file before reading it
      if (!LockSemaphoreFile(area, action)) return;
      sa->Reading = (action == IncRead);
      lseek(sf, 0, SEEK_SET); // file is locked
      if (read(sf, &sa->Data, sizeof(SemaphoreType)) != sizeof(SemaphoreType)) {
        tmp = _doserrno;
        errptr = Error_reading;
        goto error2;
      }
      if (action == IncRead)
        ++sa->Data.Reading;
      else
        --sa->Data.Reading;
      lseek(sf, 0, SEEK_SET);
      if (write(sf, &sa->Data, sizeof(SemaphoreType)) != sizeof(SemaphoreType)) {
        tmp = _doserrno;
        errptr = WriteError;
        goto error2;
      }
      UnlockSemaphoreFile(area, action);
      if (action == DecRead) // keep track of change count for this area
        sa->LastChange = sa->Data.Changecount;
#ifdef NETLOG
      sprintf(tmpbuf, "%s Stations reading index = %ld", ActionName(action), (long)sa->Data.Reading);
      WriteLog(tmpbuf);
#endif
      break;
    case LockSemaphore:
      if (sa->LockFlag) {
#ifdef NETLOG
        WriteLog("Semaphore already locked, exiting LockSemaphore");
#endif
        return;
      }
#ifdef NETLOG
      sprintf(tmpbuf, "Waiting to %s", ActionName(action));
      WriteLog(tmpbuf);
#endif
#ifdef WINDOWS
      WaitTicks = GetTickCount();
      do {
        ReadTryTicks = GetTickCount();
#else
        WaitTicks = *BiosTimerTicks;
        do {
          ReadTryTicks = *BiosTimerTicks;
#endif

again:

#ifdef WINDOWS
          if ((GetTickCount() - ReadTryTicks) > SEMAPHORE_TIMEOUT)
#else
          for (i = 1; i <= 100; i++); // wait a mini-moment
          if ((unsigned)(*BiosTimerTicks - ReadTryTicks) > SEMAPHORE_TIMEOUT)
#endif
          { // generate an error: semaphore file is never unlocked by another user
            FatalError();
            return;
          }
          // attempt to read file, may be locked by another program
          lseek(sf, 0, SEEK_SET);
          if (sizeof(SemaphoreType) != read(sf, &sa->Data, sizeof(SemaphoreType)))
            goto again;
#ifdef NETLOG
          sprintf(tmpbuf, "%s Stations reading index = %d", ActionName(action), (int)sa->Data.Reading);
          WriteLog(tmpbuf);
#endif
          // file is now readable, lock it and read it again
          LockSemaphoreFile(area, action);
          // errors handled by locking routine
          lseek(sf, 0, SEEK_SET);
          if (sizeof(SemaphoreType) != read(sf, &sa->Data, sizeof(SemaphoreType))) {
            tmp = _doserrno;
            errptr = Error_reading;
            goto error2;
          }
          if (sa->Data.Reading)
            UnlockSemaphoreFile(area, action);
        } while (!((sa->Data.Reading == 0) ||
#ifdef WINDOWS
        ((GetTickCount()-WaitTicks) > SEMAPHORE_TIMEOUT)));
        if ((GetTickCount()-WaitTicks) > SEMAPHORE_TIMEOUT)
#else
        ((unsigned)(*BiosTimerTicks-WaitTicks) > SEMAPHORE_TIMEOUT)));
        if ((unsigned)(*BiosTimerTicks-WaitTicks) > SEMAPHORE_TIMEOUT)
#endif
        {
          UnlockSemaphoreFile(area, action);
          FatalError();
          return;
        }
        ++sa->Data.Reading;
        lseek(sf, 0, SEEK_SET);
        if (sizeof(SemaphoreType) != write(sf, &sa->Data, sizeof(SemaphoreType))) {
          tmp = _doserrno;
          errptr = Error_writing;
          goto error2;
        }
#ifdef NETLOG
        sprintf(tmpbuf, "Completed %s", ActionName(action));
        WriteLog(tmpbuf);
#endif
        break;
    case UnlockSemaphore:
      if (!sa->LockFlag) {
#ifdef NETLOG
        WriteLog("Semaphore not locked, exiting UnLockSemaphore");
#endif
        return;
      }
#ifdef NETLOG
      WriteLog(ActionName(action));
#endif
      lseek(sf, 0, SEEK_SET);
      if (sizeof(SemaphoreType) != read(sf, &sa->Data, sizeof(SemaphoreType))) {
        tmp = _doserrno;
        errptr = Error_reading;
        goto error2;
      }
      ++sa->Data.Changecount;
      sa->Data.Reading = 0;
      lseek(sf, 0, SEEK_SET);
      if (sizeof(SemaphoreType) != write(sf, &sa->Data, sizeof(SemaphoreType))) {
        tmp = _doserrno;
        errptr = Error_writing;
        goto error2;
      }
      UnlockSemaphoreFile(area, action);
      // keep track of change count for this area  */
      sa->LastChange = sa->Data.Changecount;
      break;
    case Login:
      if (sa) return; // already logged in
#ifdef NETLOG
      OpenLogFile();
      WriteLog("Logging in \r");
#endif
      if ((Semaphore[area] = (SemaphoreRecord *)malloc(sizeof(SemaphoreRecord))) != NULL) {
        sa = Semaphore[area];
        memset(sa, 0, sizeof(SemaphoreRecord));
      }
      else {
        SetError(InsufficientMemory, 1, "[SetIndexTo]");
        return;
      }
      // lock the first byte in the database file
      // while we create/open the semaphore file
      counter = 0;
      do {
        DbfLocked = SLock();
        if (!DbfLocked) {
          ++counter;
          for (i = 1; i <= 1000; i++); // wait a mini-moment
        }
        if (counter > 1000) {
          tmp = 1201;
          errptr = Cannot_lock_database_for;
          goto error2;
        }
      } while (!DbfLocked);
#ifdef WINDOWS
      SetErrorMode(1);
#endif
      _doserrno = errno = 0;
      sf = sa->SF = sopen(SemaphoreFilename(), // try to open it exclusive
        O_BINARY | O_RDWR | O_CREAT, SH_DENYRW, S_IREAD|S_IWRITE);
          // try to erase it
#ifdef _MSC_VER
      if (errno == ENOENT)
#else
      if (errno == ENOFILE ) // file not found
#endif
        _doserrno = errno = 0;
#ifdef WINDOWS
      SetErrorMode(0);
#endif
      switch (errno) {
        case 0: // now write the four bytes and close the file
          memset(&sa->Data, 0, sizeof(SemaphoreType));
          lseek(sf, 0, SEEK_SET);
          if (write(sf, &sa->Data, sizeof(SemaphoreType)) != sizeof(SemaphoreType)) {
            tmp = _doserrno;
            errptr = Error_writing;
            SUnlock();
            close(sf);
            goto error2;
          }
          close(sf);
          // re-open the file sharable
          sf = sa->SF = sopen(SemaphoreFilename(), O_BINARY | O_RDWR, SH_DENYNO, S_IREAD | S_IWRITE);
          if (!sf) {
            tmp = _doserrno;
            errptr = Failure_to_open;
            SUnlock();
            goto error2;
          }
          if (!LockSemaphoreFile(area, action))
            return;
          sa->LastChange = 0;
          break;

        case EACCES: // access denied
        case EEXIST: // file already exists, created by another user
          errno = 0;
          sf = sa->SF = sopen(SemaphoreFilename(), O_BINARY | O_RDWR, SH_DENYNO, S_IREAD | S_IWRITE);
          if (!sf) {
            tmp = _doserrno;
            errptr = Failure_to_open;
            SUnlock();
            goto error2;
          }
          if (!LockSemaphoreFile(area, action))
            return;
          if (sizeof(SemaphoreType) != read(sf, &sa->Data, sizeof(SemaphoreType))) {
            UnlockSemaphoreFile(area, action);
            tmp = _doserrno;
            errptr = Error_reading;
            SUnlock();
            goto error2;
          }
          break;

        default: // neither 0 nor 5
          errno = 0;
          tmp = _doserrno;
          errptr = Failure_to_open;
          SUnlock();
          goto error2;
      } // we either created or opened and read the semaphore file
      // and it is locked at this point
      ++sa->Data.Users;
      sa->LogicalUser = sa->Data.Users;
      lseek(sf, 0, SEEK_SET);
      if (sizeof(SemaphoreType) != write(sf, &sa->Data, sizeof(SemaphoreType))) {
        tmp = _doserrno;
        UnlockSemaphoreFile(area, action);
        SUnlock();
        errptr = Error_writing;
        goto error2;
      }
      UnlockSemaphoreFile(area, action);
      sa->LastChange = sa->Data.Changecount;
#ifdef NETLOG
      sprintf(tmpbuf, "I am logical user # %d using %s", (int)sa->LogicalUser, SemaphoreFilename());
      WriteLog(tmpbuf);
#endif
      SUnlock();
      break; // login
    case Logout: // called AFTER closing indexes!
#ifdef NETLOG
      sprintf(tmpbuf, " logged out of %s", SemaphoreFilename());
      WriteLog(tmpbuf);
#endif
      if (!sa)
        return; // already logged out
      counter = 0;
      do {
        DbfLocked = SLock();
        if (!DbfLocked) {
          ++counter;
          for (i = 1; i <= 1000; i++) ; // wait a mini-moment
        }
        if (counter > 1000) {
          tmp = 1201;
          errptr = Cannot_lock_database_for;
          goto error2;
        }
      } while (!DbfLocked);
      if (!LockSemaphoreFile(area, action)) {
        SUnlock();
        return;
      }
      lseek(sf, 0, SEEK_SET);
      read(sf, &sa->Data, sizeof(SemaphoreType));
      if (sa->Reading)
        --sa->Data.Reading;
      --sa->Data.Users;
      lseek(sf, 0, SEEK_SET);
      write(sf, &sa->Data, sizeof(SemaphoreType));
      UnlockSemaphoreFile(area, action);
      close(sf);
      if (sa->Data.Users == 0) {
        if (remove(SemaphoreFilename())) {
#ifdef NETLOG
          sprintf(tmpbuf, "Logical user # %d cannot erase semaphore file: %s", (int)sa->LogicalUser, SemaphoreFilename());
          WriteLog(tmpbuf);
          close(Sflog);
#endif
        }
      }
      FreePtrClear((void*) & Semaphore[area]);
#ifdef NETLOG
      WriteLog(" Index semaphore logout successful");
      close(Sflog);
#endif
      SUnlock();
      break;
    case CheckUserCount: // lock the semaphore file before reading it
      if (!LockSemaphoreFile(area, action))
        return;
      lseek(sf, 0, SEEK_SET); // file is locked
      if (sizeof(SemaphoreType) != read(sf, &sa->Data, sizeof(SemaphoreType))) {
        tmp = _doserrno;
        errptr = Error_reading;
        goto error2;
      }
      UnlockSemaphoreFile(area, action);
#ifdef NETLOG
      sprintf(tmpbuf, "%s Stations reading index = %d", ActionName(action), (int)sa->Data.Reading);
      WriteLog(tmpbuf);
#endif
      break;
  } // case
  return;

error2:
  SetError(tmp, 5, errptr, SemaphoreFilename(), " ",
       ActionName(action), " [HandleSemaphore]");
  return;

error1:
  SetError(254, 2, errptr, "[HandleSemaphore]");
  return;
}
#endif
