/* filename: SEEK_WRI.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <index.h>

#ifdef NDX_TYPE

BOOL SeekAndWrite(int area, int order, long position, void *blocktowrite)
{
  PNDXBlock  block;
  PIndexType p;
  void *vptr;
  int handle;
#ifndef WINDOWS
  union REGS inregs;
#endif

  p = Ind[area][order];
  handle = p->Ndx;
  // clear modified flag
  block = (PNDXBlock) blocktowrite;
  block->modified = 0;
  if (p->path) // update the pseudo stack
    if((vptr = ScanPaths(position, area, order)) != NULL)
      if (vptr != blocktowrite)
        memcpy(vptr, blocktowrite, BLOCK_SIZE);
  // set up to write to current node
  lseek(handle, position*BLOCK_SIZE, SEEK_SET);
  if (write(handle, blocktowrite, BLOCK_SIZE) != BLOCK_SIZE) {
    SetError(_doserrno, 2, error_writing_index_file, IndexName(order));
    assertJumper();
    return FALSE;
  }
  // .....

#else

BOOL SeekAndWrite(int area, int order, long position, PNode nodetowrite)
{
  Node   node;
  size_t nodesize;
  int    key_len, handle;

#ifndef WINDOWS
  union REGS inregs;
#endif
  PIndexType  p;

  p = Ind[area][order];
  nodesize = (size_t) p->NodeSize;
  key_len  = p->KeyLength;
  handle = p->Ndx;
  memcpy (&node, nodetowrite, nodesize);
  if (position) { // if not anchor node
    memcpy(&node.Key[1], nodetowrite->Key, key_len);
    node.Key[0] = key_len;
  }
  // set up to write to current node
  lseek(handle, position*nodesize, SEEK_SET);
  if (write(handle, &node, nodesize ) != (int)nodesize) {
    SetError(_doserrno, 2, error_writing_index_file, IndexName(order));
    assertJumper();
    return FALSE;
  }
#endif // NDX_TYPE

#ifndef WINDOWS
  if (IndexFlushEnabled) {
    inregs.h.ah = 0x68;
    inregs.x.bx = handle;
    intdos(&inregs, &inregs);
  }
#endif
  //#ifndef NET
  //    p->Modified = TRUE;// putting this in the net version
  //#endif                 // results in the krippen bug

  return TRUE;
}
