/* filename: REINDEX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <index.h>
  
void Reindex(void)  // alias ReindexProc
{
  int   i;
  int   AreOpenIndexes = FALSE;
  PUDK_func KeyAddress;
  char  filename[STRSIZ];
  int   usingCache, usingSoundex, usingDescending;
  PIndexType  p;
  unsigned char saveOrder;
#ifdef NDX_TYPE
  int parser = 0;
  char expression[110] = " EXPR=\'";
#endif
  
  if (!*DBF()) { // no database is open
    SetError( NotInUse,2,Database_not_open," [Reindex]");
    assertJumper();
    return;
  }
  for(i = 0; i < MaxOrder; i++)
    AreOpenIndexes |= (Ind[Selected][i] != NULL);
  if (!AreOpenIndexes) {
    SetError(IndexNotOpen, 3, No_open_indexes_with, DBF(), " [Reindex]");
    assertJumper();
    return;
  }
  saveOrder = CurrentOrder(); // 1-based (Pascal-type)
  SetOrderToPrim(0); // lower level version of SetOrderTo()
  DBFError = 0;
  for (i = 0; i < MaxOrder; i++) {
    p = Ind[Selected][i];
    if (p) {
      usingCache = !i && Cache[i];
      usingSoundex = p->SoundexFlag;
      usingDescending = p->Descending;
#ifdef NDX_TYPE
      if ((parser = p->parser) != 0) { // seek to the begining of the file and get DBF- expression
        lseek(p->Ndx, (long)(sizeof(NDXHeader)-sizeof(char*)), SEEK_SET);
        if (read(p->Ndx, &expression[7], 101) != 101) {
          SetError(errno, 2, error_reading_index_file, " [Reindex]");
          assertJumper();
          return;
        }
        strcat(expression, "\'");
        KeyAddress = NULL;
      }
      else
#endif
        KeyAddress = p->KeyMaker;
      // need to temporarily store these, since we are about to close
      // the file: can't make the new file if its already open
      strcpy(filename, IndexName(i));
      CloseOneIndex(Selected, i);
      if (usingSoundex)
        strcat(filename, " SOUNDEX");
      if (usingDescending)
        strcat(filename, " DESCENDING");
#ifdef NDX_TYPE
      if (parser)
        strcat(filename, expression);
      MakeIndexCB(KeyAddress, filename);
      if (!usingCache)
        strcat(filename, " NOCACHE" );
      SetIndexToCB(KeyAddress, filename, (unsigned char)(i+1));// User func not 0-based
#else
      MakeIndex(KeyAddress, filename);
      if (!usingCache)
        strcat(filename, " NOCACHE" );
      SetIndexTo(KeyAddress, filename, (unsigned char)(i+1));
#endif
    }
  }
  SetOrderTo(saveOrder);// both CurrentOrder and SetOrderTo is 1 based end-user function MA
}
  
