/* filename: READANCR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NET
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <index.h>

void ReadAnchorNode(int area, int order)
{
  PIndexType  p;
#ifdef NDX_TYPE
  size_t header_size = sizeof(NDXHeader) - sizeof(char *);
#else
  Node TempNodeBuffer;
#endif

  p = Ind[area][order];
  lseek(p->Ndx, 0, SEEK_SET);
#ifdef NDX_TYPE
  if (read(p->Ndx,&p->header,header_size) != (int) header_size)
#else
    if (read(p->Ndx,&TempNodeBuffer,(size_t)p->NodeSize) != (int) p->NodeSize)
#endif
    {
      SetError(_doserrno, 4, error_reading_index_file," ",
      IndexName(order), " [ReadAnchorNode]");
      assertJumper();
    }
#ifndef NDX_TYPE
  memcpy(&p->Anchor, &TempNodeBuffer, sizeof(HeaderRecordType));
#endif
}
#endif // NET
  
