/* filename: PARSE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>

extern PParseBufferStruct MakeParserHandle;

int ParseExpression(char * fname, char ** db_expr_address)
{// note: db_expr == *(db_expr_address)
  char *start_pos, *end_pos;
  int   s1, s2, len, offset;

  offset = PosOf(1, " EXPR=", fname);
  if (offset < 0)
    return 0;
  start_pos = fname + offset;
  if (CountOf("\'", fname) != 2) {
    SetError(220, 3, Invalid_parameter, ": ", strstr(fname,"EXPR="));
    return -1;
  }
  s1 = PosOf(1, "\'", fname) + 1;
  s2 = PosOf(2, "\'", fname) + 1;
  len = s2-s1;
  if ((*db_expr_address = (char *) malloc(len)) == NULL) {
    SetError(217, 2, Insufficient_memory, " [MakeIndex/ParseExpression]");
    return -1;
  }
  if (--len > MAX_NDX_EXPRESSION_SIZE) {
    SetError(300, 2, NDX_expression_too_big, " [MakeIndex/ParseExpression]");
    return -1;
  }
  memcpy(*db_expr_address, &fname[s1], len);
  (*db_expr_address)[len] = 0;
  MakeParserHandle = AssignExpr(*db_expr_address);
  if (!MakeParserHandle)
    return -1;
  for(end_pos = &fname[s2]; *end_pos != 0; start_pos++, end_pos++)
    *start_pos = *end_pos;
  *start_pos = 0;

  return 0;
}

static int checkKeyExpr(const char *db_expr, BOOL is_key)
{
  int  ret, saveAutoHalt;
  char typ;
  unsigned  save;
  ExprHandle  h;

  if (!db_expr)
    return KeyExprIsNULL;
  if (!*Trim(db_expr))
    return EmptyKeyExpr;
  if (strlen(Trim(db_expr)) > 100)
    return ExprTooLong;

  ret = 0;
  save = MemoGetSize;
  MemoGetSize = 0; // we do not need memo pool here
  saveAutoHalt = AutoHalt;
  AutoHalt = FALSE;
  h = AssignExpr(db_expr);
  AutoHalt = saveAutoHalt;
  if (h) {
    typ = h->ReturnType;
    DisposeExpr(&h);
    if (is_key) {
      if ((typ == 'M') || (typ == 'L'))
        ret = NotValidKeyExpr;
    }
    else
      if (typ != 'L')
        ret = NotLogicalExpr;
  }
  else
    ret = DBFError;
  MemoGetSize = save;
  DBFError = 0; // reset DBFError 
  return ret;
}

int ValidLogicalExpr(const char *db_expr)
{
  return checkKeyExpr(db_expr, FALSE);
}

int ValidKeyExpr(const char *db_expr)
{
  return checkKeyExpr(db_expr, TRUE);
}
#endif // NDX_TYPE
