/* filename: OPENIDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include <sayget.h>
#include <index.h>

unsigned int DefaultIndexCacheSize = DEFAULTCACHESIZE;

int NeverCacheIndexes = FALSE;
extern int OrderChanged;

void SetIndexCacheTo(unsigned size)
{
  if (size > 0xFFE8)
    size = 0xFFE8;
  DefaultIndexCacheSize = size;
}

static int ADfilename(int w_area, int order, char *fname, BOOL create)
{
  char **p = &Ind[w_area][order]->fname;

  if (create) {
    if ((*p = (char*) malloc(strlen(fname)+1)) == NULL)
      return -1;  // InsufficientMemory
    strcpy(*p, fname);
  }
  else
    FreePtrClear((void*) &(*p));
  return 0;
}

static void near deallocCacheAndPseudo(int order, int cacheEnabled)
{
  if (!order) {
    if (cacheEnabled)
      DeallocateCache(Selected);
    DeallocatePseudoNode(Selected);
  }
}

static void near closeNdx(int order, IndexType *p, int cacheEnabled, int flag)
{
  if (flag)
    DeallocateKeyStorage(Selected,order);
  deallocCacheAndPseudo(order, cacheEnabled);
  close(p->Ndx);
  ADfilename(Selected, order, "", FALSE);
  DeallocateInd(Selected, order);
}

#ifdef NDX_TYPE
char *IndexParserEngine(void)
{
  InitEngine(Ind[Selected][SyncPOrder]->pparser);
  BuildNewKey();
  return (char *)GetNewKeyPtr();
}

static void AdjustEOF(PIndexType p, long *eof, int handle, int order)
{
  long b_num;
  PNDXBlock n;

  b_num = lseek(handle, 0L, SEEK_END) / BLOCK_SIZE;
  if (b_num == *eof)
    return;

  if (*eof < b_num && *eof != 0L) {
    if (p->reusable) {
#ifdef NET
      HandleSemaphore((char)Selected, LockSemaphore);
#endif
      GetNode(*eof, order);
      n = p->BlockBufferPtr;
      SqueezeExpression(n->block, 0);
      if (!n->num_keys && !n->modified
        && strcmp(n->block, SqueezeExpression(SSI_TOKEN, 0))==0)
        return;
      goto locked; // this is to skip unlocking-locking semaphore
    }
  }
#ifdef NET
  HandleSemaphore((char)Selected, LockSemaphore);
#endif

locked:
  *eof = b_num;
  p->Modified = 1;
  WriteAnchorNode(Selected, order);
#ifdef NET
  HandleSemaphore((char)Selected, UnlockSemaphore);
#endif
}
#endif // NDX_TYPE

void OpenIndex(PUDK_func udk, const char * fname, int order,
              int cacheEnabled, int soundex, int descending, char *expr)
{
  int   i;
  FILE *testfile;
  long  TempRecNo;
  int   saveOrder, k_len;
  char  tempkey[101], filename[100];
  PIndexType p;
#ifdef NDX_TYPE
  PParseBufferStruct pparser = NULL;
  int   parse = FALSE;
  IndexType current_ndx;
  char  expression[100];
#else
  long  CheckRecCount;
  char  ErrorStr[80];
#ifdef NET
  Node  saveNode;
#endif
#endif

#ifdef NDX_TYPE
  if (!udk)
    parse = TRUE;
  strcpy(filename, AddExt(fname, "NDX"));
#else
  strcpy(filename, AddExt(fname, "IND"));
#endif

  CheckForAlreadyOpenIndex(filename, FALSE, order);
  if (DBFError)
    return;
  // do not use p here
  if (Ind[Selected][order]) {
    SetError(254, 2, internal_error, ind_pointer_already_allocated);
    goto JUMPER;
  }
#ifdef NET
  testfile = _fsopen(filename, "rb+", MultiUser ? SH_DENYNO : SH_DENYRW);
#else
  testfile = fopen(filename, "rb+");
#endif
  if (!testfile) {
    SetError(_doserrno, 3, unable_to_open_index, filename, unable_to_open_index2);
    goto JUMPER;
  }
#ifdef NDX_TYPE
  memset(&current_ndx, 0, sizeof(IndexType));
#ifdef NET
  if (MultiUser)
    HandleSemaphore((char)Selected, IncRead);
#endif
  fread(&(current_ndx.header), sizeof(NDXHeader) - sizeof(char *), 1, testfile);
  fread(expression, sizeof(expression), 1, testfile);
#ifdef NET
  if (MultiUser)
    HandleSemaphore((char)Selected, DecRead);
  current_ndx.Ndx = -1;
  if (Semaphore[Selected])
    current_ndx.reusable = FALSE;
  else
    current_ndx.reusable = ReusableBlocks;
#else
  current_ndx.Ndx = -1;
  current_ndx.reusable = ReusableBlocks;
#endif
  SqueezeExpression(expression, 0);
  if (parse) {
    if (!strcmp(expression, SqueezeExpression(SSI_TOKEN,0))) {
      fclose(testfile);
      SetError(223, 4, You_should_use_KeyMaker_comma_, filename,
                      _has_been_created_using_, user_defined_KeyMaker);
      goto JUMPER;
    }
	  pparser = AssignExpr(expression); // call to the parser
    if (!*expression || !pparser) {
      fclose(testfile);
      SetError(222,2,Wrong_dbf_expression_or_corrupted_index_file_, filename);
      goto JUMPER;
    }
    if (expr)
      if (strcmp(expression, SqueezeExpression(expr,0))) {
        fclose(testfile);
        SetError(222,7,Expression_in_SetIndexTo_differs_from_that_in_,
        filename, _header,".\n", expr, "\n  vs\n", expression);
        goto JUMPER;
      }
      current_ndx.parser = TRUE;
      current_ndx.KeyMaker = IndexParserEngine;
      switch( current_ndx.header.type ) {
        case 'C': // string
          current_ndx.cmp = memcmp;
          break;
        case 'D': // date keys
        case 'F': // numeric keys
        case 'N':
          current_ndx.cmp = double_compare;
          break;
        default:
          SetError(222, 1, " [SetIndexTo/OpenIndex]");
          goto JUMPER;
      }
  }
  else { // user defined key maker
    if (strcmp(expression, SqueezeExpression(SSI_TOKEN,0))) {
      fclose(testfile);
      SetError(223,4,You_should_not_use_KeyMaker_comma_, filename,
                    _has_been_created_using_, a_dBASE_expression);
      goto JUMPER;
    }
    current_ndx.KeyMaker = udk;
    current_ndx.SoundexFlag = soundex;
    current_ndx.Descending = descending;
    current_ndx.cmp = memcmp; //for KeyMaker keys are character strings
  }
#endif // NDX_TYPE
  if (fclose(testfile) == EOF) {
    SetError(_doserrno, 2, error_closing_index_file, filename);
    goto JUMPER;
  }
  if ((Ind[Selected][order] = (PIndexType)malloc(sizeof(IndexType))) == NULL)
    goto nomem;
  p = Ind[Selected][order];
  memset(p, 0, sizeof(IndexType));
#ifdef NDX_TYPE
  memcpy(p, &current_ndx, sizeof(IndexType));
  p->kiss = p->header.type == 'C';// key is of string type

  if (parse) {
    p->pparser = (PParseBufferStruct)malloc(sizeof(ParseBufferStruct));
    if (!p->pparser) {
      DeallocateInd(Selected,order);
      goto nomem;
    }
    p->header.expression = pparser->Expression;
    memcpy(p->pparser, pparser, sizeof(ParseBufferStruct));
    memset(pparser, 0, sizeof(ParseBufferStruct)); // clean up pointers
    DisposeExpr(&pparser);
  }
  else {
    if ((p->header.expression = (char *) malloc(strlen(expression)+1)) == NULL)
      goto nomem;
    strcpy(p->header.expression, expression);
  }
#endif

  p->BlockBufferPtr = &p->BlockBuffer;

  // If this is a primary index (order == 0), allocate memory for
  // the cache, and the pseudonode:
  if (!order) {
    if ((PseudoNode[Selected] = (PNode)malloc(sizeof(Node))) == NULL) {
      DeallocateInd(Selected,order);
      goto nomem;
    }
    memset(PseudoNode[Selected], 0, sizeof(Node));
    if (Cache[Selected]) {
      DeallocatePseudoNode(Selected);
      DeallocateInd(Selected,order);
      SetError(254, 2, internal_error, cache_already_allocated);
      goto JUMPER;
    }
#ifdef NDX_TYPE
    PseudoNode[Selected]->DBFRecNo = -1; // set PseudoNode indicator
    if ((p->path = malloc(sizeof(Path))) == NULL) {
      DeallocatePseudoNode(Selected);
      DeallocateInd(Selected,order);
      goto nomem;
    }
    memset(p->path,0,sizeof(Path));
    p->cpath = p->path;
    p->path->counter = -1;
    if (!NeverCacheIndexes && cacheEnabled)
      SetCacheTo(DefaultIndexCacheSize); // now set to 32K
    else
      SetCacheTo(0);
#else
    if (!NeverCacheIndexes && cacheEnabled)
      SetCacheTo(DefaultIndexCacheSize, filename); // now set to 32K
    else
      SetCacheTo(0, filename);
#endif
  }

  SaveInd[Selected][order] = p;

#ifndef NDX_TYPE
  p->Modified = FALSE;
  p->SoundexFlag = soundex;
  p->Descending = descending;
  p->NodeSize = (long) GetNodeSize(filename, ErrorStr);
  if (!p->NodeSize || DBFError) {
    i = DBFError;
    deallocCacheAndPseudo(order, cacheEnabled);
    DeallocateInd(Selected,order);
    p = NULL;
    if (i)
      SetError(i, 1, ErrorStr);
    else
      SetError(CorruptedFile,3,index_file_corrupted, filename,Invalid_node_size);
    goto JUMPER;
  }
  p->KeyMaker = udk;
#endif

#ifdef NET
  i = (int) (MultiUser ? SH_DENYNO : SH_DENYRW);
#else
  i = (int) SH_DENYRW;
#endif
  p->Ndx =  sopen(filename, O_BINARY | O_RDWR, i, S_IREAD| S_IWRITE);
  if (p->Ndx < 0) {
    i = _doserrno;
    deallocCacheAndPseudo(order, cacheEnabled);
    DeallocateInd(Selected,order);
    SetError(i, 2, error_opening_index_file, filename);
    goto JUMPER;
  }
  if (ADfilename(Selected, order, filename, TRUE))
    goto nomem;
#ifdef NDX_TYPE
  k_len = p->header.key_len;
#else
  // read the header into nodebuffer, and copy the necessary bytes into the anchor
  if (read(p->Ndx, &p->NodeBuffer, (size_t)p->NodeSize) != (int) p->NodeSize)
  {
    i = _doserrno;
    closeNdx(order, p, cacheEnabled, 0);
    SetError(i, 2, error_reading_index_file, filename);
    goto JUMPER;
  }
  memcpy(&p->Anchor,&p->NodeBuffer,sizeof(HeaderRecordType));
  // usually EOF and BOF are FALSE, but in the
  // case of an empty file (where FirstRec=LastRec=0),
  // these flags need to be TRUE
  p->BOFFlag = p->Anchor.FirstRec == 0;
  p->EOFFlag = p->Anchor.LastRec == 0;
  k_len = p->KeyLength = p->Anchor.KeyLength;
#endif
  if ((p->KeyStorage = (char *)malloc(k_len+1)) == NULL) {
    p->KeyStorage = NULL;
    closeNdx(order, p, cacheEnabled, 0);
    goto nomem;
  }
  memset(p->KeyStorage, 0, k_len+1);
#ifdef NDX_TYPE
  saveOrder = SyncOrder;
  SyncOrder = order;
  if (RecCount()) {// do the keylengths match?
    SyncPOrder = order; // for parser
    memcpy(tempkey, FarKey(order), k_len+1);
  }
  else { // we opened an empty DBF ...
    p->BOFFlag = p->EOFFlag = 1; // Set flags
    if (p->kiss) {
      memset(tempkey, ' ', k_len);
      tempkey[k_len] = 0;
    }
    else
      memset(tempkey, 0, k_len);
  }
  if (strlen(tempkey) != (size_t) k_len && p->kiss)
#else
    if (p->Anchor.Version != 0x5431) {
      closeNdx(order, p, cacheEnabled, 1);
      SetError(WrongVersion, 1, filename);
      goto JUMPER;
    }
  p->Index = &p->NodeBuffer;
  saveOrder = SyncOrder;
  SyncOrder = order;
#ifdef NET
  // if multi-user then this next test for matching nodes to records
  // must be done with index locked!
  HandleSemaphore((char)Selected, IncRead);
  lseek(p->Ndx, 0, SEEK_SET);
  read(p->Ndx, &saveNode, (size_t)p->NodeSize);
  memcpy(&p->Anchor, &saveNode, sizeof(HeaderRecordType));
#endif
  CheckRecCount = RecCount();
#ifdef NET
  HandleSemaphore((char)Selected, DecRead);
#endif
  if (p->Anchor.TotalLiveNodes != CheckRecCount) {
    closeNdx(order, p, cacheEnabled, 1);
    SetError(CorruptedFile,6,index_file_corrupted,"\r\n",
    record_count_mismatch_between,filename,space_and_space,DBF());
    goto JUMPER;
  }
  // do the keylengths match?
  memcpy(tempkey, FarKey(order), k_len+1);
  if (strlen(tempkey) != (size_t) k_len)
#endif // NDX_TYPE
  {   // error condition
    closeNdx(order, p, cacheEnabled, 1);
    SetError(BadSize,11,incorrect_key_length_returned_by_user_defined_keymaker,
    "\r\n",expected_length,SInteger(k_len,3),"\r\n",key_equals,
    "[",tempkey,"] ",filename," [SetIndexTo/OpenIndex]");
    goto JUMPER;
  }
#ifdef NDX_TYPE
  AdjustEOF(p, &p->header.eof, p->Ndx, order);
  lseek(p->Ndx, 0L, SEEK_SET);
#endif
  OrderChanged = 1;
  // get the EOF and BOF keys..this is simple if there are records
  // in the file, but a special case is the empty DBF
  if (RecCount()) { // DBF not empty
    // do a "go" based on the result of "FindFirstRec"
    if (!order) { // don't move database if index is secondary
      TempRecNo = FindFirstRecFunc();
      RawGo(TempRecNo);
      // check to see if record is valid
      while (!ValidRec() && !p->EOFFlag)
        RawGo(FindNextRecFunc()); // go to the record, "skip"
    }
#ifdef NDX_TYPE
    SyncPOrder = order; // for parser
    memcpy(p->KeyStorage, FarKey(order), k_len+1);
  }
  else { // DBF is empty
    GetNode(1L, order);
    if (!order) { // initialize path
      p->path->counter = 0;
      p->path->blockno[0] = 1;
      memset(p->path->blocks, 0, BLOCK_SIZE);
    }
  }
#else
    memcpy(p->KeyStorage, FarKey(order), k_len+1);
  }
  else // DBF is empty
    GetNode(1L, order);
#endif
  SyncOrder = saveOrder;
  return;

nomem:
  SetError(InsufficientMemory, 2, insufficient_memory_to_open_index, filename);
JUMPER: // error exit point
  if (expr)
    filename[0] = *expr; // to avoid a compiler warning only
#ifdef NDX_TYPE
  DisposeExpr(&pparser);
#endif
  return;
} // OpenIndex

