/* filename: NETLOG.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef NETLOG
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dos.h>
#include <share.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include <dbf.h>
#include <index.h>

#define logfilename "NETLOG.TXT"

int Sflog = 0; // log file handle

void WriteLog(const char * s)
{
  char  x[STRSIZ];
  union REGS inregs;
  size_t len;

  do {
    printf("*");
  } while (LockUnlock(0, Sflog, 1, 1));
  sprintf(x, "%ld [%s] %s\r\n", *BiosTimerTicks, getenv("USER"), s);
  lseek(Sflog, 0L, SEEK_END);
  len = strlen(x);
  if (write(Sflog, x, len) != len) {
    SetError(_doserrno, 1, " [WriteLogFile]");
    return;
  } // flush file
  inregs.h.ah = 0x68;
  inregs.x.bx = Sflog;
  intdos(&inregs, &inregs);
  LockUnlock(1, Sflog, 1, 1);
}

void OpenLogFile(void)
{
  char s[STRSIZ];

  if (FileExists(logfilename))
    Sflog =  sopen(logfilename, O_BINARY | O_RDWR, SH_DENYNO,
    S_IREAD | S_IWRITE);
  else // create a file
    Sflog = sopen(logfilename, O_CREAT | O_TRUNC | O_BINARY | O_RDWR,
    SH_DENYNO, S_IREAD | S_IWRITE);
  if (Sflog < 0) {
    SetError(_doserrno, 2, logfilename," [OpenLogFile]");
    return;
  }
  errno = _doserrno = 0;
  sprintf(s,"%ld [%s] LOG OPENED\r\n", *BiosTimerTicks, getenv("USER"));
  if (write(Sflog, s, strlen(s)) != strlen(s)) { // rearly called
    SetError(_doserrno, 1, " [WriteLogFile]");
    return;
  }
}
#endif
  
