/* filename: NDXEXPR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <index.h>
#ifdef NDX_TYPE
#include <string.h>
#include <io.h>
#include <sayget.h>
#include <dbf.h>

char *GetIndexExpr(int order)
{
  static char _tzfar expression[101];

  if (NotInUseError("NDXExpr"))
    return "";
  return Ind[Selected][order] ?
  strcpy(expression, Ind[Selected][order]->header.expression) : "";
}

void SetIndexExpr(const char *expr, int order)
{
  long curpos, offset;
  int handle;
  char expression[151], *errptr;
  PIndexType p;

  if (order > MaxOrder || order < 1) {
    DBFError =InvalidParameter;
    errptr = invalid_index_order_specified;
    goto errout;
  }
  if (!*expr)
    return;
  p = Ind[Selected][--order];    // make order 0 based
  memcpy(expression, expr, 150);
  expression[150] = 0;
  SqueezeExpression(expression, 0);
  if (p) {
    handle = p->Ndx;
    offset = (long)(sizeof(NDXHeader) - sizeof(char *));
#ifdef NET
    if (!IsExclusive()) { // lock and unlock the file
      DBFError = LockUnlock(0, handle, 0L, 1L);
      if (DBFError) {
        errptr = Could_not_lock_index_for_writing_anchor_node;
        goto errout;
      }
    }
#endif
    curpos = tell(handle);
    lseek(handle, offset, SEEK_SET);
    if (write(handle, expression, 101) != 101) {
      DBFError = errno;
      errptr = error_writing_index_file;
      goto errout;
    }
    lseek(handle, curpos, SEEK_SET);
#ifdef NET
    if (!IsExclusive()) { // lock and unlock the file
      DBFError = LockUnlock(1, handle, 0L, 1L);
      if (DBFError) {
        errptr = Could_not_unlock_index_after_writing_anchor_node;
        goto errout;
      }
    }
#endif
  }
  return;

errout:
  SetError(DBFError, 2, errptr, IndexName(order));
}
#endif // NDX_TYPE
  
