/* filename: MEMOFLD.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <memo.h>
#include <parser.h>
  
void PushMemo(PParseBufferStruct P, PStackNode Sptr, void *Data)
{
  MemoFile *M;
  char line[STRSIZ], *ptr, *pool_edge;
  size_t len;
  
  Sptr->type.C = P->WorkingPoolPtr;
  pool_edge = P->WorkingPool + P->WorkingPoolSize;
  if ((M = OpenMemo(Data, "r")) == NULL)
    return;
  while(!EOFMemo(M)) {
    len = strlen(ReadMemo(M, line));
    if (P->WorkingPoolPtr + len >= pool_edge) {
      for(ptr = line; *ptr != 0; ptr++) {
        if (P->WorkingPoolPtr + 1 >= pool_edge) {
          *P->WorkingPoolPtr++ = 0;
          CloseMemo(M);
          return;
        }
        *P->WorkingPoolPtr++ = *ptr;
      }
    }
    else {
      memcpy(P->WorkingPoolPtr, line, len);
      P->WorkingPoolPtr += len;
    }
  }
  *P->WorkingPoolPtr++ = 0;
  CloseMemo(M);
  return;
}
