/* filename: MAKENDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <setjmp.h>
#include <fcntl.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <sayget.h>

#define BUFSIZE 258 //path + clauses + expression

typedef struct
{
  int      ds_num; // number of the related disk spool (0-based)
  long     f_pos;  // current file position
  char    *buffer; // pointer to data read from disk
  unsigned length; // length of data read from disk
  unsigned b_pos;  // current buffer position
} MemSpool, *PMemSpool;

typedef struct
{
  int  group_len;// key group length (key_len plus 8 padded to a multiple of 4)
  int  key_len;  // length of the search key expression
  int  keys_max; // maximum number of keys per block
  PNDXBlock stack;// pseudo stack pointer: start of allocated memory for index blocks
  int  stack_height;// here is the # of (allocated) pseudo stack blocks
} ReindexData, *PReindexData;

int  build_index(PIndexType);
int  ParseExpression(char * fname, char ** db_expr_address);
int  double_compare(const void *, const void *, size_t);
char *MakeParserEngine(void);

extern PParseBufferStruct MakeParserHandle;

void MakeIndexCB(PUDK_func udk, const char *fname)
{
  PNDXHeader ci_header;
  PIndexType curr_index = NULL;
  char buf[BUFSIZE], *db_expr = NULL, *errstr, buf1[128];
  int  parser_used = 0;
  int soundex, descending;
  int  saveSelected, k, j, errid = 0;
  char delimiter, *cp1, *cp2, *cp;

  if (!CheckRegisteredUnits("MakeIndex", REGTZCOMMON+REGTZDBF+REGTZINDEX))
    return;
  DBFError = 0;
  MakeParserHandle = 0;
  memcpy(buf, fname, BUFSIZE);
  *(buf + BUFSIZE - 1) = 0;
  cp1 = strchr(buf,39); // single quote
  cp2 = strchr(buf,34); // double quote
  if (cp1 || cp2) {
    if (cp1 && cp2)
      delimiter = (cp1 < cp2) ? 39 : 34;
    else
      delimiter = cp1 ? 39 : 34;
    cp1 = strchr(buf,delimiter);
    cp2 = strrchr(buf,delimiter);
    *cp1 = *cp2 = 39;
    for (cp = cp1 + 1; cp < cp2; cp++)
      if (*cp == 39)
        *cp = 34;
  }
  SqueezeExpression(buf, 1);
  if (!*buf) {
    errid = InvalidParameter;
    errstr = index_filename_not_specified;
    goto BAILOUT;
  }
  if (ParseExpression(buf, &db_expr))
    goto BAILOUT;
  // get rid of the clauses(SOUNDEX, NOCACHE, DESCENDING) in the file name
  soundex = (strstr(buf, " SOUNDEX") != NULL);
  descending = (strstr(buf, " DESCENDING") != NULL);
  errstr = strchr(buf, ' ');
  if (errstr)
    *errstr = 0;
  strcpy(buf, AddExt(buf, "NDX"));
  if (!*DBF()) {
    errid = NotInUse;
    sprintf(buf1, "%s%s", database_not_open_attempting_to_index_to, buf);
    errstr = buf1;
    goto BAILOUT;
  }
#ifdef NET
  if (!IsExclusive()) {
    errid = ExclusiveUseRequired;
    sprintf(buf, "%s %s", DBF(), fname);
    errstr = buf;
    goto BAILOUT;
  }
#endif
  // check that an index file of the filename specified is not already open:
  saveSelected = Selected;
  for(Selected = 0; Selected < HelpWorkArea; Selected++)
    for(j = 0; j < MaxOrder; j++)
      if (strcmp(IndexName(j), buf) == 0) {
        errid = AlreadyInUse;
        errstr = buf;
        goto BAILOUT;
      }
  Selected = saveSelected;
  if (db_expr) { // let DBF_Expression be of higher priority
    descending = soundex = 0;
    parser_used = TRUE;
    udk = MakeParserEngine; // initialize udk to parser_engine
  }
  if (!udk) {
    errid = 254;
    errstr = Both_expression_and_KeyMaker_are_NULL;
    goto BAILOUT;
  }
  // now create the actual index file
  curr_index =  (PIndexType) malloc(sizeof(IndexType));
  if (!curr_index) {
    errid = InsufficientMemory;
    errstr = "";
    goto BAILOUT;
  }
  memset(curr_index, 0, sizeof(IndexType));
  curr_index->Ndx =  open(buf,
  (int) (O_CREAT|O_TRUNC|O_BINARY|O_RDWR)|SH_DENYRW, S_IREAD|S_IWRITE);
  if (curr_index->Ndx < 0) {
    errid = _doserrno;
    sprintf(buf1, "%s %s", File_not_open, buf);
    errstr = buf1;
    goto BAILOUT;
  }
  curr_index->fname       =  buf;
  curr_index->parser      =  parser_used;
  curr_index->KeyMaker    =  udk;
  curr_index->SoundexFlag =  soundex;
  curr_index->Descending  =  descending;

  ci_header = &curr_index->header;
  ci_header->unique = UniqueOn;
  ci_header->expression = db_expr;
  ci_header->eof = 2L;
  ci_header->root = 1L;
  ci_header->type = 'C'; // let's assume...
  if (parser_used) {
    curr_index->cmp = double_compare;
    switch (MakeParserHandle->ReturnType) {
      case 'C': curr_index->cmp = memcmp; break;
      case 'D': ci_header->type = 'D'; break;
      case 'F': ci_header->type = 'F'; break;
      case 'N': ci_header->type = 'N'; break;
      default:
        errid = InvalidParameter;
        errstr = Wrong_ParserReturnType;
        goto BAILOUT;
    }
  }
  else
    curr_index->cmp = memcmp;
  if (!parser_used && soundex)
    k = SoundexLength;
  else {
    if (ci_header->type == 'C')
      k = strlen(curr_index->KeyMaker());
    else
      k = sizeof(double);
  }
  ci_header->key_len = k;
  if ((k < 0) || (k > 100)) {
    errid = 254;
    errstr = incorrect_key_length_returned_by_user_defined_keymaker;
    goto BAILOUT;
  }
  // index_header.group_len = Key length plus 8 padded to a multiple of 4,
  // that is actually sizeof(long)
  j = sizeof(long) - k % sizeof(long);
  if (j == 4)
    j = 0;
  ci_header->group_len = k + 2*sizeof(long) + j;
  ci_header->num_or_date = ci_header->type != 'C';
  curr_index->kiss = !ci_header->num_or_date; // Key IS String
  // index_block = short number_of_keys + short pad up to 4; + key_groups;
  // + long block_number if branch block.
  ci_header->keys_max = (BLOCK_SIZE - 2*sizeof(long)) / ci_header->group_len;

  build_index(curr_index);
BAILOUT:
  DisposeExpr(&MakeParserHandle);
  FreePtrClear((void*) &db_expr);
  if (curr_index) {
    if (curr_index->Ndx > 0)
      close(curr_index->Ndx);
    free(curr_index);
  }
  if (errid)
    SetError(errid, 2, errstr, " [MakeIndex]");
}

#endif // NDX_TYPE
