/* filename: MAKEIDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifndef NDX_TYPE
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <setjmp.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#ifndef _MSC_VER
 #include <alloc.h>
#else
 #include <malloc.h>
#endif
#include <share.h>
#include <sayget.h>
#include <dbf.h>
#ifdef WINDOWS
 #include <windows.h>
#endif

#define SecSize   128
#define UserStack 2000
#define MaxStack  20
//  Log2(MaxKeys) = MaxStack,
// i. e. for MaxStack = 20 it is possible to sort 1 million records

typedef struct KeyRecordType {
  long    RecNum;        // Length must be 128 bytes
  char    Key[124];      // never change this !!!
} KeyRecordType;

static IndexType *TempInd = NULL;

static size_t node_size = 0, node_count = 0,
max_index = 0, cache_size = 0, keys_cached = 0;
static Node   _tzfar NodeData = {0L};
static char   _tzfar Pagefilename[80]  = "843~~567.$$$", *Rbuffer = NULL;
static int    soundexFlag=0, descending=0;
static int    KeyLen=0;
static int    FileHandle = -1, PFHandle = -1;
static int    Pages = 0;   // 0..10
static int    Pages_1 = 0; // Pages minus 1
static int    NDivB = 0, NModB = 0;
static int    PageModified[11] = {0};
static int    FileCreated = 0;   //  pagefile written
static int    SKError=0;
static long   rec_count;
static long   MaxKeys = 0L;
static long   SectorsPerPage=0L; //  MaxKeys Mod KeysPerPage
static long   Page[11] = {0L};
static long   IndexSize = 0L;
static long   MIWorkArea;
static void  *Buffer[11] = {NULL};

static unsigned  PageSize;
static unsigned  KeysPerPage = 0U;
static unsigned  KeyRecordSize=0U;  //  Length of record
static KeyRecordType  _tzfar KeyRec = {0L}, _tzfar PriorKeyRec= {0L}, *SaveZ, *SwopPost;
static unsigned long  node_offset = 1;
static long u1, u2, wh;

static void near WritePage(void * addr, long pageno)
{
  lseek(PFHandle, (long)(pageno * PageSize), SEEK_SET);
  if (write(PFHandle, addr, (size_t)PageSize) != (int) PageSize) {
    SetError(++SKError, 2, Write_error_disk_full, " [MakeIndex]");
    assertJumper();
  }
}

static void near _pascal FetchPageAddr(KeyRecordType ** adr)
{
  int u1page, u2page;
  int InMem = FALSE;
  register int  selected, whichpage; //  0..10

  whichpage = (int)(wh / KeysPerPage);
  for(selected = 0; selected < Pages; selected++)
    if (whichpage == (int) Page[selected]) {
      InMem = TRUE;
      break;
    }
  // InMem is true if record wh is in memory
  if (!InMem) { //  Record not in memory
    selected = 0;
    u1page = (int)(u1 / KeysPerPage);
    u2page = (int)(u2 / KeysPerPage);
    for(selected = Pages-1; (Page[selected] == u1page) || (Page[selected] == u2page); selected--);
    // Page[SelectedPage] not in U
    if (PageModified[selected])
      WritePage(Buffer[selected], Page[selected]);
    // Read page PageNo into memory at address Addr
    lseek(PFHandle, (long)whichpage * PageSize, SEEK_SET);
    if (read(PFHandle, Buffer[selected], (size_t)PageSize) < (int)PageSize) {
      SKError = 213; // partial read error
      SetError(SKError,2,error_reading_sort_page," [MakeIndex]");
      assertJumper();
    }
    Page[selected] = whichpage;
    PageModified[selected] = FALSE;
  }
  *adr = (KeyRecordType *)((char *)Buffer[selected] + (unsigned)(wh % (long)KeysPerPage) * KeyRecordSize);
}

static void QuickSort(void)
{
  register int     stackptr;
  long             LeftStack[MaxStack]; // Stack of left index
  long             RightStack[MaxStack]; // Stack of right index
  long             m, x;
  register long    i, j, l, r;
  KeyRecordType    *XAddr, *YAddr, *ZAddr, *IAddr, *JAddr;
  int                      k, ll, klen;

  klen = KeyLen + 2;
  // The quicksort algorithm
  if (MaxKeys > 0) {
    LeftStack[0] = 0L;
    RightStack[0] = MaxKeys - 1L;
    stackptr = 1;
  }
  else
    stackptr = 0;
  while (stackptr > 0) {
#ifndef WINDOWS
    if (RotorEnabled)
      AdvanceRotor(); // spin the rotor if enabled
#endif
    l = LeftStack[--stackptr];
    r = RightStack[stackptr];
    do {
      u1 = i = l;
      u2 = j = r;
      wh = m = (i + j) >> 1;
      // get M, hold I and J  and  record M in memory
      FetchPageAddr(&ZAddr);
      memcpy((void *)SaveZ,(void *)ZAddr,KeyRecordSize);
      u2 = m;
      do { // get I, hold J and M and I and M in memory
        wh = i;
        u1 = j;
        FetchPageAddr(&XAddr);
        while(memcmp(XAddr->Key, SaveZ->Key, klen) < 0) {
          wh = ++i;
          FetchPageAddr(&XAddr);
        }
        wh = j;
        u1 = i;
        FetchPageAddr(&YAddr);
        while (memcmp(SaveZ->Key, YAddr->Key, klen) < 0) {
          wh = --j;
          FetchPageAddr(&YAddr);
        }
        if (i <= j) { // I, J and M in memory
          if (i != j) { // exchange(i,j);
            x = i / KeysPerPage;
            for (k = 0; Page[k] != x; k++);
            x = j / KeysPerPage;
            for (ll = 0; Page[ll] != x; ll++);
            IAddr = (KeyRecordType *)((char *)Buffer[k] + (unsigned)(i % KeysPerPage) * KeyRecordSize);
            JAddr = (KeyRecordType *)((char *)Buffer[ll] + (unsigned)(j % KeysPerPage) * KeyRecordSize);
            memcpy((void *)SwopPost, (void *)IAddr,KeyRecordSize);
            memcpy((void *)IAddr, (void *)JAddr,KeyRecordSize);
            memcpy((void *)JAddr, (void *)SwopPost,KeyRecordSize);
            PageModified[k] = PageModified[ll] = TRUE;
          }
          ++i;
          --j;
        }
      }  while(i <= j);
      if (j - l < r - i) { // Push longest interval on stack
        if (i < r) {
          LeftStack[stackptr] = i;
          RightStack[stackptr++] = r;
        }
        r = j;
      }
      else {
        if (l < j) {
          LeftStack[stackptr] = l;
          RightStack[stackptr++] = j;
        }
        l = i;
      }
    }  while (l < r);
  }
} // QuickSort

static void near _pascal GetKey(KeyRecordType * keyrec, long n)
{
  KeyRecordType * address;

  if ((unsigned long) n > (unsigned long) rec_count) {
    SKError = InternalError;
    SetError(InternalError, 2, (n < 0) ? Sequence_Number_less_than_0 :
    Sequence_Number_greater_than_Max, "[MakeIndex/IndexOn]");
    assertJumper();
  }
  else {
    wh = n; // u1 and u2 are set before the first call of WriteNodes()
    FetchPageAddr(&address);
    memcpy(keyrec, address, KeyRecordSize);
  }
} // GetKey

static void near HiddenSetError(void)
{
  SetError(SKError, 3, (SKError == InsufficientMemory) ?
  Stack_too_small_to_build_index :
  error_writing_index_file, IndexName(1),". [MakeIndex]");
  assertJumper();
}

#pragma optimize ("",off)
static void _pascal near WriteNodes(long a, long b,
unsigned long RootIndexRec, unsigned long PriorIndexRec)
{
  long CurrentSLRec, LeftIndexRec, RightIndexRec;
  unsigned _SPtr, curr_offset;

  _asm mov _SPtr, SP;
  if (_SPtr < 50) {
    SKError = InsufficientMemory;
    HiddenSetError();
    return;
  }
  // of the three conditions below, only the first is probably needed
  // or (a<1) or (b>TempInd->Anchor.TotalLiveNodes)
  if (a > b)
    return;
  CurrentSLRec = (a + b) >> 1;
  // now look for the case of identical keys
  LOOP:
  GetKey(&KeyRec, CurrentSLRec-1);
  if (CurrentSLRec != a) {
    GetKey(&PriorKeyRec, CurrentSLRec-2);
    // are the keys identical?
    if (memcmp(PriorKeyRec.Key, KeyRec.Key, KeyLen) == 0) { // try again
      --CurrentSLRec;
      goto LOOP;
    }
  }
  NodeData.DBFRecNo = KeyRec.RecNum;
  memcpy(NodeData.Key, KeyRec.Key, KeyLen);
  // index size i think can be replaced by filesize(ndx)
  LeftIndexRec = (a > CurrentSLRec - 1) ? 0 : (++IndexSize);
  RightIndexRec = (CurrentSLRec + 1 > b) ? 0 : (++IndexSize);

  NodeData.Entry = RootIndexRec;
  NodeData.GrtrNode = RightIndexRec;
  NodeData.LessNode = LeftIndexRec;
  NodeData.PreviousNode = PriorIndexRec;

  if (++node_count == max_index) { // cache is full, flush it now
    node_count = keys_cached = 0;
    lseek(FileHandle, (long)(node_offset*node_size), SEEK_SET);
    if (write(FileHandle, Rbuffer, cache_size) != (int) cache_size) {
      SKError = 300;
      HiddenSetError();
      return;
    }
    node_offset += max_index;
    // now load next page - probably it has valid nodes written ahead
    lseek(FileHandle, (long)(node_offset*node_size), SEEK_SET);
    if (read(FileHandle, Rbuffer, cache_size) == -1) {
      SKError = 300;
      HiddenSetError();
      return;
    }
  }
  if ((RootIndexRec < node_offset) ||
  (RootIndexRec >= node_offset+max_index)) {
    lseek(FileHandle, (long)(RootIndexRec*node_size), SEEK_SET);
    if (write(FileHandle, &NodeData, node_size) != (int) node_size) {
      SKError = 300;
      HiddenSetError();
      return;
    }
  }
  else {
    curr_offset = (unsigned) (RootIndexRec-node_offset);
    memcpy(&Rbuffer[curr_offset*node_size], &NodeData, node_size);
    // keep the max value for the last flush of the cache buffer
    if (keys_cached <= curr_offset)
      keys_cached = curr_offset+1;
  }
#ifndef WINDOWS
  if (RotorEnabled)
    AdvanceRotor(); // spin the rotor if enabled
  if (Odometer)
    printf("\r%5ld", RootIndexRec);
  if (ProgressPtr)
    ProgressPtr();
#endif // not WINDOWS
  // compute the left and right branches
  WriteNodes(a, CurrentSLRec-1, LeftIndexRec, RootIndexRec); // lesser node
  WriteNodes(CurrentSLRec+1, b, RightIndexRec, RootIndexRec); // greater node
}
#pragma optimize ("",on)

static void SortKeys(char *(*keymaker)(void))
{
  WorkAreaType *wa;
  FieldRecord  *f;
  dbfRecord    *r;
  void *address, *Roffset;
  char  S[21], tmp[21], *key_1, *key_tail, *SaveCurRecPtr;
  int   n, ii, t, lastloop = FALSE;
  long  Mrecnum, i;
  unsigned  key_seq = 0, bytesread, k, offset1, buf_size;
  register unsigned count;

  SKError = 0; // initialize parameter value
  KeyRecordSize = KeyLen + 7; //7;   // 4 + 1 + 2
  /* why 2?, for the record number--has to do with
  making sure that duplicate keys wind up in natural order */
  if (KeyRecordSize < 8) {
    SKError = 216; // Illegal KeyRecordSize  (BadSize)
    SetError(SKError,2,Illegal_key_length_detected_while_sorting_keys," [MakeIndex]");
    assertJumper();
    return;
  }
  wa = WorkArea[Selected];
  r = &wa->Handle;
  if ((SwopPost = malloc((size_t)KeyRecordSize)) == NULL) {
    SetError(217, 3, Insufficient_memory_to_sort_keys, IndexName(1), "SwopPost" );
    assertJumper();
    return;
  }
  memset( SwopPost, 0, (size_t)KeyRecordSize );
  if ((SaveZ = malloc((size_t)KeyRecordSize)) == NULL) {
    SetError( 217, 3, Insufficient_memory_to_sort_keys, IndexName(1), "SaveZ" );
    assertJumper();
    return;
  }
  memset(SaveZ, 0, (size_t) KeyRecordSize);
#ifdef WINDOWS
  MIWorkArea = GetFreeSpace(0) - UserStack;
#else
  MIWorkArea = coreleft() - UserStack;
#endif
  // deal with environment that has more than 576k free such as in Windows
  if (MIWorkArea > 0x90000L)
    MIWorkArea = 0x90000L;
  gototo:
  // Total number of pages in memory
  Pages = (int)(MIWorkArea>>16) + 1;
  if (Pages < 3)
    Pages = 3;
  SectorsPerPage = (MIWorkArea / SecSize) / Pages;
  if (SectorsPerPage > 20)
    SectorsPerPage &= 0xFFFC;

  i = SectorsPerPage * SecSize;
  while (i > 0xFFE8L) { // maximum for malloc (MSC 7.0)
    SectorsPerPage -= 4L;
    i = SectorsPerPage * SecSize;
  }
  PageSize = (unsigned) i;
  KeysPerPage = PageSize / KeyRecordSize;
  PageSize = KeysPerPage * KeyRecordSize; // normalize size
  if (KeysPerPage == 0) {
    SKError = InsufficientMemory;
    SetError(SKError,2,Insufficient_memory_to_sort_keys," [MakeIndex]");
    assertJumper();
    return;
  }
  for (t = 0; t < Pages; t++) {
    if ((Buffer[t] = malloc((size_t)PageSize)) == NULL) {
      while(t>0)
        FreePtrClear((void*) &Buffer[--t]);
      MIWorkArea -= (PageSize + KeyRecordSize);
      goto gototo;
    }
    memset(Buffer[t], 0, (size_t)PageSize);
  }
  Rbuffer = Buffer[--Pages]; // hide the last page - we use it for read buffer
  Pages_1 = Pages - 1;
  for( t = 0; t < Pages; t++) {
    Page[t] = t;
    PageModified[t] = 0;
  }
  Page[Pages] = 0xFFFFFFFFL; // set it to a lala land
  SKError = 0;
  FileCreated = FALSE;
  MaxKeys = NModB = NDivB = 0;
  // should make sure that no index is currently open!
#ifndef WINDOWS
  if (Odometer)
    printf("\r%s\n",Generating_keys);
#endif
  rec_count = TempInd->Anchor.TotalLiveNodes; // RecCount();
  KeyRec.Key[0] = (unsigned char) KeyLen++;
  KeyRec.RecNum = 0;
  key_1 = &KeyRec.Key[1];
  key_tail = &KeyRec.Key[KeyLen];
  DBFError = 0;
  r->CurRecNo = 0;
  k = PageSize / r->RecLen;
  buf_size = k * r->RecLen;
  i = rec_count/k + 1;
  if (r->RecLen * rec_count < (long) buf_size) {
    buf_size =  r->RecLen * (unsigned) rec_count;
    k = (unsigned) rec_count;
  }
  offset1 = 0;
  lseek(r->v.dFile, r->HeadLen, SEEK_SET);
  SaveCurRecPtr = r->CurRecord; // save previous ptr, now we should fake
  // the value of r->CurRecord, substituting it with the current ptr in
  // our local buffer, to provide an access for the parser
  for (Mrecnum = 1; Mrecnum <= i; Mrecnum++) {
    if (lastloop)
      break;
    bytesread = (unsigned) read(r->v.dFile, Rbuffer, buf_size);
    if (bytesread != buf_size) { // the last chunk of DBF file ...
      k = bytesread/r->RecLen; // now sync the k value
      lastloop = TRUE;
    }
    Roffset = Rbuffer;
    for (count = 1; count <= k; ++count, ((char*) Roffset += r->RecLen)) {
      r->CurRecord = Roffset; // now the parser can fetch the data
      // from the r->CurRecord
      KeyRec.RecNum = ++r->CurRecNo;
      address = wa->UserRec;  // this is slightly modified ExportData()
      f = &r->Fields[0];
      *(((int *) address)++) = (*(char*)Roffset == '*');
      for (ii = 0; ii < r->NumFields; ii++, f++) {
        switch (f->Typ) {
          case 'C':
            memcpy(address, &((char*)Roffset)[f->Off], f->Len);
            (char*) address  += f->Len;
            *(((char*) address)++) = 0;
            break;
          case 'D':
            memcpy(S, &((char*)Roffset)[f->Off], 8);
            n = CenturyOn ? 4 : 2;
          switch (DateFormat) {
            case American:
              * (int*) tmp = * ((int*) (S+4));
              tmp[2] = '/';
              *((int*) (tmp+3)) = *((int*) (S+6));
              tmp[5] = '/';
              memcpy(tmp+6, S+4-n, n);
              break;
            case Ansi:
              memcpy(tmp, S+4-n, n);
              tmp[n] = '.';
              *((int*) (tmp+n+1)) = * ((int*) (S+4));
              tmp[n+3] = '.';
              *((int*) (tmp+n+4)) = * ((int*) (S+6));
              break;
            default:
              * (int*) tmp = * ((int*) (S+6));
              tmp[2] = '/';
              * ((int*) (tmp+3)) = *((int*) (S+4));
              tmp[5] = '/';
              memcpy(tmp+6, S+4-n, n);
            switch (DateFormat) {
              case Italian:
                tmp[2] = tmp[5] = '-';
                break;
              case French:
              case German:
              case Spanish:
                tmp[2] = tmp[5] = '.';
                break;
            }
          }
            tmp[n+6] = 0;
            strcpy(address, tmp);
            (char*) address  += 11;
            break;
          case 'L':
          switch (((char*)Roffset)[f->Off]) {
            case  'Y':  case  'y':
            case  'T':  case  't':
              n = TRUE;
              break;
            default:
              n = FALSE;
              break;
          }
            *(((int *) address)++)  = n;
            break;
          case 'M': // suppose nobody uses Memo field in index...
            ((long *) address)++;
            break;
          case 'N': // "numeric" and "float"  fields
          case 'F':
            memcpy(S, &((char*)Roffset)[f->Off], f->Len);
            S[f->Len] = 0;
            if (f->Dec > 0) // convert to a real
              *(((double *) address)++) = strtod(S, NULL);
            else  //  no decimals, so it must be a longint
              *(((long *) address)++) = atol (S);
            break;
        }
      }
      memcpy(key_1, soundexFlag ? Soundex(keymaker()) :
      keymaker(), KeyLen); // w/zero!
      if (descending)
        MakeDescending(KeyRec.Key);

      if (*key_tail) {
        SKError = 216;   // Illegal KeyRecordSize  (BadSize)
        SetError(SKError, 2, incorrect_key_length_returned_by_user_defined_keymaker, " [MakeIndex]");
        assertJumper();
        return;
      }
      key_seq++;
      * ((char *) key_tail) = *((char*) &key_seq + 1); // make a unique key
      * ((char *) key_tail + 1) = *((char*) &key_seq);

      if ((NModB == 0) && (NDivB >= Pages)) {
        // Write out last read page
        if (!FileCreated) { // create a spillover file
#ifdef NET
          if (MultiUser)
            tmpnam(Pagefilename); // obtain a unique filename
#endif
          if ((PFHandle = sopen(Pagefilename, O_CREAT|O_TRUNC|O_BINARY|O_RDWR, SH_DENYRW, S_IREAD|S_IWRITE)) < 0) {
            SKError++;
            SetError(_doserrno, 2, Failure_sorting_keys, " [MakeIndex]");
            assertJumper();
            return;
          }
          else {
            FileCreated = TRUE;
            _doserrno = errno = 0; // set to 2 by sopen()
          }
        } // Write key record to last page
        WritePage(Buffer[Pages_1], Page[Pages_1]++);
      }
      memcpy((KeyRecordType *)
      ((long)(Buffer[(int)((NDivB >= Pages) ? Pages_1 : NDivB)]) +
      offset1), &KeyRec, KeyRecordSize);
      offset1 += KeyRecordSize;
      if ((unsigned) (++NModB) == KeysPerPage) {
        NModB = offset1 = 0;
        ++NDivB;
      }
#ifndef WINDOWS
      if (RotorEnabled)
        AdvanceRotor();
      if (ProgressPtr)
        ProgressPtr();
      if (Odometer)
        printf("\r%ld",Mrecnum*count);
#endif
    }  // local loop
  }
  r->CurRecord = SaveCurRecPtr; // restore the valid value
  MaxKeys = r->CurRecNo;
  if (!SKError) {
    for (t = 0; t < Pages; t++)
      PageModified[t] = TRUE;
    PageModified[Pages++] = FALSE; // return the stolen page for usage
#ifndef WINDOWS
    if (Odometer) {
      printf("\r      ");
      gotoxy(1,wherey() - 1);
      printf("%s\n",Sorting_keys);
    }
#endif
    QuickSort();
    // send all keys to file in sorted order
    if (!SKError) { // write the index file
      IndexSize = 1;
#ifndef WINDOWS
      if (Odometer) {
        gotoxy(1,wherey() - 1);
        printf("%s\n",Creating_Index_File);
      }
#endif // NOT WINDOWS
      Pages--; // get back the last page for caching the nodes and save
      if (PageModified[Pages])
        WritePage(Buffer[Pages], Page[Pages]); // sorted keys on this page
      max_index = PageSize / node_size;
      cache_size = max_index * node_size;
      u1 = MaxKeys - 1;  // set vars for FetchPageAddr()
      u2 = - ((long) KeysPerPage); // -- // --
      WriteNodes(1L, rec_count, 1, 0);
      if (keys_cached) { // flush the remaining nodes from the cache
        cache_size = keys_cached * node_size;
        lseek(FileHandle, (long)(node_offset*node_size), SEEK_SET);
        if (write(FileHandle, Rbuffer, cache_size) != (int) cache_size) {
          SKError = 300;
          HiddenSetError();
          return;
        }
      }
#ifndef WINDOWS
      if (Odometer)
        printf("\n");
#endif
    }
  }
  if (FileCreated) {
    close(PFHandle);
    remove(Pagefilename);
  }
  // Release allocated memory
  Pages++;
  for (t = 0; t < Pages; t++)
    FreePtrClear((void*) &Buffer[t]);
  free(SaveZ);
  free(SwopPost);
  SaveZ = SwopPost = NULL;
} // SortKeys

void MakeIndex(PUDK_func udk, const char *fname)
{
  char  filename[STRSIZ], K[STRSIZ]; // key string
  long  SaveRecNo;
  int   saveSelected, j;

  DBFError = 0;
  if (setjmp(Jumper))
    return;
  memcpy(filename, fname, STRSIZ);
  *(filename + STRSIZ - 1) = 0;
  SqueezeExpression(filename, 1);
  if (*filename == 0) {
    SetError(InvalidParameter, 2, index_filename_not_specified," [MakeIndex]");
    return;
  }
  // get rid of the clauses(SOUNDEX, NOCACHE, DESCENDING) in file name
  soundexFlag = (strstr(filename, " SOUNDEX") != NULL);
  descending  = (strstr(filename, " DESCENDING") != NULL);
  j = PosOf(1, " ", filename);
  if (j > 0) *(filename + j) = 0;
  // make the filename fully qualified
  strcpy(filename, AddExt(filename,"IND"));
  // check that a DBF is open
  if (DBF()[0] == 0) {// DBF lib was not linked, or no database is open
    SetError(NotInUse,3,database_not_open_attempting_to_index_to,filename,". [IndexOn/MakeIndex]");
    return;
  }

#ifdef NET
  if (!IsExclusive()) {
    SetError(ExclusiveUseRequired,4,DBF()," [MakeIndex(<>,",filename,")]");
    return;
  }
#endif
  // check that an index file of the filename specified is not already open:
  saveSelected = Selected;
  for (Selected = 0; Selected < MaxWorkAreas; Selected++)
    for (j = 0; j < MaxOrder; j++)
      if (strcmp(IndexName(j), filename) == 0) {
        SetError(AlreadyInUse, 2, filename," [MakeIndex]");
        return;
      }
  Selected = saveSelected;
  if ((TempInd = malloc(sizeof(IndexType))) == NULL) {
    SetError(217,3,insufficient_memory_to_Create_index,filename,". [MakeIndex]");
    return;
  }
  memset(TempInd, 0, sizeof(IndexType));
  // call the user keymaker function,
  // just to get a string so we can know the key length
  strcpy(K, udk()); // get the straight key from the keymaker
  if (soundexFlag) strcpy(K,Soundex(K)); // convert to soundex if needed
  if (descending)  MakeDescending(K); // convert to descending if needed
  KeyLen = (int)strlen(K); // length of key, BUT later will be incremented !
  node_count = 0;
  node_offset = 1;
  node_size = KeyLen + 21;
  max_index = 0;
  cache_size = 0;
  keys_cached = 0;
  TempInd->KeyLength = KeyLen;
  TempInd->KeyStorage = NULL; // force KeyStorage to be NULL so our convention is consistent
  // now sort the database file, if there is more than 1 record:
  // next step: open the index file and write out the anchor record
  FileHandle= sopen(filename, O_CREAT|O_TRUNC|O_BINARY |O_RDWR, SH_DENYRW,
  S_IREAD| S_IWRITE);
  if (FileHandle < 0) {
    FreePtrClear((void*) &TempInd);
    SetError(_doserrno, 2, error_creating_index_file, filename);
    return;
  }
  TempInd->Anchor.Version = 0x5431;
  TempInd->Anchor.FirstRec = TempInd->Anchor.LastRec = 0; // this will be filled in later
  TempInd->Anchor.KeyLength = KeyLen;
  TempInd->Anchor.TotalLiveNodes = RecCount();
  if (write( FileHandle, &TempInd->Anchor, node_size) != (int) node_size) {
    FreePtrClear((void*) &TempInd);
    SetError(_doserrno,2,error_writing_index_file,filename);
    return;
  }
  // Now form the tree.  There are three situations to deal with:
  //1. Empty database, so there are no records. Put in a dummy root.
  //2. One record. Get the key for the record and write the root.
  //3. Many records. Sorting was done. Use WriteNodes recursively
  //   to form the tree.
  switch (TempInd->Anchor.TotalLiveNodes) {
    case 0:
      TempInd->Index = &TempInd->NodeBuffer;
      memset(TempInd->Index, 0, sizeof(Node));
      TempInd->Index->Entry = 1;
      TempInd->Index->Key[0] = (unsigned char) KeyLen;
      lseek(FileHandle, node_size, SEEK_SET);
      write(FileHandle, TempInd->Index, node_size);
      break;
    case 1:
      TempInd->Index = &TempInd->NodeBuffer;
      memset(TempInd->Index,0,sizeof(Node));
      TempInd->Index->Entry = 1;
      TempInd->Index->DBFRecNo = 1;
      TempInd->Index->Key[0] = (unsigned char) KeyLen;
      memcpy(&(TempInd->Index->Key)[1],K,KeyLen);
      lseek(FileHandle, node_size, SEEK_SET);
      write(FileHandle,TempInd->Index,node_size);
      break;
    default: // Anchor.TotalLiveNodes > 1
      SaveRecNo = RecNo();
      Indexing = TRUE; // tell the progress bar to go half speed
      SortKeys(udk);
      Indexing = FALSE; // reset
      RawGo(SaveRecNo);
      if (SKError) {
        FreePtrClear((void*) &TempInd);
        SetError(254,3,failure_during_key_sort_for,filename,". [MakeIndex]");
        return;
      }
  } // case
  // Now update anchor of the index file
  // find the first and last records
  lseek(FileHandle, node_size, SEEK_SET);
  read(FileHandle, &NodeData, node_size);
  while (NodeData.LessNode > 0) {
    lseek(FileHandle,node_size*NodeData.LessNode, SEEK_SET);
    read(FileHandle, &NodeData, node_size);
  }
  TempInd->Anchor.FirstRec = NodeData.DBFRecNo;
  lseek (FileHandle,node_size, SEEK_SET);
  read (FileHandle, &NodeData, node_size);
  while (NodeData.GrtrNode > 0) {
    lseek (FileHandle, NodeData.GrtrNode*node_size, SEEK_SET);
    read (FileHandle, &NodeData, node_size);
  }
  TempInd->Anchor.LastRec = NodeData.DBFRecNo;
  lseek(FileHandle,0,SEEK_SET);
  // whats going on below: usual, EOF and BOF are false..but, in the
  // case of an empty file (where FirstRec=LastRec=0), these flags need
  // to be True
  TempInd->BOFFlag = (TempInd->Anchor.FirstRec == 0);
  TempInd->EOFFlag = (TempInd->Anchor.LastRec == 0); // flags when a GoTop or GoBottom is called
  write (FileHandle, &TempInd->Anchor, node_size);
  close (FileHandle); // all done making the tree
  FreePtrClear((void*) &TempInd);
}
#endif // ndef NDX_TYPE
