/* filename: LIKDLIST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
  
#include <parser.h>
  
void * get_prev_in_llist(PPLINK list, PLINK link)
{
  if (link == *list)
    return 0;
  if (!link) {
    if (!*list)
      return 0;
    return (*list)->prev;
  }
  
  return link->prev;
}
  
void * get_next_in_llist(PPLINK list, PLINK link)
{
  if (link == *list)
    return 0;
  if (!link) {
    if (!*list)
      return 0;
    return (*list)->next;
  }
  return link->next;
}
  
void add_to_llist(PPLINK list, PLINK link)
{
  PLINK current = *list;
  
  if (current) { // add the link after the current node
    link->prev  = current;
    link->next  = current->next;
    current->next->prev = link;
    current->next = link;
  }
  else
    link->prev = link->next = link;
  *list = link;
  return;
}
  
void * remove_from_llist(PPLINK list)
{// remove the current link from the list
  PLINK current = *list;
  
  if (current) {
    current->prev->next = current->next;
    current->next->prev = current->prev;
    *list = (current->prev == current) ? 0 : current->prev;
  }
  return current;
}
  
void * allocate_and_link(PPLINK ppointer, size_t size)
{
  char * cptr;
  void * ptr = 0;
  
  if ((cptr = (char *)malloc(sizeof(LINK) + size)) != 0) {
    add_to_llist(ppointer, (PLINK) cptr);
    ptr = (void *) (cptr + sizeof(LINK));
    memset(ptr, 0, size);
  }
  return ptr;
}
  
