/* filename: INDEXON.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <index.h>

#ifdef NDX_TYPE
void IndexOnCB(PUDK_func udk, const char *filename)
{
  char *p;
#else
void IndexOn(PUDK_func udk, const char *filename)
{
#endif
  char str[STRSIZ];

  if (!CheckRegisteredUnits("IndexOn", REGTZCOMMON+REGTZDBF+REGTZINDEX))
    return;

  DBFError = 0;
  CloseWorkArea(Selected);
  if (Ind[Selected][0]) {
    SetError(254, 2, internal_error, ind_pointer_already_allocated);
    assertJumper();
    return;
  }
  strcpy(str, filename);
  if (*str) {
#ifdef NDX_TYPE
    MakeIndexCB(udk, str);
    if (DBFError)
      return;
    p = strstr(str, " EXPR=\'");  // assuming 'EXPR=' clause is the last one
    if (p)
      *p = 0;
    SetIndexToCB(udk, str, 1);
#else
    MakeIndex(udk, str);
    if (DBFError)
      return;
    SetIndexTo(udk, str, 1);
#endif
  }
}

#ifdef NDX_TYPE

void MakeIndex(const char *expr, const char *fname)
{
  char  expression[STRSIZ];
  sprintf(expression, "%s EXPR=\'%s\'", fname, expr);
  MakeIndexCB(NULL, expression);
}

void IndexOn(const char *expr, const char *fname)
{
  char  expression[STRSIZ];
  sprintf(expression, "%s EXPR=\'%s\'", fname, expr);
  IndexOnCB(NULL, expression);
}

#endif
  
