/* filename: GETNODE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <sayget.h>
#include <index.h>

#ifdef NDX_TYPE
void GetNode(long blocknum, int order)
{
  PNDXBlock  cnptr; // current cache block pointer
  void      *cblkno; // current block no (long in fact)
  PIndexType p;
  int count, found, i;

  p = Ind[Selected][order];
  if (blocknum == -1) {// we are trying to get back to the pseudonode
    p->Index = PseudoNode[Selected];
    p->BlockBufferPtr = &p->BlockBuffer; // Maybe NULL is better ?
  }
  else
    if (!blocknum) {
      SetError(254,6,invalid_node_number_0_in_dbf_area,
      SInteger(Selected,0),comma_order,SInteger(order,0),
      " ",IndexName(order));
      assertJumper();
    }
    else {
      p->currnode = 0; // reset the current node number
      if (!order && Cache[Selected]) {// look at the cache
        cnptr = (PNDXBlock)CachePtrs[Selected][0];
        cblkno = CachePtrs[Selected][1];
        count = CachePtrsCount[Selected];
        found = FALSE;
        for(i=0; count && cnptr; count--) {
          if ((long)(cblkno) == blocknum) {
            p->BlockBufferPtr = cnptr;
            p->currblock = blocknum;
            p->Index = (PNode)((short *)cnptr + 2);
            found = TRUE;
            break;
          }
          i += 2;
          cnptr = CachePtrs[Selected][i];
          cblkno = CachePtrs[Selected][i+1];
        }
        // there are four possibilities:
        //  found but ptr is the very first: nothing to do
        //  count == nn and found    : exchange ptrs & blockno-s
        //  count == nn and not_found: read from disk::cnptr is nil;
        //  count == 0 and not_found : read from disk::cnptr is last;
        if (found && !i)
          return;
        if (found && count) {
          CachePtrs[Selected][i] = CachePtrs[Selected][i-2];
          CachePtrs[Selected][i-2] = cnptr;
          CachePtrs[Selected][i+1] = CachePtrs[Selected][i-1];
          CachePtrs[Selected][i-1] = cblkno;
          return;
        }
        if (count) {
          count = CachePtrsCount[Selected] - count;
          cnptr = CachePtrs[Selected][2*count] = (PNDXBlock)Cache[Selected] + count;
        }
        else {
          count = CachePtrsCount[Selected] - 1;
          cnptr = CachePtrs[Selected][2*count];
          if (!cnptr) // initialize
            cnptr = CachePtrs[Selected][2*count] = (PNDXBlock)Cache[Selected] + count;
          else
            if (cnptr->modified) // flush if modified
              SeekAndWrite(Selected,order,(long)CachePtrs[Selected][2*count+1],cnptr);
        }
        CachePtrs[Selected][2*count+1] = (void *)blocknum;
        p->BlockBufferPtr = cnptr;
      } // the node is not in the cache go to disk to find it
      else //  no cache so go to disk for block
        cnptr = p->BlockBufferPtr = (PNDXBlock)(&p->BlockBuffer);
      p->Index = (PNode)((short *)cnptr + 2);
      SeekAndRead(Selected, order, blocknum, cnptr);
      p->currblock = blocknum;
    }
}

#else // not NDX

void GetNode(long nodenum, int order)
{
  int        coffset;  // cache offset
  PNode      cnptr;    // current cache node pointer
  PIndexType p;

  p = Ind[Selected][order];
  if (nodenum == -1) // we are trying to get back to the pseudonode
    p->Index = PseudoNode[Selected];
  else
    if (!nodenum) {
      SetError(254,6,invalid_node_number_0_in_dbf_area,
      SInteger(Selected,0),comma_order,SInteger(order,0),
      " ",IndexName(order));
      assertJumper();
    }
    else {
      if (!order && (nodenum <= (long) CCacheSize[Selected]) && (Cache[Selected] != NULL))
      { // look at the cache
        coffset = (int)(nodenum-1)*CNSize[Selected];
        cnptr = (PNode) ((char *)Cache[Selected]+coffset);
        p->Index = cnptr;
        if (!cnptr->Entry) { // the node is not in the cache
          // go to disk to find it
          SeekAndRead(Selected,order,nodenum,p->Index);
        }
      }
      else { // no cache so go to disk for node
        p->Index = &p->NodeBuffer;
        SeekAndRead(Selected,order,nodenum,p->Index);
      }
    }
}
#endif // NDX_TYPE
  
