/* filename: FINDLAST.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <sayget.h>
#include <dbf.h>
#include <index.h>

#ifdef NDX_TYPE
extern int OrderChanged;

long FindLastRecFunc(void) // alias FindLastRec, _FindLastRec
{
  PIndexType p;
  long       t;

  Found = FALSE;
  p = Ind[Selected][SyncOrder];
  if (!p) {
    SetError(IndexNotOpen,2,index_not_open," [FindLastRecFunc]");
    return 0L;
  }
  if (ZerOrder[Selected]) {
    t = RecCount();
    Found = t != 0L;
    return t;
  }
#ifdef NET
  IndexesChanged();
#endif
  OrderChanged = 0;
  p->path  = Ind[Selected][0]->path;
  p->cpath = Ind[Selected][0]->cpath;
  clean_path(Selected, SyncOrder, FALSE);

  GetNode(p->header.root, SyncOrder);
  if (!p->BlockBufferPtr->num_keys) { // empty database, set flags
    p->BOFFlag = p->EOFFlag = TRUE;
    return 0L;
  }

  // start at the root block search downwards
  p->Index = Dfind_last(p, p->header.root, SyncOrder, TRUE);
  p->currnode = NoDe;
  p->BOFFlag = p->EOFFlag = FALSE;
  Found = TRUE;
  return p->Index->DBFRecNo;
}

#else

long FindLastRecFunc(void) // alias FindLastRec, _FindLastRec
{
  long       t;
  PIndexType p = Ind[Selected][SyncOrder];

  Found = FALSE;
  if (!p) {
    SetError(IndexNotOpen,2,index_not_open," [FindLastRecFunc]");
    return 0L;
  }
  if (ZerOrder[Selected]) {
    t = RecCount();
    Found = t != 0L;
    return t;
  }
  FindingEdge = InhibitGo = TRUE;
  Find(Replicate((char)(p->Descending?'\0':'\xFF'), (int)p->KeyLength));
  FindingEdge = InhibitGo = FALSE;
  // whats going on below: usual, EOF and BOF are false
  // ..but, in the case of an empty file (where FirstRec=LastRec=0),
  // these flags need to be TRUE
  p->BOFFlag = p->Anchor.FirstRec == 0;
  p->EOFFlag = p->Anchor.LastRec == 0;
  //  return record number from index node
  return p->Index->DBFRecNo;
}
#endif
