/* filename: FINDINTR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>

PNode Dfind_frst(PIndexType p, long block, int order, int path)
{
  // go down the branch and find leaf block
  while(block) {
    GetNode(block, order);
    if (path)
      add_path(block, order);
    block = *(long *)p->BlockBufferPtr->block;
  }
  // set the node counter to the first node (counter is 0-based)
  NoDe = 0;
  // return pointer to the first key node
  return (PNode)p->BlockBufferPtr->block;
}

PNode Dfind_last(PIndexType p, long block, int order, int path)
{
  int   offset, g_len;
  char *block_start;

  g_len = p->header.group_len;
  do { // go down the branch and find leaf block
    GetNode(block, order);
    if (path)
      add_path(block, order);
    offset = p->BlockBufferPtr->num_keys * g_len;
    block_start = p->BlockBufferPtr->block;
    block = *(long *)(block_start + offset);
  } while (* (long *) block_start);
  // set the node counter to the last node (counter is 0-based)
  NoDe = p->BlockBufferPtr->num_keys - 1;
  // return pointer to the last key node
  return (PNode)(p->BlockBufferPtr->block + NoDe * g_len);
}

PNode Dfind_key(PIndexType p, long block, int order, int path, const void * key)
{ // find the first match of the key (or greater if no such key)
  PNode ret;

  GetNode(block, order);
  if (path)
    add_path(block, order);
  ret = Bfind_key(p, key);
  if (ret->block_num && ((PNode) (p->BlockBufferPtr->block))->block_num)
    do {
      block = ret->block_num;
      GetNode(block, order);
      if (path)
        add_path(block, order);
      ret = Bfind_key(p, key);
    } while (*(long *)p->BlockBufferPtr->block);
  return ret;
}
#endif // NDX_TYPE
  
