/* filename: FINDINBL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <index.h>
#ifdef NDX_TYPE
#include <stdio.h>

int NoDe = -3; // node number, internal

PNode Bfind_frst(PIndexType p)
{
  NoDe = 0;
  return (PNode)p->BlockBufferPtr->block;
}

PNode Bfind_last(PIndexType p)
{
  NoDe = p->BlockBufferPtr->num_keys - 1;
  return (PNode)(p->BlockBufferPtr->block + NoDe * p->header.group_len);
}

PNode Bfind_key(PIndexType p, const void * key)
{ // find the first match of the key (or greater if no such key)
  int       n_keys, g_len, k_len, ret, i, j;
  char     *current, *kmin, *first, *last; // key pointers
  PUDC_func cmp;

  cmp    = p->cmp;
  g_len  = p->header.group_len;
  k_len  = p->header.key_len;
  n_keys = p->BlockBufferPtr->num_keys;
  first  = p->BlockBufferPtr->block + 2*sizeof(long);

  // 1. the given key is less or equal to the first key in the block
  ret = cmp(key, first, k_len);
  if (n_keys <= 0) ret = -1;
  if (ret <= 0) {
    NoDe = ret ? LESSNODE : 0;
    return (PNode) p->BlockBufferPtr->block;
  }
  // 2. the given key is greater than the last key in the block: not found
  last   = first + (n_keys-1) * g_len;
  if (cmp(key, last, k_len) > 0) {
    NoDe = GRTRNODE;
    return (PNode)(p->BlockBufferPtr->block + n_keys * g_len);
  }
  // 3. the given key is in the block... search for it
  for (kmin = first; n_keys > 0;) {
    i = n_keys >> 1;
    current = kmin + i * g_len;
    j = (*cmp)(key, current, k_len);
    if (j <= 0) {
      if (j == 0 && i == 1) {
        current -= g_len;
        break;
      }
      n_keys = i;
    }
    else  {
      kmin = current + g_len;
      n_keys = n_keys - i - 1;
    }
  }
  i = ((*cmp)(key, current, k_len) > 0) ? g_len : 0;
  i += (int)(current - first);
  NoDe = i / g_len;

  return (PNode)(p->BlockBufferPtr->block + i);
}
#endif // NDX_TYPE
  
