/* filename: FIND.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <index.h>

int FindingEdge = FALSE;// Don't go to EOF, stop at the next record if TRUE
int InhibitGo   = FALSE;// Find does not move database record if TRUE
// SetEOF() has no effect either if InhibitGo == TRUE
#ifdef NDX_TYPE
extern int OrderChanged;

void _Find(const char * key)
{
  PIndexType p;
  PNode      cnode;
  short      num_keys, order;
  long       cblock;

  DBFError = 0;
  order = SyncOrder;
  p = Ind[Selected][order];

  p->EOFFlag = p->BOFFlag = 0;
  cblock = p->header.root;  // start at the root block
  OrderChanged =0;
  p->path  = Ind[Selected][0]->path;
  p->cpath = Ind[Selected][0]->cpath;
  clean_path(Selected, order, FALSE);
  cnode = Dfind_key(p, cblock, order, TRUE, key);
  if (NoDe >= 0) {
    p->currnode = NoDe;
    p->Index = cnode;
  }
  else {
    if (NoDe == LESSNODE) {
      p->BOFFlag = TRUE;
      p->currnode = 0;
      p->Index = (PNode)p->BlockBufferPtr->block;
    }
    else { // GRTRNODE
      p->EOFFlag = TRUE;
      num_keys = p->BlockBufferPtr->num_keys;
      p->currnode = num_keys;
      p->Index = (PNode)(p->BlockBufferPtr->block + num_keys * p->header.group_len);
    }
  }
  Found = memcmp(key, p->Index->Key, p->header.key_len) == 0;
}

static void copyNpad(char *keycopy, const char *key, int k_len)
{
  int len;

  strcpy(keycopy, key);
//  if (IndexExact) { // if IndexExact pad the key w/spaces
    len = strlen(keycopy);
    while(len < k_len)
      keycopy[len++] = ' ';
    keycopy[len] = 0;
//  }
}

void Find(const char * key)
{
  Node       savenode;
  PIndexType p;
  char       keycopy[101], *chptr;
  int        savecurrnode, pseudo, order, k_len, g_len;
  long       saveblockno;
  double     double_key;

  pseudo = FALSE;
  Found = FALSE;
  DBFError = 0;
  order = SyncOrder;
  p = Ind[Selected][order];
  k_len = p->header.key_len;
  g_len = p->header.group_len;
  if (!*DBF()) {
    SetError(215, 1, " [Find]");// 215 will report "no database in use"
    return;
  }
  if (ZerOrder[Selected]) {
    SetError(254, 1, You_cannot_use_Find_with_order_0);
    return;
  }
  if (!p) {  // the index isn't open yet
    SetError(IndexNotOpen, 6, index_not_open,while_searching_for,
    key, _in_, DBF(), " [Find]");
    return;
  }
  if (!p->currblock) {  // p has been just initialized
    FindFirstRecFunc();
    if (p->EOFFlag) return;
  }
  if (p->Index->DBFRecNo == -1) // pseudonode indicator
    pseudo = TRUE;
  saveblockno  = p->currblock;
  savecurrnode = p->currnode;

  if ((p->kiss && !*key) || !RecCount())  return;

  if (p->parser) {
    switch (p->header.type) {
      case 'N' :
      case 'F' :
        double_key = atof(key);
        memcpy(keycopy, &double_key, sizeof(double));
        break;
      case 'D' :
        double_key = CtoDInternal((char *)key);
        memcpy(keycopy, &double_key, sizeof(double));
        break;
      default  :
        copyNpad(keycopy, key, k_len);
    }
  }
  else {
    copyNpad(keycopy, key, k_len);
    if (p->SoundexFlag)
      memcpy(keycopy, Soundex(keycopy), k_len+1);
    if (p->Descending) {
      if (!IndexExact) { // trim keycopy
        for(chptr=&keycopy[k_len-1]; *chptr == ' '; chptr--) ;
        *(chptr+1) = 0;
      }
      MakeDescending(keycopy);
    }
  }
#ifdef NET
  if (Semaphore[Selected]) {
    SetReadSemaphoreProc(1);
    IndexesChanged();
  }
#endif

  _Find(keycopy);

  if (p->EOFFlag) {
    p->currnode--;
    p->Index = (PNode)((char *)p->Index - g_len);
  }

  //  check to see if record is valid
  RawGo(p->Index->DBFRecNo);// performs export current data
  while(!ValidRec() && !p->EOFFlag)
    RawGo(FindNextRecFunc());   // "skip" while not valid

  if (p->kiss && !IndexExact)
    k_len = strlen(key);//note:not "keycopy" but "key" is used

  Found = memcmp(keycopy, p->Index->Key, k_len) == 0 && !p->EOFFlag;
  if (!InhibitGo && (FindingEdge || Found) && !order) {
    if (p->Index->DBFRecNo) {
      RawGo(p->Index->DBFRecNo);
      StoreCurrentKeys();
    }
    goto BAILOUT;
  }
  if (!Found && !InhibitGo) {
    if (FindingEdge) goto BAILOUT;
    SetEOF();
  }
  else { // restore position and update path
    GetNode(saveblockno, order);
    memcpy(&savenode,((char *)p->Index + savecurrnode * g_len), g_len);
    InhibitGo = FALSE;
    _Find(savenode.Key);
    InhibitGo = TRUE;
    while(memcmp(&savenode,p->Index,g_len)) FindNextRecFunc();
    if (pseudo == TRUE)
      SetPseudoNode(Selected, order);
  }

BAILOUT:

#ifdef NET
  if (Semaphore[Selected])
    SetReadSemaphoreProc(0);
#endif
  return;
}
#else // NDX_TYPE

static char _tzfar retkey[101] = { 0 };

static char * AdjustedKey(char * k, size_t len)
{
  strcpy(retkey, k);
  if (!IndexExact)
    if (strlen(retkey) > len)
      retkey[len] = '\0';
  return retkey;   //  adjusted to match length of search key
}

void Find(const char * key)
{
  Node       saveIndex, LastValidNode;
  long       TempRecNo;
  char       index_key[101], keycopy[101];
  int        order,keylen, nodelen, validRec;
  size_t     len;
  PIndexType p;
  PNode      pi;

  DBFError = 0;
  order = SyncOrder;
  p = Ind[Selected][order];
  pi = p->Index;

  if (!*DBF()) { // no database is open
    SetError(215,1," [Find]"); // 215 will report "no database in use"
    return;
  }
  if (ZerOrder[Selected]) {
    SetError(254, 1, You_cannot_use_Find_with_order_0);
    return;
  }
  if (!p) { // the index isn't open yet
    SetError(IndexNotOpen,6,index_not_open,while_searching_for,key,_in_,
    DBF()," [FIND]");
    return;
  }
  keylen = p->KeyLength;
  nodelen = keylen + 21;
  Found = FALSE;
  strcpy(keycopy, key);
  if (!*keycopy)
    return;
  if (!RecCount())
    return;
#ifdef NET
  HandleSemaphore((char)Selected,IncRead);
  IndexesChanged();
#endif
  memcpy(&saveIndex, pi, nodelen);
  memcpy(&LastValidNode, pi, nodelen);
  GetNode(1,order); // start at the root node
  pi = p->Index;
  if (pi->DBFRecNo)
    memcpy(&LastValidNode, pi, nodelen);
  if (p->SoundexFlag)
    memcpy(keycopy,Soundex(keycopy),SoundexLength+1);
  if (p->Descending)
    MakeDescending(keycopy);
  // make sure keycopy length isn't longer than KeyLength
  if((len = strlen(keycopy)) > (size_t) keylen)
    keycopy[keylen] = 0;
  if (IndexExact)
    while( (len = strlen(keycopy )) < (size_t) keylen)
      strcat(keycopy," "); // pad key

LOOP:
  strcpy(index_key,AdjustedKey(pi->Key,len));
  if (!index_key[0])
    strcpy(index_key, Replicate('\01', keylen));
  if (strcmp(keycopy,index_key) > 0) {
    if (pi->GrtrNode > 0) {
      GetNode(pi->GrtrNode,order);
      pi = p->Index;
      if (FindingEdge)
        if (pi->DBFRecNo > 0)
          memcpy(&LastValidNode,pi, nodelen);
      goto LOOP;
    }
    else { // GrtrNode = zero
      Found = FALSE;
      GetNode(FindingEdge ?LastValidNode.Entry : saveIndex.Entry, order);
      pi = p->Index;
      goto DONE;
    }
  }
  else { // keycopy <= index_key
    if (strcmp(keycopy,index_key) < 0) {
      if (pi->LessNode > 0) {
        GetNode(pi->LessNode,order);
        pi = p->Index;
        if (FindingEdge)
          if (pi->DBFRecNo > 0)
            memcpy(&LastValidNode,pi, nodelen);
        goto LOOP;
      }
      else {  //  LessNode = zero
        Found = FALSE;
        GetNode(FindingEdge ?LastValidNode.Entry : saveIndex.Entry,  order);
        pi = p->Index;
        goto DONE;
      }
    }
    else { // keycopy = index_key
      Found = TRUE;
      do { // now go through prior records looking for the first matching entry
        memcpy(&saveIndex,pi, nodelen);
        TempRecNo = FindPriorRecFunc();
        pi = p->Index;
        strcpy(index_key,AdjustedKey(pi->Key,len));
      }  while (!(strcmp(keycopy,index_key) || (pi->Entry == saveIndex.Entry)));
      TempRecNo = pi->DBFRecNo;
      if (strcmp(keycopy,index_key)) {
        TempRecNo = FindNextRecFunc();
        pi = p->Index;
      }
      if (!order)
        if(!InhibitGo) {
          // now find the first matching key that passes the users
          // validation routine..such as a filter
          do {
            memcpy(&saveIndex,pi, nodelen);
            RawGo(TempRecNo);
            //  see if valid
            validRec = ValidRec();
            if(!validRec) {
              TempRecNo = FindNextRecFunc();
              pi = p->Index;
            }
            strcpy(index_key,AdjustedKey(pi->Key, len));
          } while (!(validRec || strcmp(keycopy,index_key) || (pi->Entry == saveIndex.Entry)));
          if (!validRec) {
            Found = FALSE;
            StoreCurrentKeys();
            goto DONE;
          }
          StoreCurrentKeys();
        }// order = 0 and not inhibit go
    }// Found = TRUE
  }// keycopy <= index_key

DONE:// if not found or not valid then "gobottom+1"
     //  -- this makes setting relations possible
  if (!Found)
    SetEOF();
#ifdef NET
  HandleSemaphore((char)Selected,DecRead);
#endif
}
#endif // NDX_TYPE
  
