/* filename: ENGINE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <math.h>
#include <dos.h>

#include <sayget.h>
#include <timedate.h>
#include <dbf.h>
#include <parser.h>
#include <index.h>

#define PI_VALUE  3.14159265358979323846

char IndexRecordType;

static struct dosdate_t  idate;
static char   *icPtr1, *icPtr2;
static char   icOpr1[STRSIZ], icOpr2[STRSIZ];
static double inOpr1, inOpr2, inOpr3;
static int    iiOpr1, iiOpr2, iiOpr3;

void BuildNewKey(void)
{
  PStackNode SP;
  int iwidth, iprec;
  char icOpr3[STRSIZ];
#ifdef PARSER_EXTENSIONS
  struct diskfree_t idiskfree;
  PParseBufferStruct handle;
  char type[3];
#endif

#ifdef DYNAMIC_TYPE
  for(SP = GetFirstSStackNode(); SP->Action != EOF; SP = GetNextSStackNode())
#else
  for(SP = GetSStackNode(); SP->Action != EOF; SP = GetSStackNode())
#endif
    switch(SP->Action) {
      case 0 :
        switch(SP->ArgType){
          case _LOGICALTYPE :
          case _NUMBERTYPE :
          case _DATETYPE :
            PushWD(SP->ArgType, &SP->type);
            break;
          case _STRINGTYPE :
          case _MEMOTYPE   :
            PushWD(SP->ArgType, (C_PTR)SP->type.C);
            break;
        }
        break;

#ifdef PARSER_EXTENSIONS
      case t_ACOS :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = acos(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_ASIN :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = asin(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_ATAN :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = atan(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_ATN2 :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = atan2(inOpr1, inOpr2);
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case t_CEILING :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = ceil(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_COS :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = cos(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_DISKSPACE :
        _dos_getdiskfree(0, &idiskfree);
        inOpr1 = (double) idiskfree.avail_clusters *
        (double) idiskfree.bytes_per_sector *
        (double) idiskfree.sectors_per_cluster;
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      case t_EXP :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = exp(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_FIELD   :
        inOpr1 = *(N_PTR)PopWD();
        strcpy(icOpr1, Field((int) inOpr1));
        PushWD(_STRINGTYPE, &icOpr1);
        break;
      case t_FILE    :
        iiOpr1 = access((C_PTR)PopWD(), 0) ? 0 : 1;
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      // case t_FKLABEL : break;
      // case t_FKMAX   : break;
      case t_FLOOR :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = floor(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      // case t_FOUND   : break;
      case t_GETENV  :
        strcpy(icOpr1, (C_PTR)PopWD());
        PushWD(_STRINGTYPE, getenv(icOpr1));
        break;
      case t_ISALPHA :
        iiOpr1 = isalpha(*(C_PTR)PopWD());
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      // case t_ISCOLOR : break;
      case t_ISLOWER :
        iiOpr1 = islower(*(C_PTR)PopWD());
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case t_ISUPPER :
        iiOpr1 = isupper(*(C_PTR)PopWD());
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case t_LOG :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = log(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_LOG10 :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = log10(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_PI :
        inOpr1 = PI_VALUE;
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      // case t_PCOL    : break;
      // case t_PROW    : break;
      // case t_READKEY : break;
      case t_RECCOUNT:
        inOpr1 = (double)RecCount();
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      case t_SIGN :
        inOpr1 = *(N_PTR)PopWD();
        if (inOpr1 == 0.0F)
          inOpr2 = 0.0F;
        else
          if (inOpr1 < 0.0F)
            inOpr2 = -1.0F;
          else
            inOpr2 = 1.0F;
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_SIN :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = sin(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_SQRT :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = sqrt(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_TAN :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = tan(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_TIME :
        _strtime(icOpr1);
        PushWD(_STRINGTYPE, icOpr1);
        break;
      // case t_TRANSFORM : break;
      // case t_TRIM      : see t_RTRIM:
      case t_TYPE  :
        strcpy(icOpr3, (C_PTR)PopWD());
        type_save_restore_parameters(1);
        handle = AssignExpr(icOpr3);
        if(handle) {
          type[0] = toupper(handle->ReturnType);
          DisposeExpr(&handle);
        }
        else
          type[0] = 'U';
        type[1] = 0;
        type_save_restore_parameters(0);
        PushWD(_STRINGTYPE, type);
        break;
#endif
      case t_ABS :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = fabs(inOpr1);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_ASC :
        *icOpr1 = *(C_PTR)PopWD();
        inOpr1  = (double)*icOpr1;
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      case t_AT :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        if((icPtr1 = strstr(icOpr2, icOpr1)) == NULL)
          inOpr1 = 0;
        else
          inOpr1 = (double)(icPtr1 - icOpr2) + 1;
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      // case t_BOF : break;
      case t_CDOW :
        inOpr1 = *(D_PTR)PopWD();
        PushWD(_STRINGTYPE, CDOW(InternalToDate(inOpr1)));
        break;
      case t_CHR :
        inOpr1 = *(N_PTR)PopWD();
        *icOpr1 = (int)inOpr1;
        *(icOpr1 + 1) = 0;
        PushWD(_STRINGTYPE, icOpr1);
        break;
      case t_CMONTH :
        inOpr1 = *(D_PTR)PopWD();
        PushWD(_STRINGTYPE, CMonth(InternalToDate(inOpr1)));
        break;
      // case t_COL : break;
      case t_CTOD :
        strcpy(icOpr1, (C_PTR)PopWD());
        inOpr1 = CtoDInternal(icOpr1);
        PushWD(_DATETYPE, &inOpr1);
        break;
      case t_DATE :
        _dos_getdate(&idate);
        inOpr1 = IntsToInternal((int)idate.year,(int)idate.month,(int)idate.day);
        PushWD(_DATETYPE, &inOpr1);
        break;
      case t_DAY :
        inOpr1 = *(D_PTR)PopWD();
        inOpr2 = (double)Day(InternalToDate(inOpr1));
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      // case t_DBF    : break;
      case t_DELETED:
        iiOpr1 = Deleted();
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case t_DOW :
        inOpr1 = *(D_PTR)PopWD();
        inOpr2 = (double)DOW(InternalToDate(inOpr1));
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_DTOC :
        inOpr1 = *(D_PTR)PopWD();
        PushWD(_STRINGTYPE, InternalToDate(inOpr1));
        break;
      case t_DTOR :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = inOpr1 * PI_VALUE / 180.0;
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_DTOS :
        inOpr1 = *(D_PTR)PopWD();
        PushWD(_STRINGTYPE, Internal2DBF(inOpr1));
        break;
      // case t_EOF   : break;
      // case t_ERROR : break;
      case t_IIF :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = *(L_PTR)PopWD();
        PushWD(_STRINGTYPE, iiOpr1 ? icOpr1 : icOpr2);
        break;
      // case t_INKEY : break;
      case t_INT :
        inOpr1 = *(N_PTR)PopWD();
        modf(inOpr1, &inOpr2);
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_LEFT :
        inOpr1 = *(N_PTR)PopWD();
        icPtr1 = GetStringAddressInWS();
        if ((int)strlen(icPtr1) - (int)inOpr1 > 0)
          *(icPtr1 + (int)inOpr1) = 0;
        break;
      case t_LEN :
        inOpr1 = (double)strlen((C_PTR)PopWD());
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      case t_LOWER :
        strlwr(GetStringAddressInWS());
        break;
      case t_LTRIM :
        icPtr1 = icPtr2 = GetStringAddressInWS();
        for(; *icPtr2 && *icPtr2 == ' '; icPtr2++) ;
        memmove(icPtr1,icPtr2, strlen(icPtr2)+1U); //overlapping strings
        break;
      // case t_LUPDATE : break;
      case t_MAX :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = max(inOpr1, inOpr2);
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      // case t_MESSAGE : break;
      case t_MIN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = min(inOpr1, inOpr2);
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case t_MOD :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = fmod(inOpr1, inOpr2);
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case t_MONTH :
        inOpr1 = *(D_PTR)PopWD();
        inOpr2 = (double)Month(InternalToDate(inOpr1));
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      // case t_NDX : break;
      // case t_OS  : break;
      case t_RECNO :
        inOpr1 = (double)RecNo();
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      // case t_RECSIZE : break;
      case t_REPLICATE :
        iiOpr1 = (int)*(N_PTR)PopWD();
        strcpy(icOpr1, (C_PTR)PopWD());
        for(*icOpr2 = 0, iiOpr2 = 0; iiOpr2 < iiOpr1; iiOpr2++)
          strcat(icOpr2, icOpr1);
        PushWD(_STRINGTYPE, icOpr2);
        break;
      case t_RIGHT :
        inOpr1 = *(N_PTR)PopWD();
        icPtr1 = GetStringAddressInWS();
        iiOpr1 = (int)strlen(icPtr1) - (int)inOpr1;
        if (iiOpr1 > 0) // do not use memcpy here
          memmove(icPtr1, icPtr1+iiOpr1, (size_t)inOpr1 + 1U);
        break;
      case t_ROUND :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = pow(10.0, inOpr2);
        inOpr1 *= inOpr3;
        inOpr2 = ceil(inOpr1) / inOpr3;
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      // case t_ROW : break;
      case t_RTOD :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = inOpr1 * 180.0 / PI_VALUE;
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
      case t_RTRIM :
      case t_TRIM  :
        icPtr1 = GetStringAddressInWS();
        iiOpr1 = strlen(icPtr1);
        if (iiOpr1) {
          for(icPtr1 += iiOpr1-1; (*icPtr1 == ' ') && iiOpr1; --icPtr1, --iiOpr1) ;
          *(icPtr1+1) = 0;
        }
        break;
      case t_SOUNDEX :
        strcpy(icOpr1, (C_PTR)PopWD());
        memcpy(icOpr1, Soundex(icOpr1), SoundexLength+1);
        PushWD(_STRINGTYPE, icOpr1);
        break;
      case t_SPACE :
        inOpr1 = *(N_PTR)PopWD();
        if (inOpr1 > (STRSIZ-1.0))
          inOpr1 = (STRSIZ-1.0);
        iiOpr1   = (int)inOpr1;
        memset(icOpr1,  ' ', iiOpr1);
        *(icOpr1 + iiOpr1) = 0;
        PushWD(_STRINGTYPE, icOpr1);
        break;
      case t_STR :
        switch(SP->ArgsNo) {
          case 1:
            inOpr1 = *(N_PTR)PopWD();
            iwidth = 10;
            iprec  = 0;
            break;
          case 2:
            inOpr2 = *(N_PTR)PopWD();
            inOpr1 = *(N_PTR)PopWD();
            iwidth = (int)inOpr2;
            iprec  = 0;
            break;
          case 3:
            inOpr3 = *(N_PTR)PopWD();
            inOpr2 = *(N_PTR)PopWD();
            inOpr1 = *(N_PTR)PopWD();
            iwidth = (int)inOpr2;
            iprec  = (int)inOpr3;
            break;
        }
        sprintf(icOpr1, "%*.*f", iwidth, iprec, inOpr1);
        PushWD(_STRINGTYPE, icOpr1);
        break;
      case t_STUFF :
        strcpy(icOpr2, (C_PTR)PopWD());
        iiOpr2 = (int)*(N_PTR)PopWD();
        iiOpr1 = (int)*(N_PTR)PopWD() - 1;
        strcpy(icOpr1, (C_PTR)PopWD());
        *(icOpr1 + iiOpr1) = 0;
        strcpy(icOpr3, icOpr1);
        strcat(icOpr3, icOpr2);
        strcat(icOpr3, icOpr1 + iiOpr1 + iiOpr2);
        PushWD(_STRINGTYPE, icOpr3);
        break;
      case t_SUBSTR :
        iiOpr2 = (int)*(N_PTR)PopWD();
        iiOpr1 = (int)*(N_PTR)PopWD() - 1;
        icPtr1 = GetStringAddressInWS();
        iiOpr3 = (int) strlen(icPtr1);
        if (iiOpr1 < iiOpr3) {
          if (iiOpr1 + iiOpr2 < iiOpr3)
            *(icPtr1 + iiOpr1 + iiOpr2) = 0;
          else
            iiOpr2 = (int) strlen(icPtr1+iiOpr1);
          iiOpr2++; // do not use memcpy here
          memmove(icPtr1, icPtr1 + iiOpr1, (size_t) iiOpr2);
        }
        break;
      case t_UPPER :
        strupr(GetStringAddressInWS());
        break;
      case t_VAL :
        inOpr1 = strtod((C_PTR)PopWD(), &icPtr1);
        PushWD(_NUMBERTYPE, &inOpr1);
        break;
      // case t_VERSION : break;
      case t_YEAR :
        inOpr1 = *(D_PTR)PopWD();
        inOpr2 = (double)Year(InternalToDate(inOpr1));
        PushWD(_NUMBERTYPE, &inOpr2);
        break;

      // DATABASE FIELDS

      case t_STRFIELD : // dealing with a STRING Field
        PushWD(_STRINGTYPE, DBF_field_address(*(L_PTR)PopWD(),icOpr1,MaxWorkAreas));
        break;
      case a_STRFIELD : // dealing with an alias STRING Field
        iiOpr1 = *(L_PTR)PopWD();
        PushWD(_STRINGTYPE, DBF_field_address(*(L_PTR)PopWD(),icOpr1,iiOpr1));
        break;
      case t_MEMFIELD : // dealing with a MEMO Field
        PushMemoInWD(DBF_field_address(*(L_PTR)PopWD(),icOpr1,MaxWorkAreas));
        break;
      case a_MEMFIELD : // dealing with an alias MEMO Field
        iiOpr1 = *(L_PTR)PopWD();
        PushMemoInWD(DBF_field_address(*(L_PTR)PopWD(),icOpr1,iiOpr1));
        break;
      case t_NUMFIELD : // NUMERIC Field
        PushWD(_NUMBERTYPE, DBF_field_address(*(L_PTR)PopWD(),NULL,MaxWorkAreas));
        break;
      case a_NUMFIELD : // alias NUMERIC Field
        iiOpr1 = *(L_PTR)PopWD();
        PushWD(_NUMBERTYPE, DBF_field_address(*(L_PTR)PopWD(),NULL,iiOpr1));
        break;
      case t_LOGFIELD : // LOGICAL Field
        PushWD(_LOGICALTYPE, DBF_field_address(*(L_PTR)PopWD(),NULL,MaxWorkAreas));
        break;
      case a_LOGFIELD : // alias LOGICAL Field
        iiOpr1 = *(L_PTR)PopWD();
        PushWD(_LOGICALTYPE, DBF_field_address(*(L_PTR)PopWD(),NULL,iiOpr1));
        break;
      case t_DATFIELD : // DATE Field
        iiOpr2 = *(L_PTR)PopWD();
        inOpr1 = DBFtoInternal((char*)DBF_field_address(iiOpr2,NULL,MaxWorkAreas));
        PushWD(_DATETYPE, &inOpr1);
        break;
      case a_DATFIELD : // alias DATE Field
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr2 = *(L_PTR)PopWD();
        inOpr1 = DBFtoInternal((char*)DBF_field_address(iiOpr2,NULL,iiOpr1));
        PushWD(_DATETYPE, &inOpr1);
        break;

      // ARITHMETICS

      case ADD_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = inOpr1 + inOpr2;
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case ADD_ND :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = *(D_PTR)PopWD();
        inOpr3 = inOpr1 + inOpr2;
        PushWD(_DATETYPE, &inOpr3);
        break;
      case ADD_DN :
        inOpr1 = *(D_PTR)PopWD();
        inOpr2 = *(N_PTR)PopWD();
        inOpr3 = inOpr1 + inOpr2;
        PushWD(_DATETYPE, &inOpr3);
        break;
      case ADD_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        PushWD(_STRINGTYPE, strcat(icOpr1, icOpr2));
        break;
      case SUB_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = inOpr1 - inOpr2;
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case SUB_DN :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = inOpr1 - inOpr2;
        PushWD(_DATETYPE, &inOpr3);
        break;
      case SUB_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        inOpr3 = inOpr1 - inOpr2;
        PushWD(_DATETYPE, &inOpr3);
        break;
      case SUB_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = strlen(icOpr1);
        iiOpr2 = strlen(icOpr2);
        for(icPtr1=icOpr1+iiOpr1-1; *icPtr1 == ' ';icPtr1--) ;
        icPtr1++;
        iiOpr1 -= (int)(icPtr1 - icOpr1);
        memmove(icPtr1+iiOpr1, icOpr2, iiOpr2+1);
        aswap(icPtr1, iiOpr1, iiOpr2);
        PushWD(_STRINGTYPE, icOpr1);
        break;
      case MUL_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = inOpr1 * inOpr2;
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case DIV_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        if (inOpr2 == 0.0) {
          SetError(DivideByZero, 1, Error_during_evaluation_Divide_by_0);
          inOpr2 = 1e-300; // cure if(AutoHalt == FALSE)
        }
        inOpr3 = inOpr1 / inOpr2;
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case POW_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        inOpr3 = pow(inOpr1, inOpr2);
        PushWD(_NUMBERTYPE, &inOpr3);
        break;
      case CEQ_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 == inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CEQ_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 == inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
		  break;
		case CAEQ_SS :   // "<string1> == <string2>"  the == operator is supported by FoxPro
		  strcpy(icOpr2, (C_PTR)PopWD());
		  strcpy(icOpr1, (C_PTR)PopWD());
		  iiOpr1 = (strcmp(icOpr1, icOpr2) == 0);
		  PushWD(_LOGICALTYPE, &iiOpr1);
		  break;
		case CEQ_SS :    // "<string1> = <string2>"    "hello"="hello world" returns FALSE
							  //                            "hello world"="hello" returns TRUE
							  //                            "world hello"="hello" returns FALSE
		  strcpy(icOpr2, (C_PTR)PopWD());
		  strcpy(icOpr1, (C_PTR)PopWD());
		  iiOpr1 = (strncmp(icOpr1, icOpr2, strlen(icOpr2)) == 0);
		  PushWD(_LOGICALTYPE, &iiOpr1);
		  break;
		case CONTAIN_SS :  // "<string1> $ <string2>"
		  strcpy(icOpr2, (C_PTR)PopWD());
		  strcpy(icOpr1, (C_PTR)PopWD());
		  iiOpr1 = ((strstr(icOpr2, icOpr1) != NULL) ? 1 : 0);
		  PushWD(_LOGICALTYPE, &iiOpr1);
		  break;
      case CEQ_LL :
        iiOpr2 = *(L_PTR)PopWD();
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr3 = (iiOpr1 == iiOpr2);
        PushWD(_LOGICALTYPE, &iiOpr3);
        break;
      case CGT_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 > inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CGT_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 > inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CGT_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = (strcmp(icOpr1, icOpr2) > 0);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CLT_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 < inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CLT_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 < inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CLT_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = (strcmp(icOpr1, icOpr2) < 0);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CNE_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 != inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CNE_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 != inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CNE_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        if (*icOpr1 || *icOpr2)
          iiOpr1 = (strcmp(icOpr1, icOpr2) != 0);
        else
          iiOpr1 = FALSE;
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CNE_LL :
        iiOpr2 = *(L_PTR)PopWD();
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr3 = (iiOpr1 != iiOpr2);
        PushWD(_LOGICALTYPE, &iiOpr3);
        break;
      case CLE_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 <= inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CLE_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 <= inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CLE_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = (strcmp(icOpr1, icOpr2) <= 0);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CGE_NN :
        inOpr2 = *(N_PTR)PopWD();
        inOpr1 = *(N_PTR)PopWD();
        iiOpr1 = (inOpr1 >= inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CGE_DD :
        inOpr2 = *(D_PTR)PopWD();
        inOpr1 = *(D_PTR)PopWD();
        iiOpr1 = (inOpr1 >= inOpr2);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CGE_SS :
        strcpy(icOpr2, (C_PTR)PopWD());
        strcpy(icOpr1, (C_PTR)PopWD());
        iiOpr1 = (strcmp(icOpr1, icOpr2) >= 0);
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case OR_LL :
        iiOpr2 = *(L_PTR)PopWD();
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr3 = (iiOpr1 || iiOpr2);
        PushWD(_LOGICALTYPE, &iiOpr3);
        break;
      case AND_LL :
        iiOpr2 = *(L_PTR)PopWD();
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr3 = (iiOpr1 && iiOpr2);
        PushWD(_LOGICALTYPE, &iiOpr3);
        break;
      case NOT_L :
        iiOpr1 = *(L_PTR)PopWD();
        iiOpr1 = !iiOpr1;
        PushWD(_LOGICALTYPE, &iiOpr1);
        break;
      case CHS_N :
        inOpr1 = *(N_PTR)PopWD();
        inOpr2 = -inOpr1;
        PushWD(_NUMBERTYPE, &inOpr2);
        break;
    }
}

void *Evaluate(PParseBufferStruct handle)
{
  if (!handle)
    return NULL;
  InitEngine(handle);
  BuildNewKey();
  return handle->ReturnPtr;
}
  
