/* filename: DCACHE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <string.h>
#include <index.h>

#ifdef NDX_TYPE
BOOL SetCacheTo(size_t size)
#else
BOOL SetCacheTo(size_t size, const char *filename)
#endif
{
#ifndef NDX_TYPE
  char   ErrorStr[81];
#endif
  size_t tmp;

  if (NeverCacheIndexes)
    size = 0U;
#ifndef NDX_TYPE
  if (MultiUser && (size > 0U)) {
    SetError(254, 1, Cannot_use_cache_in_MultiUser_mode);
    return size = 0U;
  }
#endif
  if (size) {
    size &= 0xFE00;
    if (size < 0x800)
      size = 0x800; // set 4 x 512b blocks at least
    if (CacheMemSize[Selected] == size)
      return TRUE;
  }
  if (Cache[Selected]) {
    FreePtrClear((void*) &Cache[Selected]);
#ifdef NDX_TYPE
    FreePtrClear((void*) &CachePtrs[Selected]);
    CachePtrsCount[Selected] = 0;
#else
    CNSize[Selected] = CCacheSize[Selected] = 0U;
#endif
  }
  CacheMemSize[Selected] = size;
  if (size == 0U) // programmer just wants to free the memory
    return TRUE;
#ifdef NDX_TYPE
  tmp = (size/BLOCK_SIZE) * (sizeof(void *) + sizeof(long));
  CachePtrs[Selected] = malloc(tmp);
  if (CachePtrs[Selected] == NULL) {// not a real error..do not Set Error
    CacheMemSize[Selected] = 0;
    return FALSE;
  }
  CachePtrsCount[Selected] = size / BLOCK_SIZE;
  memset(CachePtrs[Selected], 0, tmp);
#else
  if (filename) // index not open
    tmp = GetNodeSize(filename, ErrorStr);
  else {
    if (Ind[Selected][0])
      tmp = (size_t) Ind[Selected][0]->NodeSize;
    else {
      SetError(221, 1, " [SetCacheTo]");
      return FALSE;
    }
  }
  if ((CNSize[Selected] = (int) tmp) != 0)
    CCacheSize[Selected] = size / tmp;
#endif
  Cache[Selected] = (char**) malloc(size);
  if (Cache[Selected]) {
    memset(Cache[Selected], 0, size);
    return TRUE;
  }
  else {
    CacheMemSize[Selected] = 0;
#ifdef NDX_TYPE
    free(CachePtrs[Selected]);
    CachePtrsCount[Selected] = 0;
#endif
    return FALSE;
  }
}

void DeallocateCache(int area)
{
  int save = Selected;

  Selected = area;
#ifdef NDX_TYPE
  SetCacheTo(0U);
#else
  SetCacheTo(0U, NULL);
#endif
  Selected = save;
}
  
