/* filename: COMPKEYS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <string.h>
#include <sayget.h>
#include <index.h>

#ifdef NDX_TYPE
extern long RecNoForDelete;
#endif

extern int OrderChanged;

#ifndef NET

void CompareKeys(void)
{
  char  newkey[101];
  int order, len;
  PIndexType p;
  PNode pi;
  int saveZerOrder = ZerOrder[Selected];
#ifdef NDX_TYPE
  char  oldkey[101];
#else
  int saveSoundexFlag, saveDescending;
#endif
  ZerOrder[Selected] = 0;
  for (order = 0; order < MaxOrder; order++) {
    p = Ind[Selected][order];
    if (p) {
#ifdef NDX_TYPE
      len = p->header.key_len;
      SyncPOrder = order; // for parser
      memcpy( newkey, FarKey(order), len+1);
      if ((strlen(newkey) != (size_t) len) && p->kiss)
#else
      len = p->KeyLength;
      strcpy(newkey,FarKey(order));
      if (strlen(newkey) != (size_t) len)
#endif
      {
        ZerOrder[Selected] = saveZerOrder;
        SetError(BadSize,11,incorrect_key_length_returned_by_user_defined_keymaker,
        "\r\n",expected_length,SInteger(len, 3),
        "\r\n",key_equals,"[",newkey,"] ",IndexName(order)," [CompareKeys]");
        assertJumper();
        return;
      }
      if (memcmp(newkey, p->KeyStorage, len) != 0) {
        // if there is only one record in the file, just edit
        // the one node in the tree:
        if (RecCount() == 1L) {
          pi = p->Index;
          pi->DBFRecNo = 1;
#ifdef NDX_TYPE
          memcpy(pi->Key, newkey, len);
          memcpy(p->KeyStorage,newkey, len);
          // now write the new node back to disk
          if (!SeekAndWrite(Selected,order,p->header.root,p->BlockBufferPtr))
          {
            ZerOrder[Selected] = saveZerOrder;
            return;
          }
          continue;
        }
#else
          pi->GrtrNode = pi->LessNode = pi->PreviousNode = 0;
          pi->Entry = 1;
          strcpy(pi->Key,newkey);
          strcpy(p->KeyStorage,newkey);
          // now write the new node back to disk
          if (!SeekAndWrite(Selected, order, 1L, pi)) {
            ZerOrder[Selected] = saveZerOrder;
            return;
          }
          continue;
        }
        InhibitGo = TRUE;   //  don't move the database
#endif
        if (order != SyncOrder)
          OrderChanged = 1;
        SyncOrder = order;
        // NOTE: this can be optimized: don't call FIND
        //   if we are already on the correct record !
#ifdef NDX_TYPE
        _Find(p->KeyStorage);   //  find old key
#else
        saveSoundexFlag = p->SoundexFlag;
        saveDescending = p->Descending;
        p->SoundexFlag = FALSE;
        p->Descending = FALSE;
        Find(p->KeyStorage);   //  find old key
        p->SoundexFlag = saveSoundexFlag;
        p->Descending = saveDescending;
#endif
        if (DBFError) {
          ZerOrder[Selected] = saveZerOrder;
          return;
        }
        if (!Found) {  // this shouldn't occur
          ZerOrder[Selected] = saveZerOrder;
          SetError(254,6,stored_key,*p->KeyStorage,
          not_found," ",IndexName(order)," [CompareKeys]");
          assertJumper();
          return;
        }
        // we found a key that matches, but if we have
        // duplicate keys, then we need to scan the tree
        // looking for the right record number:
        pi = p->Index;
#ifdef NDX_TYPE
        while ((memcmp(pi->Key,p->KeyStorage,len) == 0)
          && (pi->DBFRecNo != RecNo()) && (!p->EOFFlag) )
          FindNextRecFunc();
        memcpy(oldkey, p->Index->Key, p->header.key_len);
        RecNoForDelete = RecNo();
        if (DeleteIndexNode(oldkey, order) == -1)
          DBFError = 1;
#else
        while ((memcmp(pi->Key,p->KeyStorage,len) == 0)
          && (pi->DBFRecNo != RecNo())
          && (pi->DBFRecNo != p->Anchor.LastRec))
          FindNextRecFunc();
        DeleteIndexNode(order);//  delete old key
#endif
        if (DBFError) {
          ZerOrder[Selected] = saveZerOrder;
          return;
        }
        AppendIndex(newkey, order);// put new key into index
        if (SyncOrder)
          OrderChanged = 1;
        SyncOrder = 0;
        InhibitGo = FALSE;
      }
    }
  }
  ZerOrder[Selected] = saveZerOrder;
}

#else

void CompareKeys(void)  // this is a network version
// assumes SyncIndex has been called first
// data for current record has changed in memory but not on disk yet
{
  PIndexType  p;
  int  order, len;
  char newkey[101];
#ifdef NDX_TYPE
  char oldkey[101];
#endif
  int saveZerOrder = ZerOrder[Selected];

  ZerOrder[Selected] = 0;
  for(order = 0; order < MaxOrder; order++) {
    p = Ind[Selected][order];
    if(p) {
#ifdef NDX_TYPE
      len = p->header.key_len;
      SyncPOrder = order; // for parser
      memcpy(newkey, FarKey(order), len+1);
      if (strlen(newkey) != (size_t) len && p->kiss)
#else
      len = p->KeyLength;
      strcpy(newkey, FarKey(order));
      if (strlen(newkey) != (size_t) len)
#endif
      {
        ZerOrder[Selected] = saveZerOrder;
        SetError(BadSize,11,incorrect_key_length_returned_by_user_defined_keymaker,
        "\r\n",expected_length,SInteger(len,3),
        "\r\n",key_equals,"[",newkey,"] ",IndexName(order)," [CompareKeys]");
        assertJumper();
        return;
      }
      // prove that syncindex did its job:
      if (p->Index->DBFRecNo != RecNo()) {
        ZerOrder[Selected] = saveZerOrder;
        SetError(254,6,record_number,SInteger(RecNo(),0),
        not_found_in_index," ",IndexName(order)," [CompareKeys]");
        assertJumper();
        return;
      }
      if (memcmp(newkey, p->Index->Key, len)) {
        // if there is only one record in the file,
        // just edit the one node in the tree:
        if (RecCount() == 1L) {
          strcpy(p->Index->Key,newkey);
          strcpy(p->KeyStorage,newkey);
          // now write the new node back to disk
#ifdef NDX_TYPE
          if (!SeekAndWrite(Selected,order,p->header.root,p->BlockBufferPtr))
#else
          if (!SeekAndWrite(Selected,order,1L,p->Index))
#endif
          {
            ZerOrder[Selected] = saveZerOrder;
            return;
          }
        }
        else {
          if (order != SyncOrder)
            OrderChanged = 1;
          SyncOrder = order;
#ifdef NDX_TYPE
          memcpy(oldkey, p->Index->Key, p->header.key_len);
          RecNoForDelete = RecNo();
          if (DeleteIndexNode( oldkey, order ) == -1)
            DBFError = 1;
#else
          DeleteIndexNode(order);// delete old key
#endif
          if(DBFError) {
            ZerOrder[Selected] = saveZerOrder;
            return;
          }
          AppendIndex(newkey,order);// put new key into index
          if (DBFError) {
            ZerOrder[Selected] = saveZerOrder;
            return;
          }
          if (SyncOrder)
            OrderChanged = 1;
          SyncOrder = 0;
        }
      }
    }
  }
  ZerOrder[Selected] = saveZerOrder;
}
#endif // NET
