/* filename: CLOS1IDX.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdlib.h>
#include <io.h>
#include <index.h>
#include <dbf.h>

void CloseOneIndex(int area, int order)
// closes just ONE index in an area for a certain order
{
  int i = 0;
  PIndexType p;
#ifdef NET
  int MoreOpen;
#endif
  char *errmsg;

  p = Ind[area][order];
  if (p) {
    if (p->Modified) {
#ifdef NET
      if (!IsExclusive()) { // lock and unlock the file
        DBFError = LockUnlock(0, p->Ndx, 0L, 1L);
        if (DBFError) {
          errmsg = Could_not_lock_index_for_writing_anchor_node;
          goto bailout;
        }
        WriteAnchorNode(area, order);
        DBFError = LockUnlock(1, p->Ndx, 0L, 1L);
        if (DBFError) {
          errmsg = Could_not_unlock_index_after_writing_anchor_node;
          goto bailout;
        }
      }
      else // write without locking-unlosking
#endif
      WriteAnchorNode(area, order);
      if (DBFError)
        return;
    }
    DeallocateKeyStorage(area, order);
    // if this is the primary index , release the cache and pseudonode:
    if (!order) {
      DeallocateCache(area);
      DeallocatePseudoNode(area);
    }
    if (close(p->Ndx))
      i = _doserrno;
    FreePtrClear((void*) &p->fname);
    DeallocateInd(area,order);
    SaveInd[area][order] = NULL;
    if (i) {
      DBFError = i;
      errmsg = error_closing_index_file;
      goto bailout;
    }
#ifdef NET
    MoreOpen = FALSE;
    for (i = 0; i < MaxOrder; i++)
      if (Ind[area][i])
        MoreOpen = TRUE;
    if (!MoreOpen)
      HandleSemaphore((char)area, Logout);
#endif
  }
  return;

bailout:
  SetError(DBFError, 3, errmsg, IndexName(order), " [CloseOneIndex]");
  assertJumper();
}

